#!/bin/sh

default_btn_led() {
TMP_FILE=/tmp/default_button_time
while [ -e $TMP_FILE ]
do
	sleep 1
	status=$(cat /proc/button/default)
	[ "$status" == "0" ] && {
		rm $TMP_FILE
		return
	}
	logger "default button is pressed..."
	if [ -e $TMP_FILE ]; then
		START=$(cat /tmp/default_button_time)
		END=$(date +%s)
		DIFF=$(($END - $START))
		if [ "$DIFF" -ge "5" ]; then
			logger " release the default button to start factory default and reboot "
			cnt=0
			while [ -e $TMP_FILE ] 
			do
				usleep 100000
				echo toggle > /proc/gpio/LED0
				cnt=$(($cnt+1))
				if [ $cnt -ge 20 ]; then
					echo on > /proc/gpio/LED0
					# do factory default
					logger "Trigger released event for default button..."
					echo 0 > /tmp/default_button_time
					ACTION=released BUTTON=default /sbin/hotplug-call button
					return
				fi
			done
		fi
	else
		logger " $TMP_FILE not found "
	fi
done
}

act_led() {
	local DSTime=0
	local WSTime=0
	local WSession=0
	while [ 1 ]
	do
		sleep 1
		echo toggle > /proc/gpio/LED0

		if [ -f /proc/net/ipsec_spi ]; then
			vpn=$(cat /proc/net/ipsec_spi)
		fi
		pptp=$(cat /var/state/network | grep -c -E "vpnup.ppp")
	    vpdrv=$(lsmod | grep vpdrv)
        if [ -n "$vpn" -o "$pptp" != "0" ]; then
        	if [ -z "$vpdrv" ]; then
            	echo on > /proc/gpio/LED4
            fi
        else
        	if [ -z "$vpdrv" ]; then
            	echo off > /proc/gpio/LED4
            fi
        fi
		
		uptime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		
		if [ $uptime -ge $DSTime ]; then
			DSTime=$(($DSTime+300))
			/sbin/rapi_client -g | grep '^1' | awk '{print $2","$3}' >> /tmp/traffic.log  #wan port RX,TX bytes
			Session_count=`cat /proc/net/ip_conntrack | wc -l || echo 0`
			echo "$Session_count" >> /tmp/session.log &  # session count from ip_conntrack
			WSession=$(($WSession+$Session_count))
		fi
		if [ $uptime -ge $WSTime ]; then
			WSTime=$(($WSTime+1800))
			/sbin/rapi_client -g | grep '^1' | awk '{print $2","$3}' >> /tmp/traffic_w.log  #wan port RX,TX bytes
			WSession=$(($WSession/6))
			echo "$WSession" >> /tmp/session_w.log &  # session count from ip_conntrack
			WSession=0
			tail -n 360 /tmp/traffic.log > /tmp/tr.tmp; cp /tmp/tr.tmp /tmp/traffic.log
			tail -n 360 /tmp/session.log > /tmp/tr.tmp; cp /tmp/tr.tmp /tmp/session.log
			tail -n 360 /tmp/traffic_w.log > /tmp/tr.tmp; cp /tmp/tr.tmp /tmp/traffic_w.log
			tail -n 360 /tmp/session_w.log > /tmp/tr.tmp; cp /tmp/tr.tmp /tmp/session_w.log			
		fi
		
		if [ $((uptime & 31)) == "0" ]; then
			wifi=$(uci -q -P /var/state get network.wifi_device)
			running=$(uci -q -P /var/state get network.wifi_running)
			radio=$(uci -q get wireless.ra0.radio)
			if [ "$wifi" == "1" -a "$radio" == "1" -a "$running" != "1" ]; then
				ssid=$(iwconfig ra0 2>/dev/null | grep "ESSID" | cut -d '"' -f 2 2>/dev/null)
				cfg_ssid=$(uci -q get wireless.@wifi-iface[0].ssid)
				reload=$(iwconfig ra0 | grep -q "${cfg_ssid}" && echo '0' || echo '1')
				if [ -n "$cfg_ssid" -a "$reload" == "1" ]; then
					logger "wifi SSID error: '$ssid' ; restart wifi now..."
					ps | grep -E "wifi up|wifi reload" | grep -q -v grep || wifi reload &
				fi
			else
				uci revert -P /var/state/ network.wifi_running
			fi
			ps | grep -v grep | grep -q dray_fwup || {
				op_mode=$(uci -q get vdsl.@vdsl[0].op_mode)
				if [ "$op_mode" == "" -o "$op_mode" == "0" ]; then
					logger "Restart Draytek firmware upgrade utility."
					/bin/dray_fwup &
				fi
			}
			
			tr069_enable=$(uci -q get tr069.@tr069[0].cpe_enable || echo '0')
			if [ "$tr069_enable" == "1" ]; then
				ps=$(ps | grep -v grep | grep -c tr069_client)
				if [ "$ps" != "0" ]; then
					mem=$(top -n 1 | grep tr069_client | awk '{sub(/^[ \t]+/, ""); print}' |  awk ' FS="[ %]+" { print $6 }')
					if [ $mem -gt 10 ]; then
						logger "Restart tr069_client: memory leak"
						top -b -n 1 > /var/log/tr069_debug
						/etc/init.d/tr069 restart > /dev/null 2>&1
					fi
				else
					ps > /var/log/tr069_debug
					logger "Restart TR-069: no daemon found $ps"
					logread > /var/log/tr069_debug
					/etc/init.d/tr069 start > /dev/null 2>&1 
				fi
			fi
		fi
		# run cgi in background
		[ -f /tmp/cgi_run_* ] && {
			for i in /tmp/cgi_run_*; do
				grep -q ScRiPt $i || continue
				echo "========cgi_run============= $i  " > /dev/console 2>&1
				j=/tmp/R"$(basename $i)"
				mv $i $j || continue
				sh $j && rm -f $j > /dev/null 2>&1 &
			done
		}		
	done
}

get_wps_status() {
	WPSing=1
	if [ ! -f /tmp/wps0.log ]; then
		dmesg > /tmp/wps0.log
	fi
	
	iwpriv ra0 set Debug=3
	iwpriv ra0 set Console=1
	iwpriv ra0 set WscStatus=0
	dmesg > /tmp/wps1.log
	diff -u -s /tmp/wps0.log /tmp/wps1.log > /tmp/wps_diff.log
	if cat /tmp/wps_diff.log | grep "are identical"; then
		iwpriv ra0 set WscStatus=0
		return $WPSing
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=34\)"; then
        WPSing=0	# configured
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=1\)"; then
        WPSing=0	# idle
	fi
	if cat /tmp/wps_diff.log | grep -E "^\+IF.*\(WscStatus=0\)"; then
        WPSing=0	# not used
	fi
	
	iwpriv ra0 set Debug=0
	iwpriv ra0 set Console=0
	rm /tmp/wps0.log
	rm /tmp/wps1.log
	rm /tmp/wps_diff.log 
	return $WPSing
}

wps_btn_led() {
	WPS_stop=$(($(date +%s)+122))
	touch /tmp/wpsing.tmp	# wps is running...
	while [ 1 ]
	do
		usleep 200000
		echo toggle > /proc/gpio/LED7

		# check wps status: if not act return;
		if ( get_wps_status ); then
			echo on > /proc/gpio/LED7
			iwpriv ra0 set Debug=0
			iwpriv ra0 set Console=0
			rm /tmp/wpsing.tmp
			return;
		fi

		if [ "$(date +%s)" -ge "$WPS_stop" ]; then
			echo on > /proc/gpio/LED7
			iwpriv ra0 set Debug=0
			iwpriv ra0 set Console=0
			rm /tmp/wpsing.tmp
			return;
		fi
	done
}

case "$1" in
	default) default_btn_led;;
	act) act_led;;
	wps) wps_btn_led;;
	*) logger "vigor LED control";;
esac
