#!/bin/sh
. /etc/functions.sh

set_webfilter() {
	local ENABLE
	local F_TYPE
	local F_URL
	local F_START_IP
	local F_END_IP
	
	config_get_bool ENABLE  $1	enable  0
	if [ $ENABLE -eq 1 ]; then
		config_get F_TYPE $1 type
		config_get F_URL $1	value
		config_get F_START_IP $1 start_ip
		config_get F_END_IP $1 end_ip
		config_get time_obj $1 time_obj -1		
		
		if [ -z "$F_START_IP" ]; then			
			F_START_IP="0.0.0.0"
		fi
		
		if [ -z "$F_END_IP" ]; then		
			F_END_IP="255.255.255.255"
		fi				 		
		xt_time=""
		trim() { echo $1; }
		[ "$time_obj" == "-1" ] || {		#set time obj
			delete=`uci -q get time_obj.$time_obj.delete || echo 0`
			[ "$delete" == "1" ] && xt_time="" ||
			{
				dstart=`uci -q get time_obj.$time_obj.datestart`
				dstop=`uci -q get time_obj.$time_obj.datestop`
				tsatrt=`uci -q get time_obj.$time_obj.timestart`
				tstop=`uci -q get time_obj.$time_obj.timestop`
				weekdays=`uci -q get time_obj.$time_obj.weekdays`
				xt_time=$(trim "${dstart:+--datestart $dstart} ${dstop:+--datestop $dstop} ${tsatrt:+--timestart $tsatrt} ${tstop:+--timestop $tstop} ${weekdays:+--weekdays $weekdays}")
			}
		}
			
		case "$F_TYPE" in 
		content)
			iptables -A web_filter_rule -p tcp -m tcp --dport 80 \
			${xt_time:+-m time $xt_time --tz $(date +%z | cut -c1-3):$(date +%z | cut -c4-5)} \
			-m webstr --content $F_URL -j DROP
			iptables -A web_filter_rule -p tcp -m tcp --dport 3128 \
			${xt_time:+-m time $xt_time --tz $(date +%z | cut -c1-3):$(date +%z | cut -c4-5)} \
			-m webstr --content $F_URL -j DROP
			iptables -A web_filter_rule -p tcp -m tcp --dport 8080 \
			${xt_time:+-m time $xt_time --tz $(date +%z | cut -c1-3):$(date +%z | cut -c4-5)} \
			-m webstr --content $F_URL -j DROP
		;;
		
		url)
			iptables -A web_filter_rule -p tcp -m tcp \
			-m iprange --src-range $F_START_IP-$F_END_IP \
			${xt_time:+-m time $xt_time --tz $(date +%z | cut -c1-3):$(date +%z | cut -c4-5)} \
			-m webstr --url $F_URL -j DROP
		;;
		
		host)
			iptables -A web_filter_rule -p tcp -m tcp \
			-m iprange --src-range $F_START_IP-$F_END_IP \
			${xt_time:+-m time $xt_time --tz $(date +%z | cut -c1-3):$(date +%z | cut -c4-5)} \
			-m webstr --host $F_URL -j DROP
		;;
		esac

	fi
}

# Add Web filter rule
if [ -f /etc/config/webfilter ]; then
	# delete all rule
	iptables -t filter -F web_filter_rule 2>/dev/null || (iptables -N web_filter_rule; iptables -I forward_csm -j web_filter_rule)

    config_load /etc/config/webfilter
    config_foreach set_webfilter webfilter
	
	# restart HNAT
	/etc/init.d/shnat_cli restart > /dev/null 2>&1
fi