#!/bin/sh

# Copyright (C) 2011 Draytek
# to start/stop WIDE-DHCPv6 client/server

#DEBUG=Df

[ -z $WAN ] && WAN=br-wan

#If br-wan up, use br-wan as default value; or use eth1.2
br_wan=$(ifconfig | grep br-wan)
[ -z "$br_wan" ] && WAN=eth1.2
v4WAN_proto=$(uci get -q network.wan.proto)
v6WAN_MODE=$(uci -q get ipv6.wan.mode)
#WAN is pppoe
if [ "$v4WAN_proto" = "pppoe" -a "$v6WAN_MODE" = "ppp" ]; then
	WAN=ppp0
fi

LAN=br-lan
DHCP6C=/usr/sbin/wide-dhcp6c
DHCP6S=/usr/sbin/wide-dhcp6s
LAN_STATIC_IPv6=$(uci -q get ipv6.lan.global_addr | tr A-Z a-z)

for DIR in /etc/dhcp6 /var/db; do
  [ ! -d $DIR ] && mkdir -p $DIR 2>/dev/null
done

usage()
{
  echo "usage:" >&2
  echo "  $0 client <start [iapd|iana|both] | stop>" >&2
  echo "  $0 server <start|stop>" >&2
  exit 1
}

get_lan_prefix()
{
  #ifconfig $LAN | grep "inet6 addr" | grep -v -E "fe80::|/128" | sed -e "s/^.*inet6 addr: //" -e "s/ Scope.*\$//"
  if [ $LAN_STATIC_IPv6 ]; then
	ifconfig br-lan | grep "inet6 addr" | grep -v -E "fe80::|/128" | grep -v "$LAN_STATIC_IPv6" | sed -e "s/^.*inet6 addr: //" -e "s/ Scope.*\$//"
  else
	ifconfig br-lan | grep "inet6 addr" | grep -v -E "fe80::|/128" | sed -e "s/^.*inet6 addr: //" -e "s/ Scope.*\$//"
  fi
}

waiting_for_lan_prefix()
{
  TIMEOUT=15    # second
  while [ $TIMEOUT -ge 0 ]; do
    sleep 1
    PREFIXES=`get_lan_prefix`
	#echo "***********waiting_for_lan_prefix():$TIMEOUT $PREFIXES">/dev/console	
    [ $PREFIXES ] && break
    TIMEOUT=`expr $TIMEOUT - 1`
  done
}

add_addr_into_wan()
{
	#if $PREFIXES is "2001:b010:7480:200:250:7fff:fe22:123a/64"
	tmp1=$(echo $PREFIXES | sed -e "s/\/.*$//" -e "s/^.*\(.\)/\1/" | tr A-Z a-z) #a
	tmp2=$(echo $PREFIXES | sed -e "s/\/.*$//" -e "s/.$//" | tr A-Z a-z) #2001:b010:7480:200:250:7fff:fe22:123
	
	#There has no bach command support hexadecimal computation in Vigor2130...
	if [ "$tmp1" = "f" -o "$tmp1" = "d" ]; then
		tmp1="e"
	elif [ "$tmp1" = "e" ]; then
		tmp1="f"
	elif [ "$tmp1" = "c" ]; then
		tmp1="d"
	elif [ "$tmp1" = "b" ]; then
		tmp1="c"
	elif [ "$tmp1" = "a" ]; then
		tmp1="b"
	elif [ "$tmp1" = "9" ]; then
		tmp1="a"
	else
		tmp1=`expr $tmp1 + 1`
	fi
	
	#add a address into wan interface
	ip addr add $tmp2$tmp1 dev $WAN
}

config_dhcp6c_iapd()
{
  echo "interface $WAN {" > $CONF
  echo "  send ia-pd $IAID;" >> $CONF
  echo "  request domain-name-servers,domain-name;" >> $CONF
  echo "  script \"/etc/dhcp6/dhcp6c-script\";" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc pd $IAID {" >> $CONF
  echo "  prefix-interface $LAN {" >> $CONF
  echo "    sla-id 1;" >> $CONF
  echo "    sla-len 16;" >> $CONF
  echo "  };" >> $CONF
  echo "};" >> $CONF
}

config_dhcp6c_iana()
{
  echo "interface $WAN {" > $CONF
  echo "  send ia-na $IAID;" >> $CONF
  echo "  request domain-name-servers,domain-name;" >> $CONF
  echo "  script \"/etc/dhcp6/dhcp6c-script\";" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc na $IAID {" >> $CONF
  echo "};" >> $CONF
}

config_dhcp6c_both()
{
  echo "interface $WAN {" > $CONF
  echo "  send ia-pd $IAID;" >> $CONF
  echo "  send ia-na 0;" >> $CONF
  echo "  request domain-name-servers,domain-name;" >> $CONF
  echo "  script \"/etc/dhcp6/dhcp6c-script\";" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc pd $IAID {" >> $CONF
  echo "  prefix-interface $LAN {" >> $CONF
  echo "    sla-id 1;" >> $CONF
  echo "    sla-len 16;" >> $CONF
  echo "  };" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc na 0 {" >> $CONF
  echo "};" >> $CONF
}

config_dhcp6s()
{
  LAN_ADDR_START=`nvram_get v6_lan_dhcp_addr_start`
  LAN_ADDR_END=`nvram_get v6_lan_dhcp_addr_end`
  DNS1=`nvram_get v6_lan_dhcp_dns1`
  DNS2=`nvram_get v6_lan_dhcp_dns2`

  ([ -z $LAN_ADDR_START ] || [ -z $LAN_ADDR_END ]) && echo "$0: no IP range configured for dhcp6s" >&2 && exit 1
  [ $DNS1 ] && [ $DNS1 == $DNS2 ] && DNS2=

  # TODO: address sanity check

  echo "interface $LAN {" > $CONF
  echo "  address-pool mynetwork 3600; " >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "pool mynetwork {" >> $CONF
  echo "  range $LAN_ADDR_START to $LAN_ADDR_END;" >> $CONF
  echo "};" >> $CONF

  if [ $DNS1 ]; then
    echo >> $CONF
    echo "option domain-name-servers $DNS1 $DNS2;" >> $CONF
  fi
}

stop_client()
{
  killall wide-dhcp6c 2>/dev/null
  killall radvd 2>/dev/null
}

stop_server()
{
  killall dhcp6s 2>/dev/null
}

start_client_iapd()
{
  stop_client
  config_dhcp6c_iapd
  #  -wSPr = send release, stateless(DUID-LL), want IAPD, start radvd
  OPT=-wSP
  [ "`uci -q get ipv6.lan.radvd_en`" -eq 1 ] && OPT=${OPT}r
  #echo "$DHCP6C $OPT -${DEBUG}c $CONF $WAN" >/dev/console
  $DHCP6C $OPT -${DEBUG}c $CONF $WAN
  #lan_ipv6=$(uci get ipv6.lan.global_addr)
  #if [ $lan_ipv6 ]; then
#	ifconfig br-lan $lan_ipv6/64
#  fi
}

start_client_iana()
{
  stop_client
  config_dhcp6c_iana
  $DHCP6C -${DEBUG}c $CONF $WAN
}

start_client_both()
{
  stop_client
  config_dhcp6c_both
  #  -wSPr = send release, stateless(DUID-LL), want IAPD, start radvd
  OPT=-wSP
  [ "`uci -q get ipv6.lan.radvd_en`" -eq 1 ] && OPT=${OPT}r
  #echo "$DHCP6C $OPT -${DEBUG}c $CONF $WAN" >/dev/console
  $DHCP6C $OPT -${DEBUG}c $CONF $WAN

  WAN_DNS1=$(uci get ipv6.wan_dhcp.dns1)
  WAN_DNS2=$(uci get ipv6.wan_dhcp.dns2)
  if [ $WAN_DNS1 ]; then
	echo "nameserver $WAN_DNS1" >> /etc/resolv.conf
  fi
  if [ $WAN_DNS2 ]; then
	echo "nameserver $WAN_DNS2" >> /etc/resolv.conf
  fi
}

# program entry
case $1 in
  "client")
    case $2 in
      "start")
        CONF=/etc/dhcp6/dhcp6c.conf
        IAID=15	#default 0, it can be change into config setting in the future.
        [ -z $IAID ] && IAID=0

        case $3 in
          "")
            IA=`uci -q get ipv6.wan.mode`
			if [ "$IA" == "dhcpv6-3" ]; then
				IA="pd"
			elif [ "$IA" == "dhcpv6" ]; then
				IA="na"
			elif [ "$IA" == "dhcpv6-4" ]; then
				IA="both"
			else
				echo "DHCP WAN mode is not in IANA"
			fi
            if ([ -z $IA ] || [ $IA == "pd" ]); then
              start_client_iapd && waiting_for_lan_prefix
			[ $PREFIXES ] && add_addr_into_wan
            elif [ $IA == "na" ]; then
              start_client_iana
            elif [ $IA == "both" ]; then
            	start_client_both
            else
              echo "$0: Unknown DHCPv6 ID association \"$IA\"" >&2
            fi
            ;;

          "iapd")
            start_client_iapd && waiting_for_lan_prefix
			[ $PREFIXES ] && add_addr_into_wan
            ;;

          "iana")
            start_client_iana
            ;;

          "both")
            start_client_both
            ;;

          *)usage
            ;;
        esac
        ;;

      "stop")
        stop_client
        ;;

      *)usage
        ;;
    esac
    ;;

  "server")
    case $2 in
      "start")
        stop_server
        CONF=/etc/dhcp6/dhcp6s.conf
        config_dhcp6s
        $DHCP6S -${DEBUG}c $CONF $LAN
        ;;

      "stop")
        stop_server
        ;;

      *)usage
        ;;
    esac
    ;;

  *)usage
    ;;
esac
