#!/bin/sh
[ -e /usr/sbin/pppoe-server ] || {
	echo "Install pppoe server..."
	opkg install -d root http://vigor2130.googlecode.com/files/rp-pppoe-server_3.10-1_arm.ipk
}

[ -e /usr/sbin/pppoe-server ] || {
	echo "Fail to install pppoe server"
	exit 1
}

grep -q pppoe-server /etc/ppp/chap-secrets || {
	echo "==>Add a default username/password: test/test in /etc/ppp/chap-secrets for pppoe dial in user"
	echo "test	pppoe-server	\"test\"	*" >> /etc/ppp/chap-secrets
}
echo "==>Start PPPoE Service in LAN, config file is /etc/ppp/pppoe-server-options"
killall pppoe-server
killall dray_fwup
killall led-control.sh
lsmod | grep -q pppoe || insmod pppoe
pppoe-server -k -L 192.168.10.100 -R 192.168.10.200 -I br-lan 
echo "ppp interface: ppp10, Local IP: 192.168.10.100, Remote IP from 192.168.10.200"

iptables -nvL -t nat | grep -q "MASQUERADE" | grep -q "192.168.1.0/24" || {
	echo "==>Add iptables NAT rule for ppp10 to internet" 
	iptables -t nat -I zone_wan_nat -o br-wan -s 192.168.10.0/24 -j MASQUERADE
	iptables -t nat -I zone_wan_nat -o ppp0 -s 192.168.10.0/24 -j MASQUERADE
	iptables -I FORWARD -i ppp10 -o br-wan -j ACCEPT
	iptables -I FORWARD -i ppp10 -o ppp0 -j ACCEPT
}	
