#!/bin/sh
domain=$1
iface=$2
dnsip=$3	# not work in nslookup now....

ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"

# backup the DNS config...see busybox Bug 675 - nslookup does not properly use second argument [SERVER]
# https://bugs.busybox.net/show_bug.cgi?id=675
cp /tmp/resolv.conf.auto /tmp/resolv.conf.auto.bk	

case "$iface" in
	"tr069" )	# from tr069
	acs_if=$(uci -q get tr069.@tr069[0].acs_sever_mngt || echo 0)
	[ "$acs_if" == "1" -a -f /tmp/resolv.conf.mngtwan ] && {	# mngtwan
		dnsip="${dnsip:-$(cat /tmp/resolv.conf.mngtwan 2>/dev/null | grep -o "$ip_regex" -m 1)}"
		cp /tmp/resolv.conf.mngtwan /tmp/resolv.conf.auto
		[ -n "$dnsip" ] && {
			ip rule del to $dnsip/32 table mngtwan 2>/dev/null
			ip rule add to $dnsip/32 table mngtwan 2>/dev/null
		}
	}
	;;
	
	"" )
	;;
	
	* )	# xxx_wan
		[ -f /tmp/resolv.conf."$iface" ] && {
			dnsip="${dnsip:-$(cat /tmp/resolv.conf."$iface" 2>/dev/null | grep -o "$ip_regex" -m 1)}"
			cp /tmp/resolv.conf.auto /tmp/resolv.conf.auto.bk
			cp /tmp/resolv.conf."$iface" /tmp/resolv.conf.auto
			### add route
			[ -n "$dnsip" ] && {
				ip rule del to $dnsip/32 table $iface 2>/dev/null
				ip rule add to $dnsip/32 table $iface 2>/dev/null
			}
		}
	;;
esac

registered_ip=$(echo $(nslookup "$domain" "${dnsip:+$dnsip}" 2>/dev/null) | grep -o "Name:.*" | grep -o "$ip_regex")
echo "$registered_ip"
cp /tmp/resolv.conf.auto.bk /tmp/resolv.conf.auto	# restore DNS config