#!/bin/sh

#this script is use to setup ipv6 static wan ip

WAN_IF=$(uci get ipv6.wan.ifname)
WAN_ADDR_v6=$(uci get ipv6.wan_static.global_addr)
WAN_PREFIX_LEN=$(uci get ipv6.wan_static.prefix_len)
WAN_GATEWAY=$(uci get ipv6.wan_static.gateway)

WAN_DNS1=$(uci get ipv6.wan_static.dns1)
WAN_DNS2=$(uci get ipv6.wan_static.dns2)

if [ $WAN_IF ]; then
	ifconfig $WAN_IF down
	ifconfig $WAN_IF up
else
	echo "Interface not set"
	exit 1
fi

if [ $WAN_ADDR_v6 ]; then
	if [ -n $WAN_PREFIX_LEN ]; then
	    ifconfig $WAN_IF $WAN_ADDR_v6/$WAN_PREFIX_LEN  
	fi
else
	echo "IPv6 address/prefix error"
fi

if [ $WAN_GATEWAY ]; then
    ip -6 route add default via $WAN_GATEWAY dev $WAN_IF
else
	echo "IPv6 gateway error"
fi

if [ $WAN_DNS1 ]; then
    echo "nameserver $WAN_DNS1" >> /etc/resolv.conf
fi

if [ $WAN_DNS2 ]; then
	echo "nameserver $WAN_DNS2" >> /etc/resolv.conf
fi
