#!/bin/sh

rtadvd=/usr/sbin/radvd
rtadvdconfigfile=/etc/tsp/tsprtadvd.conf
ifconfig=/sbin/ifconfig
sysctl=/sbin/sysctl
LAN_ADDR=$(uci -q get ipv6.lan.global_addr)
LAN_IF=$(uci -q get ipv6.lan.ifname)
LAN_PREFIX=$(uci -q get ipv6.lan.prefix)
v6in4_PREFIX=$(uci  -q get ipv6.wan_static_6in4.v6in4_lan_mask)
v6in4_PREFIX_LEN=$(uci -q get ipv6.wan_static_6in4.v6in4_lan_mask_len)
v6WAN_MODE=$(uci -q get ipv6.wan.mode)
LAN_PREFIX_LEN=$(uci -q get ipv6.lan.prefix_len)
ADV_TIME=$(uci -q get ipv6.lan_radvd.adv_time)
WAN_PREFIX=

if [ "$v6WAN_MODE" == "6to4" ]; then
	/sbin/6to4.sh start
	exit 0
elif [ "$v6WAN_MODE" == "tspc" ]; then
	[ -z "$LAN_ADDR" -a "`$ifconfig |grep tun`" -a -f $rtadvdconfigfile ] && {
		tmp=`cat $rtadvdconfigfile |grep prefix |sed 's/.*prefix //'`
		LAN_PREFIX=${tmp%%:/*}
		LAN_ADDR="${LAN_PREFIX}:1"
		LAN_PREFIX_LEN=${tmp##*/}
	}
else
	WAN_PREFIX=`ip -6 addr show |grep global |sed -e 's/.*inet6 //' |cut -d: -f1-4`
	[ "$WAN_PREFIX" ] && WAN_PREFIX=`echo $WAN_PREFIX |sed 's/ .*//'`
fi

if [ "$LAN_IF" -a "$v6WAN_MODE" != "ppp" ]; then
    ifconfig $LAN_IF down
    ifconfig $LAN_IF up
elif [ "$LAN_IF" == "" ]; then
	echo "Interface not set"
	exit 1
fi

$sysctl -w net.ipv6.conf.all.forwarding=1 # ipv6_forwarding enabled
if [ "$LAN_IF" -a "$LAN_ADDR" -a "$LAN_PREFIX_LEN" ]; then
	$ifconfig $LAN_IF add $LAN_ADDR/$LAN_PREFIX_LEN
elif [ -z "`$ifconfig $LAN_IF |grep Global`" -a "$WAN_PREFIX" ]; then
	tail=`ip -6 addr show $LAN_IF |grep link |sed -e 's/.*fe80:://' -e 's/\/64.*//'`
	$ifconfig $LAN_IF add $WAN_PREFIX:$tail/64
fi
if [ "$LAN_IF" -a "$v6WAN_MODE" == "static_6in4" ]; then
	v6in4_EUI64=$(uci -q get ipv6.lan.link_addr |sed 's/fe80:://')
	ip addr add $v6in4_PREFIX$v6in4_EUI64/$v6in4_PREFIX_LEN dev $LAN_IF
fi
# Router advertisement configuration 
echo "Create new $rtadvdconfigfile"
echo "##### rtadvd.conf made by TSP ####" > "$rtadvdconfigfile"
echo "interface $LAN_IF" >> "$rtadvdconfigfile"
echo "{" >> "$rtadvdconfigfile"
echo " AdvSendAdvert on;" >> "$rtadvdconfigfile"
echo " MaxRtrAdvInterval 90;" >> "$rtadvdconfigfile"
if [ $ADV_TIME ]; then
    echo " AdvDefaultLifetime $ADV_TIME;" >> "$rtadvdconfigfile"
else
	echo "Do not set ADV lifetime"
fi
if [ "$LAN_PREFIX" != "" ]; then
	echo " prefix $LAN_PREFIX:/64" >> "$rtadvdconfigfile"
	echo " {" >> "$rtadvdconfigfile"
	echo " AdvOnLink on;" >> "$rtadvdconfigfile"
	echo " AdvAutonomous on;" >> "$rtadvdconfigfile"
	echo " };" >> "$rtadvdconfigfile"
elif [ "$WAN_PREFIX" != "" ]; then
	echo " prefix $WAN_PREFIX::/64" >> "$rtadvdconfigfile"
	echo " {" >> "$rtadvdconfigfile"
	echo " AdvOnLink on;" >> "$rtadvdconfigfile"
	echo " AdvAutonomous on;" >> "$rtadvdconfigfile"
	echo " };" >> "$rtadvdconfigfile"
fi
if [ "$v6in4_PREFIX" != "" -a "$v6in4_PREFIX_LEN" != "" -a "$v6WAN_MODE" == "static_6in4" ]; then
	echo " prefix $v6in4_PREFIX:/$v6in4_PREFIX_LEN" >> "$rtadvdconfigfile"
	echo " {" >> "$rtadvdconfigfile"
	echo " AdvOnLink on;" >> "$rtadvdconfigfile"
	echo " AdvAutonomous on;" >> "$rtadvdconfigfile"
	echo " };" >> "$rtadvdconfigfile"
fi
echo "};" >> "$rtadvdconfigfile"
echo "" >> "$rtadvdconfigfile"

   if [ -f $rtadvdconfigfile ]; then
      $rtadvd -C $rtadvdconfigfile -m stderr_syslog -p /var/run/radvd.pid
      echo "Starting radvd: $rtadvd -C $rtadvdconfigfile -m stderr_syslog -p /var/run/radvd.pid"
   else
      echo "Error : file $rtadvdconfigfile not found"
      exit 1
   fi
