#!/bin/sh /etc/rc.common
# Copyright (C) 2008 OpenWrt.org

IPTABLES=ip6tables

rm6_setrule(){
	local http_en
	local http_port
	local https_en
	local https_port
	local ssh_en
	local ssh_port
	local icmp_en
	local ftp_en
	local ftp_port
	local tel_en
	local tel_port
	local wan_v6_ip
	
	config_get http_en $1 http_en
	config_get https_en $1 https_en
	config_get ssh_en $1 ssh_en
	config_get icmp_en $1 icmp_en
	config_get ftp_en $1 ftp_en
	config_get tel_en $1 tel_en
	
	if [ -f /etc/config/grocx/vtss_fw ]; then	
		https_port=$(sed -n '/socket/p' /etc/lighttpd-ssl.conf | awk 'FS="[:]+" {print $2}' | awk 'FS="[\"]+" {print $1}')
		http_port=$(sed -n '/^server.port/p' /etc/lighttpd.conf | awk 'FS="[=]+" {print $2}')
		if [ "$http_port" = "" ]; then
			http_port=80
		fi
		ssh_port=$(uci -c /etc/config/grocx -q get vtss_fw.@basic[0].ssh_port)
		ftp_port=$(uci -c /etc/config/grocx -q get vtss_fw.@basic[0].ftp_port)
		tel_port=$(uci -c /etc/config/grocx -q get vtss_fw.@basic[0].telnet_port)
	fi

	#Set default ACCEPT
	ip6tables --policy INPUT ACCEPT	
	
	#default input br-lan accept
	ip6tables -A INPUT -i br-lan -j ACCEPT
	
	#HTTP
	if [ "$http_en" == "1" ];then
		ip6tables -A INPUT -p tcp --dport $http_port -j ACCEPT
	fi
	#HTTPS
	if [ "$https_en" == "1" ];then
		ip6tables -A INPUT -p tcp --dport $https_port -j ACCEPT
	fi
	#SSH
	if [ "$ssh_en" == "1" ];then
		ip6tables -A INPUT -p tcp --dport $ssh_port -j ACCEPT
	fi
	#ICMP
	if [ "$icmp_en" == "0" ];then
		ip6tables -A INPUT -p icmpv6 --icmpv6-type echo-request -j DROP
	fi
	#FTP
	if [ "$ftp_en" == "1" ];then
		ip6tables -A INPUT -p tcp --dport $ftp_port -j ACCEPT
	fi
	#TELNET
	if [ "$tel_en" == "1" ];then
		ip6tables -A INPUT -p tcp --dport $tel_port -j ACCEPT
	fi
	#default accept DHCPv6 client port 
	ip6tables -A INPUT -p udp --dport 546 -j ACCEPT
	#default icmpv6 accept
	ip6tables -A INPUT -p icmpv6 -j ACCEPT
	#default reject tcp/udp new connection from WAN
	ip6tables -A INPUT -i br-wan -m state --state NEW -j DROP
	
}

rm6_defaults() {
	[ -n "$DEFAULTS_APPLIED" ] && {
		echo "Error: multiple defaults sections detected"
		return;
	}
	DEFAULTS_APPLIED=1
	$IPTABLES -F INPUT	
	if [ -f /etc/config/remote_mgr6 ]; then	
		config_load remote_mgr6 
		config_foreach rm6_setrule rm6_rule
	fi
}

rm6_init() {
	DEFAULTS_APPLIED=
	lock /var/lock/lock_remote_mgr6
	rm6_defaults	
	lock -u /var/lock/lock_remote_mgr6
}

rm6_stop() {
	lock /var/lock/lock_remote_mgr6
	$IPTABLES -F INPUT
	lock -u /var/lock/lock_remote_mgr6
}


#ipv6 firewall start
start() {
	rm6_init
}

#ipv6 firewall stop
stop() {
	rm6_stop	
}

