#ifndef __IP_SET_SERVICE_H
#define __IP_SET_SERVICE_H

#ifdef __KERNEL__
#include <linux/list.h>
#endif
#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SETTYPE_NAME		"service"

#ifdef __KERNEL__
struct ip_set_service {
	struct list_head head;
	u_int32_t size;
};
#endif

struct ip_set_req_service {
    u_int8_t  protocol;
    u_int16_t sptStart;
    u_int16_t sptEnd;
    u_int16_t dptStart;
    u_int16_t dptEnd;
};

struct ip_set_req_service_create {
	u_int32_t size;
};

#ifdef __KERNEL__
struct service_list {
	struct ip_set_req_service service;
	struct list_head list;
};
#endif

#endif /* __IP_SET_SERVICE_H */
