#ifndef __IP_SET_PROTOCOL_H
#define __IP_SET_PROTOCOL_H

#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SUPPORT_BPJM 			1
#define BPJM_TEST				0
#define SUPPORT_BLOCK_HTTPS 	1
#define SUPPORT_FRAGFINN 		1
#define FRAGFINN_TEST			0
#define SUPPORT_NO_HOST_CACHE	0


#define SETTYPE_NAME		"webcategory"

#define WEBCATEGORY_BLACK_NONE 0
#define WEBCATEGORY_ADVERTISEMENT_AND_POP_UPS 1
#define WEBCATEGORY_ALCOHOL_AND_TOBACCO 2
#define WEBCATEGORY_ANONYMIZERS 3
#define WEBCATEGORY_ARTS 4
#define WEBCATEGORY_BUSINESS 5
#define WEBCATEGORY_TRANSPORTATION 6
#define WEBCATEGORY_CHAT 7
#define WEBCATEGORY_FORUMS_AND_NEWSGROUPS 9
#define WEBCATEGORY_COMPROMISED 10
#define WEBCATEGORY_COMPUTERS_AND_TECHNOLOGY 11
#define WEBCATEGORY_CRIMINAL_AND_ACTIVITY 12
#define WEBCATEGORY_DATING_AND_PERSONALS 13
#define WEBCATEGORY_DOWN_SITES 14
#define WEBCATEGORY_EDUCATION 15
#define WEBCATEGORY_ENTERTAINMENT 16
#define WEBCATEGORY_FINANCE 17
#define WEBCATEGORY_GAMBLING 18
#define WEBCATEGORY_GAMES 19
#define WEBCATEGORY_GOVERNMENT 20
#define WEBCATEGORY_HATE_AND_INTOLERANCE 21
#define WEBCATEGORY_HEALTH_AND_MEDICINE 22
#define WEBCATEGORY_ILLEGAL_DRUG 23
#define WEBCATEGORY_JOB_SEARCH 24
#define WEBCATEGORY_STREAMING_MEDIA_AND_DOWNLOADS 26
#define WEBCATEGORY_NEWS 27
#define WEBCATEGORY_NON_PROFITS_AND_NGOS 28
#define WEBCATEGORY_NUDITY 29
#define WEBCATEGORY_PERSONAL_SITES 30
#define WEBCATEGORY_PHISHING_AND_FRAUD 31
#define WEBCATEGORY_POLITICS 32
#define WEBCATEGORY_PORNOGRAPHY_AND_SEXUALLY_EXPLICIT 33
#define WEBCATEGORY_REAL_ESTATE 34
#define WEBCATEGORY_RELIGION 35
#define WEBCATEGORY_RESTAURANTS_AND_DINING 36
#define WEBCATEGORY_SEARCH_ENGINES_AND_PORTALS 37
#define WEBCATEGORY_SHOPPING 38
#define WEBCATEGORY_SOCIAL_NETWORKING 39
#define WEBCATEGORY_SPAM_SITES 40
#define WEBCATEGORY_SPORTS 41
#define WEBCATEGORY_MALWARE 42
#define WEBCATEGORY_TRANSLATORS 44
#define WEBCATEGORY_TRAVEL 45
#define WEBCATEGORY_VIOLENCE 46
#define WEBCATEGORY_WEAPONS 47
#define WEBCATEGORY_WEB_BASED_EMAIL 48
#define WEBCATEGORY_GENERAL 49
#define WEBCATEGORY_LEISURE_AND_RECREATION 50
#define WEBCATEGORY_BOTNETS 61
#define WEBCATEGORY_CULTS 62
#define WEBCATEGORY_FASHION_AND_BEAUTY 63
#define WEBCATEGORY_GREETING_CARDS 64
#define WEBCATEGORY_HACKING 65
#define WEBCATEGORY_ILLEGAL_SOFTWARES 67
#define WEBCATEGORY_IMAGE_SHARING 68
#define WEBCATEGORY_INFORMATION_SECURITY 69
#define WEBCATEGORY_INSTANT_MESSAGING 70
#define WEBCATEGORY_NETWORK_ERRORS 71
#define WEBCATEGORY_PARKED_DOMAINS 72
#define WEBCATEGORY_PEER_TO_PEER 73
#define WEBCATEGORY_PRIVATE_IP_ADDRESS 74
#define WEBCATEGORY_SCHOOL_CHEATING 75
#define WEBCATEGORY_SEX_EDUCATION 76
#define WEBCATEGORY_TASTELESS 77
#define WEBCATEGORY_CHILD_ABUSE_IMAGES 78
#define WEBCATEGORY_UNCATEGORISED_SITES 79
#if SUPPORT_BPJM == 1 || SUPPORT_FRAGFINN == 1
#define WEBCATEGORY_YOUTH_PROTECTION 82
#define WEBCATEGORY_YOUTH_PROTECTION_FRAGFINN 83
#define WEBCATEGORY_MAX 84
#else
#define WEBCATEGORY_MAX 80
#endif


char *category_name[] = {
"None", "Advertisement_and_pop_ups", "Alcohol_and_tobacco", "Anonymizers", "Arts", //0~4
"Business", "Transportation", "Chat", "Forums_and_newsgroups", "Compromised", //5~9
"Compromised", "Computers_and_technology", "Criminal_and_activity", "Dating_and_personals", "Down_sites", //10~14
"Education", "Entertainment", "Finance", "Gambling", "Games", //15~19
"Government", "Hate_and_intolerance", "Health_and_medicine", "Illegal_drug", "Job_search", //20~24
"", "Streaming_media_and_downloads", "News", "Non_profits_and_ngos", "Nudity", //25~29
"Personal_sites", "Phishing_and_fraud", "Politics", "Pornography_and_sexually_explicit", "Real_estate", //30~34
"Religion", "Restaurants_and_dining", "Search_engines_and_portals", "Shopping", "Social_networking", //35~39
"Spam_sites", "Sports", "Malware", "", "Translators", //40~44
"Travel", "Violence", "Weapons", "Web_based_email", "General", //45~49
"Leisure_and_recreation", "", "", "", "", //50~54
"", "", "", "", "", //55~59
"", "Botnets", "Cults", "Fashion_and_beauty", "Greeting_cards", //60~64
"Hacking", "", "Illegal_softwares", "Image_sharing", "Information_security", //65~69
"Instant_messaging", "Network_errors", "Parked_domains", "Peer_to_peer", "Private_ip_address", //70~74
"School-cheating", "Sex-education", "Tasteless", "Child-abuse-images", "Uncategorised-sites", //75~79
#if SUPPORT_BPJM == 1 || SUPPORT_FRAGFINN == 1
"","","Youth-Protection","Youth-Protection-fragFINN", //80~83
#endif
};


#define WEBCATEGORY_FROM 0
#define WEBCATEGORY_TO WEBCATEGORY_MAX-1
#define WEBCATEGORY_NUM WEBCATEGORY_MAX

struct ip_set_webcategory {
	void *members;			/* the protocol proper */
	ip_set_ip_t first_ip;		/* host byte order, included in range */
	ip_set_ip_t last_ip;		/* host byte order, included in range */
	u_int32_t size;			/* size of the __IP_SET_PROTOCOL_H proper */
};

struct ip_set_req_webcategory_create {
	ip_set_ip_t from;
	ip_set_ip_t to;
};

struct ip_set_req_webcategory {
	ip_set_ip_t ip;
};

#define PROVIDER_COMMTOUCH 		1
#define PROVIDER_BPJM 	   		2
#define PROVIDER_FRAGFINN 	   	3

#define BPJM_PROTO_VERSION			1
#define FRAGFINN_PROTO_VERSION		2

#endif /* __IP_SET_PROTOCOL_H */
