#include "stdhead.h"
#include "renew.h"
#include "clilib.h"
#include "parse.h"
#include "solicit.h"

struct DHCP_MESSAGE * create_renew_message (struct DHCP_MESSAGE * server_reply, char * interface_name)
{
    struct DHCP_MESSAGE * renew_message_ptr = (struct DHCP_MESSAGE *) malloc (sizeof (struct DHCP_MESSAGE));
    struct OPTIONS * options_ptr;
    struct DUID *duid_ptr;
    struct IA *ia_ptr;
    struct IA_ADDRESS *iaaddr_ptr;
    struct interface *interface_details;
    
    renew_message_ptr -> u_msg_type.msg_type = RENEW;
    generate_trans_id (&renew_message_ptr -> u_trans_id.trans_id);

    interface_details = get_interface_details (interface_name);
    renew_message_ptr -> opt = add_client_id_option (interface_details);
    duid_ptr = (struct DUID *) renew_message_ptr -> opt -> opt_data;

    duid_ptr -> opt = copy_message_option (server_reply, OPTION_SERVERID);
    duid_ptr = (struct DUID *) duid_ptr -> opt -> opt_data;

    duid_ptr -> opt = copy_message_option (server_reply, OPTION_IA);
    ia_ptr = (struct IA *) duid_ptr -> opt -> opt_data;

    ia_ptr -> opt = copy_message_option (server_reply, OPTION_IAADDR);
    iaaddr_ptr = (struct IA_ADDRESS *) ia_ptr -> opt -> opt_data;
    iaaddr_ptr -> opt = 0;
    //fix OPTION_IA_length, add by bruce hsu
    fix_ia_option_length(server_reply, renew_message_ptr);
    return renew_message_ptr;
}
