scan_LTE() {
	uci_set_state network $1 device wimax0
}

stop_interface_LTE() {
	app_exist=$(ps | grep [l]te_d)
    if [ "$app_exist" = "" ]; then
      lte_d &
	  logger "lte.sh: start lte_d"
	  #echo "lte.sh: start lte_d" 
    fi

	killall -q udhcpc
	
	sleep 2
	
	ifconfig wimax0 down
	logger "lte.sh: LTE interface down"
	#echo "lte.sh: LTE interface down"
}

setup_interface_LTE() {
	local config="$2"
	
	set_interface_ifname "$config" wimax0
	
	app_exist=$(ps | grep [l]te_d)
    if [ "$app_exist" = "" ]; then
      lte_d &
	  logger "lte.sh: start lte_d"
	  #echo "lte.sh: start lte_d" 
    fi
	
	status2=`test -f /var/network/wimaxStatus2 && cat /var/network/wimaxStatus2`
	if [ "$status2" = "1" ]; then
		interfaceExist=`ifconfig -a | grep wimax0`
		if [ "$interfaceExist" != "" ]; then
			interfaceUp=$(ifconfig | grep wimax0)
			if [ "$interfaceUp" = "" ]; then
				ifconfig wimax0 up
			fi
		fi

		dhcpcExit=$(ps | grep udhcpc | grep wimax0)
		if [ "$dhcpcExit" = "" ]; then
			killall -q udhcpc
			while route del default ; do
				:
			done

			#wimax wan
			pidfile="/var/run/lte.pid"
			logger "udhcpc -t 0 -i wimax0 -b -p $pidfile"
			udhcpc -t 0 -i wimax0 -b -p "$pidfile" &

			logger "lte.sh: LTE interface up"
			#echo "lte.sh: LTE interface up"
		else
			logger "lte.sh: LTE interface already up"
			#echo "lte.sh: LTE interface already up"
		fi
	else
	    logger "lte.sh: LTE dongle isn't ready"
		#echo "lte.sh: LTE dongle isn't ready"
	fi
}
