#!/bin/sh
#
proto=$(uci -q get network.wan.proto)
if [ "$proto" != "LTE" ]; then
  return;
fi

if [ "$1" = "up" ]; then
	status2=`test -f /var/network/wimaxStatus2 && cat /var/network/wimaxStatus2`
	if [ "$status2" = "1" ]; then
		interfaceExist=`ifconfig -a | grep wimax0`
		if [ "$interfaceExist" != "" ]; then
			interfaceUp=$(ifconfig | grep wimax0)
			if [ "$interfaceUp" = "" ]; then
				ifconfig wimax0 up
			fi
			
			dhcpcExit=$(ps | grep udhcpc | grep wimax0)
			if [ "$dhcpcExit" = "" ]; then
				temp=`ps | grep "udhcpc" | grep "wimax0"`
				if [ "$temp" != "" ]; then
					exit 0
				fi
				sleep 1
				temp=`ps | grep "udhcpc" | grep "wimax0"`
				if [ "$temp" != "" ]; then
					exit 0
				fi
				while route del default ; do
					:
				done
				
				pidfile="/var/run/lte.pid"
				udhcpc -t 0 -i wimax0 -b -p "$pidfile" &
				
				logger "run_lte.sh: LTE interface up"
			else
				logger "run_lte.sh: LTE interface is ready"
			fi
		fi
	else
		echo "run_lte.sh: LTE dongle isn't ready"
	fi
elif [ "$1" = "down" ]; then
	interfaceExist=`ifconfig | grep wimax0`
	if [ "$interfaceExist" != "" ]; then
		temp=`ps | grep "udhcpc" | grep "wimax0" | awk '{print $1}'`
		if [ "$temp" != "" ]; then
			kill -SIGTERM $temp
		fi
		
		ifconfig wimax0 down
		
		logger "LTE interface down"
	fi
fi

