#include "lte_driver.h"
#ifndef LTE_USERIF_H
#define LTE_USERIF_H

#define MAJOR_NUM 243  
#define LTE_EVENT_Q_MAX				4          //must be power of 2
#define LTE_EVENT_Q_BUF_SIZE        1600

enum lte_event_type
{
	LTE_MODEM_POWER_RECYCLE,
	LTE_MODEM_CONNECTED,
	LTE_MODEM_DISCONNECTED,
	LTE_PACKET,
	LTE_HW_VERSION,
	LTE_SW_VERSION,
	LTE_MAC_ADDR,
	LTE_BSSID,
	LTE_LINK_UP,
	LTE_LINK_DOWN, 
	LTE_LINK_STATUS,
	LTE_NETWORK_TYPE,
	LTE_GET_CONFIG,
	LTE_GET_MY_DNS_IPS,
	LTE_SET_PIN_INVALID,
};

struct lte_link_info_st
{
	int rssi;
	int cinr;
	int dbm;
	int link_status;  //0: no signal, disconnected; 1:signal found and connecting; 2: connected
};

struct lte_packet_st
{
	int len;
	unsigned char body[LTE_EVENT_Q_BUF_SIZE];     
};

struct lte_config_st
{
	int network_mode;
	char apn[30];
	char pin[30];
};

struct lte_ips_st
{
	unsigned char my_ip[4];
	unsigned char dns_ip[4];
};

struct lte_event_st 
{
	struct my_list_head list;
	int  type;
	char if_name[10];
	union
	{
		struct					lte_packet_st packet;
		char					hw_ver[60];
		char					sw_ver[60];
		unsigned char			mac[6];
		unsigned char			bssid[6];
		struct lte_link_info_st link_info;
		struct lte_config_st	lte_config;
		int						network_type;
		struct lte_ips_st		ips;
	} data;
};

void lte_tell_app(struct lte_event_st * event);

#endif //LTE_USERIF_H
