#include <linux/init.h>
#include <linux/module.h>
#include <linux/autoconf.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/if_arp.h>
#include <linux/usb.h>
#include <linux/sockios.h>
#include <linux/timer.h>
#include <linux/wait.h>
#include <linux/fs.h>	
#include <linux/skbuff.h>
#include "lte_driver.h"
#include "os_shim.h"

//data should use a local array or allocated by kmalloc
int usb_control_in(void *usb_dev, unsigned char request, unsigned char requesttype,
			 unsigned short value, unsigned short index, void *data, unsigned short size, int timeout)
{
	//return value is actual bytes in
	return usb_control_msg(usb_dev, usb_rcvctrlpipe(((struct usb_device *)usb_dev), 0), request, requesttype, value, index, data, size, timeout);
}

//data should use a local array or allocated by kmalloc
int usb_control_out(void *usb_dev, unsigned char request, unsigned char requesttype,
			 unsigned short value, unsigned short index, void *data, unsigned short size, int timeout)
{
	//return value is actual bytes out
	return usb_control_msg(usb_dev, usb_sndctrlpipe(((struct usb_device *)usb_dev), 0), request, requesttype, value, index, data, size, timeout);
}

//data should use a local array or allocated by kmalloc
int usb_bulk_msg_out(void *usb_dev, unsigned int pipe, 
			void *data, int len, int *actual_length, int timeout)
{
	return usb_bulk_msg(usb_dev, usb_sndbulkpipe(((struct usb_device *)usb_dev), pipe), data, len, actual_length, timeout);
}

//data should use a local array or allocated by kmalloc
int usb_bulk_msg_in(void *usb_dev, unsigned int pipe, 
			void *data, int len, int *actual_length, int timeout)
{
	return usb_bulk_msg(usb_dev, usb_rcvbulkpipe(((struct usb_device *)usb_dev), pipe), data, len, actual_length, timeout);
}

int reset_device(struct lte_modem_st * modem)
{
	char cmd_buf[20];
	int act_count;
	modem->connect_timer = 4;
	strcpy(cmd_buf, "AT+CFUN=0,1\r");
	usb_bulk_msg(modem->usb_dev, modem->at_cmd_pipe, cmd_buf, strlen(cmd_buf), &act_count, 1000);
//	usb_reset_device(modem->usb_dev);
//  lte_send_ap_modem_power_recycle(modem);
	return 0;
}

void power_recycle_device(struct lte_modem_st * modem)
{
	if(modem->disconnected) return;
	modem->disconnected = 1;
	lte_send_ap_modem_power_recycle(modem);
}

int reset_device_no_modem_object(void * usb_dev)
{
	usb_reset_device(usb_dev);
}



void * os_kmalloc(int len)
{
	return kmalloc(len, GFP_ATOMIC);
}

void lte_update_mac(struct lte_modem_st * modem, char *  mac)
{
	memcpy(((struct net_device *)modem->net_dev)->dev_addr, mac, 6); 
	printk("LTE : MAC: %02X:%02X:%02X:%02X:%02X:%02X\n", ((struct net_device *)modem->net_dev)->dev_addr[0], 
		        ((struct net_device *)modem->net_dev)->dev_addr[1], 
				((struct net_device *)modem->net_dev)->dev_addr[2], 
				((struct net_device *)modem->net_dev)->dev_addr[3], 
				((struct net_device *)modem->net_dev)->dev_addr[4], 
				((struct net_device *)modem->net_dev)->dev_addr[5]);
}

void update_rx_drop_cnt(struct lte_modem_st * modem)
{
	((struct net_device_stats *)modem->statistic)->rx_dropped++;
}

void update_tx_drop_cnt(struct lte_modem_st * modem)
{
	((struct net_device_stats *)modem->statistic)->tx_dropped++;
}

int os_usb_sndbulkpipe(void * usb_dev, int pipe)
{
	return usb_sndbulkpipe((struct usb_device *)usb_dev, pipe);
}

int os_usb_rcvbulkpipe(void * usb_dev, int pipe)
{
	return usb_rcvbulkpipe((struct usb_device *)usb_dev, pipe);
}

void fill_modem_mac(struct lte_modem_st * modem, char * buf)
{
	memcpy(buf, ((struct net_device *)modem->net_dev)->dev_addr, 6);
}
