
. /usr/lib/ddns/sms_functions.sh

service_id=$1
SMS_ALERT_LOG=/tmp/sms_alert.log
if [ -z "$service_id" ]
then
	echo "ERRROR: You must specify a service id (the section name in the /etc/config/ddns file) to initialize dynamic DNS."
	exit 1
fi


if [ "$service_id" == "retry" ]; then #re-try to send SMS
	resend_sms
	return 0
fi

retrieve_prog="/usr/bin/wget -O - ";
#service_file="/usr/lib/ddns/sms_services"

ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"

NEWLINE_IFS='
'
profile_id=$1
#echo "profile_id="$profile_id

enabled=$(uci -q get sms.@service[$profile_id].enabled)
#echo "enabled="$enabled
#if this service isn't enabled then quit
if [ $enabled -ne "1" ]
then
	return 0
fi

time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
service_name=$(uci -q get sms.@service[$profile_id].service_name)

case "$service_name" in
	"kotsms" )
		update_url="http://202.39.48.216/kotsmsapi-1.php?username=[USERNAME]&password=[PASSWORD]&dstaddr=[DEST]&smbody=[MSG]"
		;;
	"smscity" )
		update_url="http://api.smscity.com/gateway/sms.php?username=[USERNAME]&password=[PASSWORD]&destination=[DEST]&body=[MSG]&sender=smscity&reference=268431687"
		;;
	"bulksms" )
		update_url="http://bulksms.vsms.net:5567/eapi/submission/send_sms/2/2.0?username=[USERNAME]&password=[PASSWORD]&msisdn=[DEST]&message=[MSG]"
		;;
	"textmarketer" )
		update_url="http://www.textmarketer.biz/gateway/?username=[USERNAME]&password=[PASSWORD]&number=[DEST]&message=[MSG]&orig=Draytek&option="
		;;
	"twsms" )
		update_url="http://api.twsms.com/send_sms.php?username=[USERNAME]&password=[PASSWORD]&mobile=[DEST]&message=[MSG]&type=now&encoding=unicode"
		;;
	"hinetsms" )
		USERNAME=$(uci -q get sms.@service[$profile_id].username)
		PASSWORD=$(uci -q get sms.@service[$profile_id].password)
		DEST=$(uci -q get sms.@service[$profile_id].dest)
		MSG=$2
		execute="/bin/hinet_sms '202.39.54.130' '$USERNAME' '$PASSWORD' '$DEST' '$MSG'"
		$execute
		if [ "$?" -eq "0" ]; then
			logger -p 160.5 "send sms alert success."
		else
			echo "$time|$service_id|$execute" > $SMS_ALERT_LOG
			logger -p 160.5 "send sms alert failed."
		fi
		;;
	* )
		#default
		return 0
		;;
esac

#kill old process if it exists & set new pid file
if [ -d /var/run/sms ]
then
	#if process is already running, stop it
	if [ -e "/var/run/sms/$service_id.pid" ]
	then
		old_pid=$(cat /var/run/sms/$service_id.pid)
		test_match=$(ps | grep "^[\t ]*$old_pid")
		verbose_echo "old process id (if it exists) = \"$test_match\""
		if [ -n  "$test_match" ]
		then
			kill $old_pid
		fi
	fi

else
	#make dir since it doesn't exist
	mkdir /var/run/sms
fi
echo $$ > /var/run/sms/$service_id.pid

#determine when the last update was
interval=$(uci -q get sms.@service[$profile_id].interval)
#echo "interval="$interval
current_time=$(monotonic_time)
#echo "current_time="$current_time

last_update=$(( $current_time - ($interval) ))
if [ -e "/var/run/sms/$service_id.update" ]
then
	last_update=$(cat /var/run/sms/$service_id.update)
fi
#echo "last_update="$last_update
time_since_update=$(( $current_time - ($last_update) ))
#echo "time_since_update="$time_since_update

if [ $time_since_update -lt $interval ]
then
	#echo "less then interval"
	return 0;
fi

#quota
quota=$(uci -q get sms.@service[$profile_id].quota)
#echo "quota="$quota
if [ $quota -le 0 ]
then
	return 0
fi

USERNAME=$(uci -q get sms.@service[$profile_id].username)
final_url=$(echo $update_url | sed s/"\[USERNAME\]"/"$USERNAME"/g)

PASSWORD=$(uci -q get sms.@service[$profile_id].password)
final_url=$(echo $final_url | sed s/"\[PASSWORD\]"/"$PASSWORD"/g)

DEST=$(uci -q get sms.@service[$profile_id].dest)
final_url=$(echo $final_url | sed s/"\[DEST\]"/"$DEST"/g)

MSG=$2
final_url=$(echo $final_url | sed s/"\[MSG\]"/"$MSG"/g)

#		final_url=$(echo "$final_host?$final_uri")
#final_url=$(echo $final_url | sed s/"\[IP\]"/"$current_ip"/g )

#		verbose_echo "updating with url=\"$final_url\""
#echo "final_url="$final_url
#sleep 10

#update_output=$( $retrieve_prog "$final_url" )
$retrieve_prog "$final_url"
if [ "$?" -eq "0" ]; then
	subtract_quota
	logger -p 160.5 "send sms alert success."
else
	if [ "$final_url" != "" ]; then
		if [ -f $SMS_ALERT_LOG ];then
			resend_status=$(cat $SMS_ALERT_LOG | awk 'FS="|" {print $4}')
			if [ "$resend_status" == "$3" ];then
				return 0
			else
				rm $resend_status
			fi
		fi
		echo "$time|$service_id|$retrieve_prog $final_url|$3" > $SMS_ALERT_LOG
		logger -p 160.5 "send sms alert failed."
	fi
fi


verbose_echo "Update Output:"
verbose_echo "$update_output"
verbose_echo ""

echo "$current_time" > "/var/run/sms/$service_id.update"

return 0