#!/bin/sh

local OP_CMD="$1"

case $1 in 
	ca)
	/usr/sbin/clean-all
	cp /rom/etc/easy-rsa/keys/* /etc/easy-rsa/keys/
	/usr/sbin/build-ca
	;;

	server)
	/usr/sbin/build-key-server server
	;;

	build_client)
	printf "Please input your client name:"
	read CName
	echo "Generating certificate for $CName"
	/usr/sbin/build-key $CName
	;;

	show_ca)
	cat keys/ca.crt
	;;

	show_client)
	printf "Please input your client name:"
	read CName
	echo "Please COPY certificate of $CName below"
	openssl x509 -in keys/$CName.crt
	echo ""
	echo "Please COPY private key of $CName below"
	cat keys/$CName.key
	;;

	server_config)
	printf "Please input Server IP Address:"
	read SIPAddr
	printf "Please input Service Port:[1194]"
	read SPort
	printf "Please input Service Protocol:[udp/tcp]"
	read SPro
	SLANIP=$(uci -q get network.lan.ipaddr)
	SLANMASK=$(uci -q get network.lan.netmask)
	printf "Please input Start IP Address for openvpn client:"
	read SStart
	printf "Please input End IP Address for openvpn client:"
	read SEnd

	rm /tmp/tmp_server.conf
	echo "local $SIPAddr" >> /tmp/tmp_server.conf
	echo "port ${SPort:-1194}" >> /tmp/tmp_server.conf
	echo "proto ${SPro:-udp}" >> /tmp/tmp_server.conf
	echo "dev tap0" >> /tmp/tmp_server.conf
	echo "server-bridge $SLANIP $SLANMASK $SStart $SEnd" >> /tmp/tmp_server.conf
	echo "push \"route 0.0.0.0 0.0.0.0\"" >> /tmp/tmp_server.conf
	echo "keepalive 20 180" >> /tmp/tmp_server.conf
	echo "ca /etc/easy-rsa/keys/ca.crt" >> /tmp/tmp_server.conf
	echo "cert /etc/easy-rsa/keys/server.crt" >> /tmp/tmp_server.conf
	echo "key /etc/easy-rsa/keys/server.key" >> /tmp/tmp_server.conf
	echo "dh /etc/easy-rsa/keys/dh1024.pem" >> /tmp/tmp_server.conf
	echo "push \"redirect-gateway def1\"" >> /tmp/tmp_server.conf
	echo "push \"dhcp-option DNS 8.8.8.8\"" >> /tmp/tmp_server.conf
	echo "status openvpn-status.log" >> /tmp/tmp_server.conf
	echo "comp-lzo" >> /tmp/tmp_server.conf
	echo "verb 4" >> /tmp/tmp_server.conf
	cp /tmp/tmp_server.conf /etc/easy-rsa/server.conf
	echo " *** Server config *** "
	cat /etc/easy-rsa/server.conf
	;;

	run)
	killall openvpn
	/etc/easy-rsa/openvpnbridge.sh
	SPort=$(cat /etc/easy-rsa/server.conf | grep port | awk '{FS=" "}{print $2}')
	SPro=$(cat /etc/easy-rsa/server.conf | grep proto | awk '{FS=" "}{print $2}')
	iptables -A input_wan -p $SPro --dport $SPort -j ACCEPT
	iptables -t nat -A prerouting_wan -p $SPro --dport $SPort -j ACCEPT
	openvpn /etc/easy-rsa/server.conf &
	;;

	*)
	echo "NO such command: $1"
	exit 1
	;;
esac