/*

t-crc32.c

Author: Tatu Ylonen <ylo@ssh.fi>

  Copyright:
          Copyright (c) 2002, 2003 SFNT Finland Oy.
                   All rights reserved

*/

#include "sshincludes.h"
#include "sshrand.h"
#include "sshcrc32.h"


struct
{
  int len;
  unsigned long crc;
  unsigned char data[5000];
} testdata[] =
{
{ 0, 0x0L },
{ 1429, 0x28cf4e03L, {
  0xf2,0x78,0x05,0x5a,0xe8,0x96,0x29,0x4c,0xeb,0xe8,
  0xf0,0x74,0x13,0xb0,0x47,0x52,0xf7,0x7c,0x9b,0x49,
  0xf6,0x09,0xbe,0x19,0x96,0x0c,0x15,0x81,0x63,0xe3,
  0x12,0x55,0x5b,0x17,0xaf,0x43,0xad,0xd8,0x90,0x99,
  0xc0,0x80,0x0d,0xd4,0x30,0x54,0x26,0x27,0xd0,0xc1,
  0x70,0xc6,0xca,0x2e,0xe0,0x60,0x3b,0xf5,0xe1,0x9e,
  0xd8,0xf3,0xf3,0x34,0x0a,0xa3,0x77,0xb8,0x7b,0x07,
  0x51,0x3c,0x87,0x5e,0x10,0xb7,0xb2,0x36,0xde,0x83,
  0xf8,0x4e,0x49,0xc2,0x7d,0x29,0x23,0xb8,0x1f,0x04,
  0x56,0xf7,0xf8,0x49,0x2b,0x02,0xec,0xa3,0xba,0x68,
  0xaa,0x0b,0xa4,0x32,0x69,0xb4,0xe9,0x1c,0xea,0xc8,
  0x9f,0xe2,0x16,0xe8,0xa5,0x93,0x12,0xc8,0x4b,0x31,
  0xcc,0xa1,0x28,0xc4,0xeb,0x54,0xc7,0xd7,0xf7,0x81,
  0x3f,0xa1,0x8d,0xe3,0xd3,0xf6,0x97,0xbd,0x12,0x82,
  0x85,0xb1,0x64,0x9b,0x9a,0x09,0x2f,0xac,0xd1,0x7a,
  0xdd,0x9e,0x1c,0x05,0x62,0x07,0x59,0x29,0xde,0x50,
  0xab,0x1e,0xf2,0x38,0x01,0xc5,0x2e,0x99,0x82,0x41,
  0x1b,0x07,0xf2,0x7f,0xa3,0x8c,0x89,0xd2,0x38,0x5a,
  0x4c,0x15,0xf8,0x68,0x1b,0x5b,0x6f,0x74,0x84,0x4e,
  0xc5,0x2f,0x6c,0xb7,0x67,0x6d,0x7c,0x96,0x06,0xff,
  0xd7,0x21,0x06,0xc9,0xa1,0xa9,0x56,0x2a,0x7b,0x8e,
  0x84,0xc8,0xa4,0x7d,0x30,0xbf,0xd8,0xa0,0x33,0x5c,
  0xee,0xf8,0x8c,0x5a,0xaf,0xf3,0xc7,0x2c,0x89,0xce,
  0x2b,0x60,0xef,0x31,0x2a,0x90,0xdb,0x80,0xba,0x56,
  0x0e,0x3f,0x1e,0xb2,0xbc,0x4f,0x71,0x94,0xef,0xa5,
  0xf0,0xdd,0x9d,0x7c,0x37,0x4d,0x70,0xfe,0x79,0xf9,
  0xcc,0xa4,0x5a,0xbc,0xd5,0x84,0x4c,0xb0,0x04,0x07,
  0x07,0x12,0x46,0x25,0xc5,0x02,0x74,0x36,0x96,0x63,
  0xdb,0x86,0x40,0x79,0x03,0x77,0xc6,0x73,0x76,0x3f,
  0x6c,0x42,0xe3,0xc6,0xfe,0xb8,0x4a,0x4b,0x69,0x4e,
  0x52,0x70,0x61,0x98,0x95,0x26,0x9a,0x0a,0x5c,0x30,
  0x6d,0x38,0xb6,0xae,0xb1,0xb9,0x25,0x77,0x2c,0x9b,
  0xb6,0x99,0xde,0x99,0x5f,0xdc,0x51,0xaa,0x27,0xba,
  0xf8,0x79,0x2a,0x59,0x11,0xc0,0x7f,0xab,0xca,0xdc,
  0xdb,0x37,0x14,0x92,0xe5,0xc5,0x4b,0x0b,0x3c,0x78,
  0xa6,0xf2,0x11,0x84,0x8b,0x70,0x61,0xdc,0x1a,0x88,
  0x97,0x13,0x02,0xc1,0x6c,0x13,0x81,0xec,0xbf,0x4b,
  0xc8,0x9a,0x83,0xdc,0x2c,0x68,0xa1,0x78,0x73,0xdd,
  0xf0,0x1a,0xcf,0x01,0x9e,0x5a,0x71,0xff,0x36,0x8c,
  0x88,0xcd,0x9f,0x8a,0x8f,0x0b,0x9d,0x10,0xf7,0x5c,
  0x5c,0xbf,0xf7,0xdf,0x9b,0x23,0x47,0x3c,0x9b,0xbb,
  0x19,0x8b,0xd5,0xe8,0x8c,0x73,0x42,0xfe,0x73,0x79,
  0x8a,0xfb,0x46,0x29,0x85,0xd5,0x34,0x22,0xe6,0x2c,
  0x7f,0x42,0xeb,0x76,0x21,0x87,0x99,0x68,0xc3,0x35,
  0x23,0xdd,0xc0,0xf8,0xc5,0x4d,0x6c,0x08,0x4b,0xdf,
  0x81,0xd5,0xda,0xc7,0xfe,0x5f,0x9d,0x32,0x81,0x83,
  0x5e,0x00,0xc5,0x4a,0x76,0xe6,0xd1,0x10,0x4e,0x94,
  0x45,0x72,0x71,0x05,0x6a,0x37,0x52,0xd6,0x3f,0x9d,
  0xb5,0xc0,0x72,0x8f,0x87,0x70,0xee,0x24,0xa3,0x70,
  0xa7,0x01,0x70,0x6c,0x4b,0xe7,0x52,0x1c,0xf7,0xa1,
  0xb1,0x3c,0x13,0x22,0x41,0x7d,0x59,0x94,0x54,0x98,
  0x31,0x09,0x58,0xa4,0x99,0xe0,0x14,0x87,0x04,0xb7,
  0xf7,0xac,0xb9,0x68,0x18,0x04,0x4f,0x6b,0x21,0x46,
  0x0c,0xd2,0x82,0x1f,0xf4,0xc3,0x9c,0x4e,0x57,0xf0,
  0xe6,0x89,0xfa,0x3f,0x2d,0x93,0x1f,0x41,0x1a,0x23,
  0xf9,0x12,0xcf,0xb2,0x7a,0xe8,0xb6,0xc9,0x53,0xd7,
  0x0f,0x5f,0xa9,0x91,0x7e,0x9e,0x54,0x1a,0xec,0xac,
  0x0b,0xd2,0x35,0x05,0x11,0x62,0x98,0x30,0xa3,0xb2,
  0x54,0x9c,0xc4,0x23,0x4e,0x3e,0x0b,0x05,0x07,0x5e,
  0xdc,0x16,0xbd,0x86,0xa7,0x3b,0x24,0xfc,0x56,0x10,
  0xa8,0x61,0xe2,0xdd,0x66,0xf4,0x3f,0xfe,0x24,0xe2,
  0xb0,0x78,0x7f,0x75,0x9c,0xcd,0xb3,0xa7,0xd2,0xbb,
  0x06,0xaf,0xd1,0xc3,0x35,0x79,0xff,0x59,0x75,0x55,
  0x69,0x1d,0xb6,0x4b,0xfa,0x1c,0x3f,0x39,0x1a,0x64,
  0x1b,0xca,0xdc,0x9a,0x3f,0x78,0x68,0xf3,0x20,0x3a,
  0xae,0x26,0xe9,0x7f,0xe9,0x1e,0xf8,0xe8,0x77,0x6d,
  0x3d,0xe0,0x8a,0xf3,0x2c,0x84,0x0f,0x6b,0xbd,0x29,
  0xcf,0xd9,0xf4,0xac,0x73,0x33,0x24,0xdb,0x26,0x44,
  0x16,0xd4,0x6a,0xff,0x54,0x54,0x1e,0x4c,0x3c,0x95,
  0xba,0x7a,0x76,0x44,0x6d,0xa2,0xc9,0x7d,0x0d,0x86,
  0xa6,0xdd,0x5f,0x9a,0x89,0xd3,0xce,0xad,0xae,0xf4,
  0xf2,0xc4,0xc9,0x5c,0xc4,0x1d,0xb0,0xe2,0x69,0xed,
  0x77,0x23,0x67,0xed,0x68,0xd4,0x8f,0x31,0x51,0x9d,
  0xb7,0xf8,0x7a,0x17,0x92,0x03,0xea,0x60,0xb0,0x98,
  0x55,0xa2,0x5d,0x1e,0xff,0x21,0x3b,0xaf,0x03,0xa4,
  0x9c,0x7a,0xc8,0x03,0x68,0x30,0xd8,0xf7,0x61,0x29,
  0x94,0x18,0x21,0x0e,0x2f,0xb4,0x11,0x19,0x14,0xc2,
  0xb2,0x69,0x64,0x0f,0x87,0x63,0x30,0xc2,0x13,0x33,
  0x67,0xaf,0xad,0x2f,0xb3,0x15,0x5f,0x8b,0x0d,0xc0,
  0xb4,0xa1,0xd8,0xd6,0xb0,0x08,0x8a,0xc1,0x21,0x9e,
  0x83,0xd3,0x08,0xe8,0xe2,0x8f,0x4b,0x12,0x52,0x5e,
  0x45,0xb9,0x0e,0xf3,0xe8,0xc1,0x08,0x47,0x4c,0x15,
  0x07,0x00,0xb7,0xdf,0xd6,0x67,0xe7,0x60,0x28,0x09,
  0xff,0xac,0xdc,0x07,0x94,0xbf,0x96,0xdf,0xd1,0xe8,
  0x3e,0x17,0xa1,0x4c,0x0a,0x89,0x0d,0x12,0xd0,0x59,
  0x28,0xd7,0x59,0xdf,0xb7,0x30,0x46,0x9e,0x90,0x6e,
  0xa7,0x8f,0x1a,0x84,0x96,0xae,0x43,0x2d,0x8e,0x14,
  0x15,0xcc,0x2b,0xb7,0x18,0x35,0x40,0x25,0x48,0x11,
  0x7e,0x70,0xe8,0xd7,0x4f,0x9f,0x07,0x95,0x3e,0x98,
  0x03,0xe5,0x27,0x1e,0x69,0xbe,0xcc,0xac,0xeb,0x5a,
  0xc1,0x00,0x26,0xec,0xb7,0x3e,0x22,0xf8,0x63,0x6a,
  0x09,0xe1,0xda,0xf1,0xb9,0x29,0x91,0xc0,0xbe,0xcf,
  0x58,0xc1,0xb4,0x80,0xdf,0x1e,0x3e,0xac,0xca,0x29,
  0x06,0x8b,0x29,0x2d,0x78,0xe1,0x6b,0x9a,0xd9,0xcf,
  0x04,0xe2,0xb0,0xde,0xd3,0x69,0x07,0x64,0x2a,0xc5,
  0x33,0x82,0x86,0xe8,0x02,0x66,0x06,0x40,0x12,0xd0,
  0x69,0x18,0x5c,0x93,0x45,0xd4,0x74,0xb1,0x6e,0x4d,
  0x80,0x72,0x2f,0x30,0x50,0x02,0x9a,0x57,0x67,0xc4,
  0x1c,0x9a,0x46,0xa2,0x82,0x49,0x08,0x88,0x89,0x1a,
  0x59,0xf3,0x33,0xb5,0x86,0x78,0x89,0xfa,0x29,0xf7,
  0x47,0xa9,0x69,0x76,0xda,0xb9,0x78,0x74,0x10,0xdf,
  0x38,0x2c,0x7a,0x7e,0xce,0xfc,0xc7,0xd7,0x85,0x51,
  0xf1,0xde,0x44,0x24,0x93,0xca,0x9d,0x1c,0xc4,0xc6,
  0x13,0x0b,0x70,0x7c,0x81,0x4a,0x35,0xf9,0xbe,0x45,
  0xd9,0xf6,0x71,0x53,0x74,0x3f,0x4f,0x3c,0x16,0xd4,
  0x8d,0x08,0xb2,0xd1,0x2c,0x45,0x9b,0xc9,0x61,0x5f,
  0x90,0x74,0x6a,0x00,0xf0,0xeb,0x4a,0x25,0xe4,0x08,
  0x6a,0xbd,0xfe,0xdb,0x10,0x72,0x1b,0x60,0xae,0x31,
  0x34,0x3b,0x39,0xe7,0x0c,0x66,0x2c,0xa7,0x2f,0x8e,
  0x06,0xbf,0x02,0x70,0xbf,0xf3,0x5b,0x09,0x18,0x40,
  0x11,0x83,0xfd,0x0f,0x5e,0x0e,0x82,0x79,0x6e,0x30,
  0xab,0xa2,0x6c,0xe4,0x89,0x78,0x4a,0xb6,0x20,0x7a,
  0x44,0x26,0x39,0x46,0x97,0xf9,0x39,0xf2,0x02,0x52,
  0x32,0x14,0xd5,0x30,0x23,0x33,0x3e,0xa5,0xad,0xac,
  0xd6,0x58,0x4e,0x42,0x3c,0xd8,0xba,0x87,0x8e,0xda,
  0x01,0xd2,0x01,0x3a,0x18,0x98,0x33,0x52,0x8a,0x36,
  0xa4,0xbd,0x4a,0x79,0xed,0x6d,0xac,0x2b,0x13,0x59,
  0xd7,0xe9,0xb1,0x25,0x2b,0xee,0xfd,0xe5,0x75,0x8b,
  0xc0,0x76,0x5d,0xc1,0xb0,0x76,0x59,0xe4,0xc8,0xe3,
  0x1a,0x6c,0xa0,0x64,0xe5,0x8d,0xd1,0x91,0xb8,0xe4,
  0xeb,0x8f,0xcd,0x9c,0xb5,0xf8,0x8a,0xb2,0xde,0xff,
  0x3e,0x9e,0x75,0x9b,0x5f,0x26,0x11,0xb8,0x0a,0xd9,
  0x9b,0x24,0x45,0x3c,0x88,0x2a,0xc9,0x59,0xbc,0x82,
  0x3e,0xa7,0x11,0x0b,0x43,0xc6,0x04,0xce,0x79,0xe2,
  0xcd,0xb7,0x80,0x43,0x52,0xdf,0x69,0x64,0x97,0x73,
  0x3d,0x32,0x97,0x83,0x6e,0x1f,0xad,0x38,0x78,0x69,
  0xba,0xb6,0x10,0xcb,0xc2,0x54,0x92,0xc6,0x22,0x0b,
  0xa8,0xef,0xc2,0x28,0x32,0x14,0x07,0x9b,0x78,0x9e,
  0x0e,0xb6,0xd0,0xa5,0x39,0x3f,0xc4,0xe6,0x77,0x3d,
  0x50,0x31,0xf3,0x60,0xfc,0xb5,0xb4,0x8e,0x7b,0xd6,
  0x99,0x23,0xc6,0x5b,0x4b,0xf8,0x70,0x52,0x94,0xe8,
  0xf0,0xa2,0x9e,0xc1,0x48,0xd7,0x00,0x0c,0xbe,0x77,
  0x49,0x0e,0xa8,0x3d,0x6e,0xa4,0xf2,0x23,0x33,0x6e,
  0xf9,0xcc,0x91,0xbf,0x28,0xdd,0xb8,0x98,0x2f,0x4c,
  0x80,0x20,0xee,0x1f,0xe1,0x36,0xf6,0xe1,0x43,0xb4,
  0x58,0x8c,0xc2,0x00,0xc9,0x31,0xa4,0xbc,0x54,0xd7,
  0x2a,0x4d,0xa4,0xbb,0x0d,0xcc,0x98,0xc5,0x64,0xc8,
  0x11,0xe4,0xe8,0xff,0x03,0xc9,0x36,0xfa,0xaa,0x79,
  0xae,0x02,0x05,0x71,0x02,0xcf,0xa2,0xa6,0x8b,0xf6,
  0x7e,0xb5,0x43,0x22,0x70,0x50,0xee,0x09,0x15,0x52,
  0xd1,0x26,0x36,0xb9,0x26,0x3a,0x82,0x5c,0x34,0x2c,
  0xd5,0xe2,0x2e,0xda,0x53,0x30,0xa9,0xf5,0xd6,0x34,
  0xeb,0x54,0xe9,0x2f,0x76,0x5a,0x7f,0x64,0x63}},
{ 2858, 0xbad0fdbaL, {
  0x5a,0xa2,0x97,0x6b,0xdb,0x82,0xa9,0x65,0x81,0x59,
  0x1b,0x1b,0x8e,0x8e,0xf2,0xd7,0x33,0x0b,0x32,0xb6,
  0x5c,0xaf,0xa1,0xe4,0x8f,0xa1,0xb9,0x1a,0x72,0xfb,
  0x6f,0xcd,0x9d,0x06,0x38,0x79,0x88,0xe1,0xde,0x0a,
  0x3a,0xfa,0x25,0xc8,0x88,0x17,0x9f,0xbc,0x23,0xd1,
  0x72,0x7f,0x81,0x13,0x63,0x10,0xb5,0x1c,0x2a,0x27,
  0x17,0x99,0xf4,0xb5,0xa0,0x2c,0x2e,0x28,0x0d,0x0c,
  0x32,0x47,0x06,0x57,0x0f,0x8f,0x6f,0xae,0x4b,0x92,
  0x80,0xbd,0x11,0x01,0xd0,0x74,0x11,0x85,0x90,0x3b,
  0xad,0xa8,0xd4,0xa1,0x5d,0x74,0xce,0x8b,0x9d,0xdb,
  0x97,0xcf,0x23,0x9e,0x27,0x32,0x2d,0x96,0xe1,0x78,
  0x28,0x61,0x35,0x39,0x62,0x05,0xad,0x73,0x8b,0x3d,
  0xae,0x38,0xe5,0x82,0xd9,0x42,0xf7,0xa7,0xcd,0x94,
  0x83,0x65,0x63,0xa6,0x03,0x8a,0xd8,0x30,0x20,0xb9,
  0xa8,0x48,0x1a,0xdd,0x81,0x7c,0xe2,0x2e,0xef,0x6d,
  0x6c,0x9d,0xa5,0x51,0x20,0x7f,0x94,0x17,0x26,0x61,
  0xab,0xa9,0xc6,0x0e,0x4f,0xc9,0x99,0x28,0xf9,0xb9,
  0xe1,0xa1,0x02,0xfc,0x7e,0x83,0x78,0x61,0xb2,0x68,
  0xce,0x1e,0x05,0x74,0x6f,0x25,0xf3,0x03,0x3c,0x19,
  0x65,0xe7,0xc3,0x2b,0xf6,0x12,0xf5,0x8f,0x3a,0xee,
  0x48,0x1c,0x90,0x4a,0x18,0x0e,0xce,0x90,0x6f,0x80,
  0xf8,0x3e,0x9e,0xfe,0xb2,0x0d,0x23,0xa5,0x11,0x60,
  0xbe,0x76,0x47,0x81,0xa1,0x3d,0x94,0x96,0xcc,0xce,
  0x85,0x15,0xea,0x15,0x5f,0x02,0x23,0x2d,0x93,0x93,
  0xad,0x8b,0xd1,0x4b,0x89,0x83,0x59,0xad,0x28,0x6a,
  0x0d,0xe6,0xe0,0x54,0x68,0x81,0x92,0xfc,0x18,0x5e,
  0xca,0x9d,0x73,0xb5,0xb2,0xd3,0xb7,0xd5,0x00,0x4a,
  0x68,0xae,0xd6,0x39,0xf9,0x5f,0xbc,0x52,0x0c,0xe4,
  0xbc,0x19,0xcb,0x9c,0x6e,0x33,0x1e,0x00,0x2f,0x36,
  0x5e,0xf9,0xd3,0xd2,0xae,0x85,0xa5,0x66,0x5a,0xa5,
  0xb0,0xc3,0x53,0x86,0xfc,0x4d,0xe6,0xb9,0x9f,0xf2,
  0x9d,0x5c,0x0c,0x68,0xf8,0x7a,0x9b,0x16,0x7a,0xca,
  0x4c,0xd8,0xc4,0x1f,0xaa,0x72,0xa4,0x4f,0xd8,0xff,
  0xf5,0x89,0xc2,0x48,0x0f,0xbe,0x95,0xf5,0x77,0x35,
  0xe8,0x15,0x91,0xf4,0x7d,0x89,0x6e,0x19,0xa0,0xe8,
  0xe3,0xec,0xc0,0xa7,0x0c,0x6b,0x1a,0xb0,0xba,0xf2,
  0xaf,0xaf,0x7b,0x71,0xf8,0x8b,0x30,0x8d,0x80,0xa7,
  0xc2,0x68,0xbc,0x53,0x5c,0x3a,0xdd,0xca,0x53,0x7d,
  0xb2,0x36,0x69,0x73,0xde,0x75,0xde,0xf8,0x26,0x98,
  0xea,0xd5,0x48,0x66,0x47,0x40,0xf1,0x77,0xcd,0x71,
  0x1e,0x90,0xda,0xdb,0xe3,0x36,0x15,0xc0,0x01,0x68,
  0x3d,0xb3,0x9e,0xa7,0x26,0x7c,0x1c,0x04,0x74,0x42,
  0x9d,0x5f,0x18,0xe5,0xc5,0x5f,0x25,0xb6,0xd6,0xf2,
  0x27,0xf4,0x82,0x01,0xcf,0x66,0x38,0xe4,0x26,0x39,
  0x4c,0x64,0xec,0xeb,0x0b,0x13,0x67,0x27,0x17,0xdc,
  0x6a,0xb4,0x3b,0x82,0x99,0x00,0xe1,0xbe,0xb6,0xb7,
  0xb1,0xdd,0xab,0x33,0xdf,0x7b,0x99,0x17,0x5f,0xc0,
  0x50,0xac,0x24,0x3c,0x97,0x2f,0x4f,0xfe,0x56,0x67,
  0xda,0xc0,0x1b,0x15,0x42,0xb5,0x15,0x23,0x73,0xcb,
  0xda,0x24,0xa9,0x86,0x58,0x88,0x01,0xf1,0x9f,0x60,
  0xb1,0xef,0x0c,0xd5,0x2b,0xa3,0x04,0x7b,0xa2,0x5b,
  0xe2,0x7c,0x1b,0xfd,0x92,0x5e,0xb2,0xa7,0x81,0x26,
  0x73,0x5c,0x4a,0x1c,0xe2,0xa2,0xa4,0xe3,0x94,0x43,
  0x43,0x45,0x32,0x50,0x1b,0x5d,0xf3,0x1f,0xd8,0x95,
  0x7a,0xba,0x12,0x96,0xb8,0xa4,0xf4,0x6a,0x4b,0x75,
  0x90,0xbe,0xd1,0xdb,0xda,0xb3,0x7d,0x7e,0x96,0x11,
  0xc1,0xda,0x57,0xf3,0x2a,0x72,0x51,0x1d,0x91,0x29,
  0xb3,0x0c,0xe4,0xc5,0xa2,0x9c,0x69,0x96,0x06,0xb4,
  0x0b,0x97,0x73,0xdd,0x72,0x4d,0x90,0xef,0xcc,0x27,
  0x01,0x8d,0x01,0x58,0x81,0x2b,0xca,0xd2,0x48,0x5b,
  0xfb,0xfb,0x67,0xdf,0xc0,0x09,0x7b,0x29,0x9f,0x82,
  0xde,0xab,0x19,0x51,0x88,0x8b,0x9e,0x18,0x7a,0x6a,
  0x3f,0x7b,0xf8,0x40,0xd3,0x79,0x6b,0x9d,0x4b,0xb4,
  0xf9,0x46,0xaf,0x60,0x26,0x70,0x6a,0xa1,0x99,0x09,
  0x23,0x77,0xb4,0x3c,0xc8,0x3c,0xc7,0x67,0x55,0x42,
  0xd1,0x94,0xbd,0xc9,0xd5,0x91,0x42,0x40,0x2e,0x8d,
  0xf4,0x27,0xd4,0xa4,0x88,0xfa,0x14,0xf2,0x9b,0xad,
  0xfb,0xbf,0x25,0xb0,0xfb,0xed,0xec,0xc3,0x54,0x41,
  0x05,0x26,0xd6,0xc2,0xef,0xab,0x53,0x32,0xeb,0x82,
  0xbf,0xe0,0xa9,0x93,0x84,0x31,0x8d,0x98,0x23,0x29,
  0x45,0x1f,0xe8,0x6a,0xcf,0xe3,0x58,0xbb,0xa6,0xac,
  0xfd,0xab,0xd2,0xd3,0x6e,0xc2,0x7e,0xc1,0xf4,0x69,
  0x43,0xb3,0x49,0xed,0x47,0xcd,0x1e,0xd4,0x65,0x42,
  0xfd,0xab,0x61,0xe5,0x15,0x30,0xc9,0x6d,0xeb,0x6f,
  0x1a,0xe8,0x1b,0xec,0xbb,0x89,0xae,0x39,0x4a,0xa2,
  0xa3,0x8e,0x56,0xec,0x7b,0x9d,0xba,0x99,0x71,0x1f,
  0xdb,0x6f,0xca,0x3c,0x54,0xe0,0x6c,0x1d,0x4d,0x58,
  0x8d,0x67,0x40,0xa8,0x54,0xfc,0x31,0x02,0x35,0x7b,
  0xa5,0xd8,0x09,0xfb,0xc5,0x84,0x98,0x7f,0x1e,0x09,
  0x9e,0xf9,0x78,0x69,0x36,0xcd,0x49,0xa2,0xea,0x96,
  0xfa,0x77,0xfe,0x3b,0x1f,0x52,0x37,0x50,0x54,0x6c,
  0xcc,0xf9,0x45,0xd5,0xf4,0x0a,0x5a,0x8c,0x89,0x78,
  0x96,0x27,0x71,0x0e,0x90,0xa7,0xdb,0xd9,0x4a,0xc6,
  0x70,0x44,0x3d,0x6e,0x7f,0x5d,0xc0,0xb6,0xad,0x14,
  0x23,0x79,0x0e,0x68,0x4f,0x02,0x72,0xa9,0x8f,0xfb,
  0x21,0x25,0x22,0x92,0x33,0xb3,0x3a,0x0f,0x8c,0x84,
  0xd5,0xfc,0xc8,0x12,0x6a,0x48,0x6f,0x2a,0xfe,0x1d,
  0x3f,0x21,0x96,0x4d,0x89,0xe5,0x4f,0xfb,0x8e,0xde,
  0xf6,0xaf,0x03,0x19,0x42,0x37,0xcc,0x7c,0x46,0x58,
  0x00,0x1b,0x55,0xc8,0x2d,0xbf,0x10,0x9d,0xea,0x0f,
  0xba,0x29,0x30,0x50,0x76,0xba,0x36,0xc5,0xb5,0xc4,
  0xa4,0xac,0x74,0xa7,0xc5,0xb6,0xde,0x91,0x32,0x24,
  0xe9,0x32,0x3f,0x3e,0xfa,0x6d,0xfe,0x0b,0x0a,0xe8,
  0x1a,0xc4,0x11,0x4a,0x14,0x87,0x04,0x4a,0x4c,0xba,
  0x0f,0xf0,0x66,0x83,0x98,0x2b,0x39,0x76,0xbc,0x6b,
  0x9b,0xa5,0x9d,0xda,0xe4,0x97,0x47,0xe2,0xa2,0x51,
  0xca,0xbc,0x15,0xdb,0x07,0x2a,0x62,0x0b,0x74,0xae,
  0xc5,0x83,0x9f,0x2b,0x06,0x37,0x56,0x3f,0xad,0x12,
  0xaa,0x48,0xb8,0x47,0x23,0x9c,0xdf,0x6a,0x7e,0x81,
  0xbc,0x48,0x3e,0xd1,0x23,0x45,0xfb,0x85,0x50,0x70,
  0x33,0x16,0xf3,0xd2,0x41,0xfa,0x09,0x98,0x39,0xb7,
  0xaa,0xe4,0xff,0x62,0x2b,0x22,0xfe,0x0a,0x8d,0x7c,
  0x8c,0x49,0xc4,0xca,0x1a,0xe7,0x0f,0x16,0x6c,0x5f,
  0x86,0xa0,0x75,0x79,0x72,0xb7,0x73,0x7c,0x4f,0xad,
  0x33,0xf9,0x91,0x32,0x5c,0xbc,0x55,0x5a,0xc7,0xe2,
  0xd7,0x53,0x2b,0x9b,0x1d,0x45,0x83,0x2c,0x5b,0xef,
  0x8b,0xe1,0x8f,0x01,0x5b,0x02,0xb8,0xce,0x7e,0x07,
  0x7b,0xb1,0x00,0x0c,0xe3,0x5c,0xc9,0x38,0xb7,0x90,
  0x1a,0x8e,0xe3,0x45,0x29,0x00,0x8b,0xac,0x2c,0xe6,
  0x9c,0xb7,0xc8,0x2b,0xb8,0x23,0x2d,0x70,0xf1,0xab,
  0x77,0x6d,0x5c,0x78,0x79,0x40,0xd4,0x42,0x78,0x8b,
  0xd2,0x93,0x19,0xb5,0xd8,0x43,0xb5,0x63,0xef,0xe1,
  0x4a,0x8b,0x99,0x12,0xb7,0x51,0x35,0xe4,0xc2,0x26,
  0x90,0x39,0x93,0xec,0xb1,0x0d,0x2c,0x86,0x4f,0xa5,
  0x11,0x22,0x38,0x2b,0xd7,0x10,0x6e,0x8d,0x74,0x5d,
  0x6e,0xbe,0xe9,0x07,0xd0,0xa0,0x59,0x05,0x84,0x1b,
  0x2b,0x14,0x54,0xbf,0x01,0x06,0xcc,0x2d,0x8c,0x1b,
  0xd2,0x9d,0x3d,0x0a,0xc8,0x15,0x1b,0x36,0xa2,0x8f,
  0x94,0x10,0x4d,0x7d,0x18,0x1d,0x1d,0x71,0x22,0xa1,
  0x8c,0x4d,0xb6,0xe0,0x0c,0xb7,0xe6,0xd8,0xe4,0x72,
  0xf4,0xb7,0x10,0x31,0xc1,0xd8,0x46,0xdc,0x0f,0xe8,
  0x6b,0xa3,0xf9,0xb8,0x20,0x11,0xd5,0x3d,0x82,0xf7,
  0xde,0x0e,0x45,0x94,0xee,0x51,0x4b,0xd5,0x2a,0x30,
  0x47,0x1e,0xe7,0x57,0x4f,0xa8,0x30,0x96,0x85,0x3f,
  0x7e,0xf0,0xe2,0x77,0xa9,0x02,0x88,0x7e,0x3f,0x0a,
  0x76,0x1d,0x18,0xbb,0xb2,0x07,0x0c,0xfd,0xdc,0x36,
  0x2d,0x23,0x54,0x14,0x7b,0xa4,0xbd,0xab,0x3a,0x42,
  0xea,0xb8,0x32,0xcc,0x30,0xdb,0xce,0xb8,0x5a,0x0d,
  0xc3,0xd0,0x2a,0xdb,0x8b,0xdc,0xe2,0x97,0xda,0xbe,
  0xce,0x07,0xe2,0x22,0x1c,0x5d,0xc6,0xd9,0x08,0x00,
  0x1b,0xf2,0xb9,0x4d,0xbe,0xe9,0x29,0x8c,0xa1,0x83,
  0x99,0x64,0x53,0xc3,0x40,0xde,0xa0,0x22,0x75,0x7a,
  0xe1,0x43,0x81,0xc3,0x66,0x9d,0x20,0x2c,0x76,0x28,
  0x2d,0x91,0x1a,0xe6,0xdf,0xd8,0xcf,0x08,0x64,0x70,
  0x8b,0xfd,0xd5,0xde,0xc0,0x15,0xbc,0x60,0x37,0x31,
  0xda,0x18,0x75,0x5c,0xdb,0xdb,0xf9,0xfb,0x07,0x70,
  0x23,0x34,0x01,0x3d,0x1a,0xe0,0x15,0xe9,0xe8,0x79,
  0x5a,0x73,0x76,0x2f,0x51,0x37,0x44,0x0d,0x97,0x7b,
  0x3f,0x72,0x94,0xb4,0xce,0x6f,0x8f,0xc7,0x6b,0x96,
  0x37,0x8e,0xcb,0x39,0xcc,0xe5,0x19,0xe1,0xcf,0x02,
  0x5b,0x29,0x75,0xd1,0x58,0xc7,0x08,0x9c,0xd4,0xa0,
  0x17,0x13,0x12,0xab,0xc7,0xe0,0x1b,0x56,0xa7,0x86,
  0xed,0xdf,0x14,0xb8,0x18,0xe0,0x9d,0x31,0xc2,0x6c,
  0x33,0x1d,0x95,0xa9,0xee,0xed,0x70,0xf7,0x89,0x44,
  0x97,0xa1,0x58,0xa9,0x4c,0x1f,0x89,0x67,0x76,0x30,
  0xed,0x63,0x0f,0x02,0x1b,0x27,0xe2,0xb8,0x59,0xa4,
  0x25,0x8c,0xc1,0xba,0x35,0xb0,0xa8,0xa5,0xa7,0x31,
  0xea,0x3e,0xd2,0x42,0xe7,0x1f,0x61,0x70,0x86,0xd7,
  0xa0,0x74,0x3a,0xb0,0x76,0x55,0xd7,0x58,0x0e,0x30,
  0xfd,0x33,0xbd,0xbe,0xed,0xf2,0x6e,0x95,0x98,0x15,
  0xc7,0x82,0x53,0x99,0xc4,0x3a,0xb8,0x25,0xaa,0x3f,
  0xfd,0x4b,0xb3,0x37,0xfb,0x29,0x8d,0xd2,0x81,0x9b,
  0x03,0x7e,0xce,0xc0,0x3d,0xbb,0xb2,0xab,0x51,0x4a,
  0xc1,0x18,0xcc,0x14,0xb1,0x90,0x4f,0x6a,0xb6,0xf9,
  0xa9,0xb3,0x44,0x5c,0xea,0x3f,0x85,0x77,0x12,0x06,
  0x12,0x15,0x85,0xe0,0xd5,0xc2,0x9c,0x87,0x6d,0xed,
  0xd2,0x2e,0x05,0x9e,0x43,0xb6,0x2f,0x92,0x20,0xe5,
  0x8b,0xc9,0x98,0xd0,0x25,0x82,0x0f,0xaa,0xfa,0x21,
  0xb1,0x0c,0x36,0x36,0xed,0x0b,0xf8,0x89,0x93,0x65,
  0x76,0x65,0x94,0x7b,0x03,0xd7,0x31,0x32,0x69,0x52,
  0x17,0xf4,0x1b,0xaf,0xc4,0x41,0x32,0xd4,0xeb,0x2c,
  0xf5,0x9c,0x38,0x2c,0xd2,0x25,0x37,0xca,0xae,0xca,
  0x30,0x24,0x2f,0xc4,0x9f,0x33,0x9b,0xd1,0x65,0x04,
  0x23,0x7d,0xf8,0x3e,0x2c,0xbd,0x7f,0x5e,0x91,0x6b,
  0x8a,0x86,0x07,0xc3,0xb2,0xda,0xe8,0xea,0xa4,0x97,
  0xb4,0xd4,0xbb,0xe4,0x98,0x5b,0x17,0x33,0x2c,0x7c,
  0x37,0x4f,0xf9,0x30,0x8d,0x26,0xed,0x0d,0x84,0x7e,
  0x78,0x0f,0x04,0x7f,0xd2,0xb7,0x59,0xba,0xa1,0xfe,
  0x51,0x55,0xd2,0x0d,0x39,0x6b,0x68,0x50,0x9e,0x94,
  0xcd,0xd6,0xe3,0xc6,0x06,0x70,0xec,0xf3,0x7d,0x71,
  0x71,0xf5,0x80,0x75,0x75,0x52,0x2c,0xce,0x0c,0xcd,
  0xcc,0x5e,0x23,0x9f,0x6b,0x5c,0x0a,0xd3,0xad,0xa8,
  0x67,0x7a,0x7e,0x4a,0x40,0x84,0xba,0x2d,0x77,0x38,
  0x9e,0xe8,0x2d,0x1e,0x5e,0xa2,0x70,0x8a,0x71,0x7c,
  0x58,0x3d,0xda,0x7b,0xdc,0x45,0xd7,0xe6,0x18,0x84,
  0x8f,0x7f,0xfe,0x0d,0xc9,0x3f,0x92,0x84,0x6c,0x09,
  0xbc,0x0a,0xf2,0xe9,0x28,0x50,0x8c,0x98,0xda,0xfd,
  0x14,0x32,0x3a,0xef,0xad,0x17,0x34,0x85,0xfd,0x4d,
  0x09,0x8c,0xcc,0x08,0x9a,0x96,0x47,0x2c,0x1a,0xb3,
  0x35,0xd6,0xbd,0x27,0xbf,0xe5,0x77,0x4b,0x7d,0x52,
  0x48,0x91,0x84,0x83,0x80,0x32,0x9a,0xb5,0xb7,0x97,
  0x02,0xc0,0x24,0xce,0xc8,0xbe,0x64,0x0f,0xea,0x7e,
  0xc2,0x1f,0x54,0x7f,0x47,0x14,0x64,0xbe,0x5f,0xe1,
  0x10,0xa8,0x73,0x95,0x2b,0xf3,0xc7,0xc5,0xa8,0x7e,
  0x5c,0xaa,0x3e,0x80,0x79,0x07,0x3e,0xdd,0x16,0x28,
  0x5c,0xd9,0x48,0xb0,0x58,0x8f,0xc4,0xbd,0x4d,0x24,
  0x9e,0x5e,0xcc,0x11,0xf3,0xf7,0x05,0xba,0xbc,0xad,
  0x38,0x18,0x58,0x76,0x99,0xd1,0x7d,0xd7,0xae,0x94,
  0x00,0x0a,0x6d,0x48,0xbb,0xc5,0xd7,0x7f,0x82,0x24,
  0xa3,0x21,0x82,0x6f,0x32,0x75,0x66,0x37,0x2f,0x22,
  0xe5,0x67,0x3b,0x3d,0xde,0xd4,0x0e,0x5b,0xab,0xbc,
  0xef,0xab,0xc7,0x5c,0xf3,0x82,0x22,0xca,0x01,0xa4,
  0xef,0xa5,0xc5,0x71,0x14,0xf8,0xe7,0x7b,0x2f,0x16,
  0x9d,0x14,0x7e,0xd8,0x51,0x5c,0xac,0x5f,0xb7,0x58,
  0x1c,0xa7,0x03,0xe3,0x03,0xf7,0x65,0x25,0xc1,0x66,
  0xca,0xb0,0x0b,0x8f,0x22,0x20,0x87,0x09,0x9b,0xb7,
  0x1f,0x38,0xcb,0x9d,0x11,0x1d,0xf9,0xbd,0x7c,0xb1,
  0x15,0x98,0x58,0x19,0x7b,0x5b,0x10,0xe0,0x81,0xd1,
  0x47,0x4b,0x82,0x52,0xda,0xa4,0x72,0x62,0xad,0x0d,
  0x19,0xcc,0x46,0xe4,0x6a,0x57,0x01,0x63,0x14,0x7e,
  0x14,0x2a,0x16,0x6c,0x43,0x92,0xc8,0x53,0x72,0x49,
  0x24,0xb9,0x94,0xa6,0x0c,0x6e,0x4a,0x7e,0xd0,0xf7,
  0x8c,0xe9,0xc4,0xd2,0xce,0x2e,0x29,0xcf,0x91,0x3d,
  0x4d,0xa6,0x67,0x64,0x12,0xaa,0xf6,0xda,0xfd,0x68,
  0x23,0x22,0x22,0xb7,0xc8,0x2e,0x26,0x13,0xac,0xf6,
  0x0a,0x38,0xe0,0xce,0x0a,0xae,0xfc,0x33,0x7d,0x8e,
  0x71,0xcb,0x34,0xd8,0x2f,0x46,0x83,0x25,0x21,0x80,
  0x8d,0x44,0xa2,0xaf,0xfc,0x6b,0xdd,0x22,0x7e,0x8a,
  0x18,0x88,0xc2,0xf8,0x57,0xcd,0xa6,0x53,0x00,0x24,
  0xe1,0x71,0xef,0x15,0x4a,0x1e,0x5c,0xcd,0x43,0x7d,
  0x4d,0xd0,0xc1,0xf0,0x80,0xbd,0x5b,0x5d,0xdf,0xd9,
  0xe7,0xf8,0x61,0xaa,0xf0,0xb8,0x77,0x97,0x0c,0x77,
  0xbb,0xed,0xe9,0xaa,0x03,0x33,0xc8,0x5f,0x00,0x0b,
  0xdc,0x4d,0xdb,0x9d,0x3d,0x5b,0x5b,0x98,0xb9,0x3a,
  0x71,0xa0,0x32,0xd3,0x4a,0x23,0x8b,0xc1,0xba,0x97,
  0x39,0x75,0x85,0x22,0x1f,0x88,0x55,0xe7,0xe7,0x55,
  0xf2,0xc3,0xa2,0xcd,0x60,0xe0,0x29,0xbb,0x78,0xe2,
  0xf6,0xea,0x82,0x28,0xbd,0xcd,0x4b,0x48,0x8e,0x05,
  0xe0,0xc7,0x7a,0x65,0xe9,0x99,0xed,0x3e,0x80,0xd4,
  0x93,0x72,0x97,0x36,0x40,0xf7,0x16,0x69,0xb3,0x8e,
  0x4b,0xa9,0x78,0xcd,0xd1,0x35,0x9a,0x1d,0x7e,0x29,
  0x22,0x5e,0xf0,0x9d,0xc3,0xda,0x36,0xb0,0x18,0xb7,
  0x84,0xac,0x29,0x1b,0xe2,0x69,0x12,0xf8,0xd2,0xc5,
  0x86,0x1d,0x6e,0xff,0xeb,0x40,0x34,0x85,0x5d,0xb2,
  0xae,0x7f,0x10,0x9f,0x1c,0xd3,0x79,0x53,0x83,0x91,
  0x0a,0x07,0x3d,0x33,0x22,0x1f,0x9d,0x35,0x17,0x6f,
  0xfa,0x9e,0x8d,0x69,0x9d,0x78,0xa9,0xd1,0xfd,0x06,
  0x84,0xac,0x85,0x94,0x4b,0xa2,0x68,0xc4,0xf5,0xeb,
  0x55,0xff,0xf3,0x93,0x32,0x15,0xb2,0xcf,0x4a,0xca,
  0x3f,0x45,0x68,0xcc,0xae,0x05,0x44,0x57,0xd6,0x41,
  0x5d,0x5a,0xed,0xe2,0xef,0x38,0x84,0x57,0xfc,0x79,
  0x42,0x52,0x78,0x35,0xe5,0xab,0x4b,0x97,0x7a,0x95,
  0x61,0xb9,0xda,0xc9,0x85,0x88,0xce,0xc9,0xdf,0xa5,
  0x0b,0x3c,0xff,0xf8,0x1f,0xee,0x31,0xa3,0x45,0x2d,
  0x1d,0x88,0x7f,0x95,0xbd,0x64,0x40,0x08,0xfc,0xbb,
  0x9e,0x5d,0x74,0x78,0x27,0xfa,0x01,0xf5,0xc3,0xe0,
  0x9a,0xce,0x1d,0x9a,0xc7,0x3c,0x88,0xf8,0xdf,0xce,
  0x25,0xfc,0x56,0xa5,0x92,0x13,0x09,0xd2,0x1c,0x05,
  0x8d,0xba,0x63,0x02,0x32,0x8a,0xfc,0x33,0x7f,0xbf,
  0x14,0x1a,0x8e,0x31,0xb4,0x55,0x6d,0x3c,0x4d,0x4c,
  0x0a,0x72,0x49,0x60,0x17,0xdb,0x74,0x21,0xad,0x90,
  0x26,0x3b,0x4a,0x89,0x3d,0x7c,0x13,0x39,0xb0,0x93,
  0xf8,0xc4,0xad,0x86,0xf5,0x61,0xdb,0x62,0x9d,0x28,
  0xae,0xa8,0x9b,0xf7,0x08,0xb2,0xd2,0x7c,0xd3,0x80,
  0x0c,0xfa,0xbb,0x56,0x83,0xf8,0xd3,0x97,0x31,0x83,
  0x2a,0x29,0x47,0xd7,0xb0,0x3c,0x38,0x8b,0x9e,0xd5,
  0xb4,0x4c,0x7d,0x4f,0x44,0x86,0x01,0x16,0x02,0xd5,
  0x96,0x0f,0xcf,0x51,0x65,0x52,0x49,0x38,0xe9,0x7a,
  0xbb,0x13,0xa4,0x02,0xea,0x54,0x3e,0x22,0xdf,0xdc,
  0xf8,0x93,0x29,0x75,0xe2,0x6d,0xfb,0xe4,0x83,0xfe,
  0xb9,0x1a,0x0d,0x88,0x6b,0x72,0xda,0xb5,0xab,0xc4,
  0x2f,0x66,0xd7,0xd3,0x69,0xc2,0x27,0xa7,0xe4,0x07,
  0x84,0xdc,0x9a,0xad,0x52,0x7d,0x1a,0x4d,0x61,0x9d,
  0x4b,0x1a,0xb7,0x58,0xa2,0x23,0xcb,0x7c,0xd8,0x76,
  0x40,0x07,0xdc,0x18,0xdb,0x45,0xda,0x02,0xed,0xbe,
  0x09,0x71,0x9b,0xa4,0x1e,0xed,0x21,0x38,0x3a,0x82,
  0xd5,0x86,0x9c,0x8d,0xde,0x3e,0xb0,0xa9,0xba,0x88,
  0x1f,0xfb,0x8f,0xfc,0x13,0x6a,0x41,0xed,0x6d,0x2e,
  0xab,0x76,0x9f,0x46,0x1a,0xbd,0x33,0x3b,0xf5,0x6e,
  0xbd,0xcb,0xf4,0x59,0x58,0xd2,0x97,0x08,0x7c,0x52,
  0x90,0x9b,0x4d,0x1f,0x97,0x60,0x8a,0xd9,0x4d,0xf7,
  0x07,0xf8,0x6d,0xa7,0x3f,0x88,0x64,0x72,0xc3,0x5a,
  0xe0,0x81,0x25,0xd4,0xda,0x7d,0xa7,0x72,0x85,0x23,
  0xc4,0x15,0xbe,0x11,0x34,0x56,0x71,0xbe,0x2f,0xbe,
  0xb5,0x36,0xb6,0x23,0xdd,0xf5,0xab,0x42,0x68,0x6e,
  0x9c,0x48,0xef,0xc1,0x1d,0xca,0x3e,0xc4,0x3c,0xc3,
  0xe7,0x00,0xd8,0xa5,0x11,0x0c,0xfb,0x82,0xcb,0x2a,
  0x40,0x80,0x61,0xf6,0xa3,0x3e,0xec,0x4e,0x80,0x54,
  0xbd,0x1c,0x9c,0xac,0xdd,0xb9,0x76,0x1b,0x7d,0xb2,
  0xde,0x64,0xb2,0xb6,0x0a,0xc3,0xc3,0x05,0x45,0x8e,
  0x30,0x85,0x0e,0x91,0x7c,0xb2,0xcf,0x68,0x00,0x50,
  0xbc,0xbd,0x6c,0x58,0x6a,0x4a,0x12,0xe0,0x65,0x8f,
  0x93,0x44,0xf4,0x45,0xfa,0xfe,0x09,0xbd,0x03,0x4e,
  0x4b,0x33,0xd4,0x5a,0xc4,0x50,0x0c,0x94,0xb8,0x0c,
  0xe4,0x74,0xca,0x50,0xcc,0x34,0x9a,0xde,0x14,0x00,
  0x6e,0xa7,0x44,0x62,0xed,0x3e,0x60,0xf6,0xfc,0x63,
  0x44,0x47,0x97,0x18,0xa1,0x5b,0x68,0xad,0xef,0x20,
  0xba,0xd3,0x94,0x84,0x24,0x61,0xb8,0xbe,0x3f,0xcc,
  0xbe,0xad,0x74,0x02,0x0f,0x61,0x41,0x6f,0x57,0x3d,
  0xd3,0x9b,0x84,0x6a,0xb4,0x26,0xc5,0x1c,0xd3,0xb5,
  0x3d,0x8d,0x88,0xd1,0x11,0xac,0x32,0xc9,0x6b,0x72,
  0x96,0x29,0x1f,0x0a,0x2c,0x2f,0x6b,0x6d,0x9e,0xc2,
  0xaa,0x71,0x5d,0x2e,0xdb,0x11,0x54,0xa1,0x2e,0x28,
  0x56,0x6b,0xb5,0xde,0x3c,0xc7,0x8b,0x6f,0x90,0xf6,
  0xe1,0x26,0x1f,0x00,0x30,0x4b,0x2f,0x9b,0xb8,0xce,
  0x5d,0x62,0x3f,0xbb,0x91,0x1b,0xcc,0xe5}},
{ 4287, 0xa7a8d256L, {
  0xc4,0xc4,0xfe,0xaf,0x05,0xc7,0xdd,0x0e,0x7e,0x3e,
  0x0e,0x43,0x1f,0x6c,0x51,0xd2,0x1a,0x4e,0x0c,0x66,
  0x4d,0x6d,0xf0,0x5b,0x3e,0x98,0x59,0x83,0xff,0x13,
  0x93,0xc3,0xd7,0x91,0x72,0xdc,0x58,0x4f,0xea,0xd6,
  0x8e,0xf9,0x19,0xad,0x65,0x6b,0x7f,0x7f,0xb9,0x8b,
  0xe5,0x06,0xf8,0xd5,0x61,0x36,0x6d,0xba,0xb9,0x6c,
  0xcd,0x4c,0x2f,0xa4,0xdd,0xa1,0x80,0x35,0xf0,0x6b,
  0x0b,0x7e,0x64,0x25,0x2b,0xc9,0x90,0xaa,0x48,0x49,
  0x35,0x2d,0x4f,0x2d,0x02,0xb0,0x63,0x6f,0x6b,0x1c,
  0xdb,0x38,0x68,0x0a,0xdd,0x45,0xab,0x5d,0x7a,0x9b,
  0xc8,0x86,0x1a,0x2c,0xab,0x45,0xf5,0x3b,0xf0,0x3d,
  0x84,0x25,0x6a,0xd3,0x53,0x6c,0x83,0xb6,0xdb,0xee,
  0xd3,0xb6,0x27,0x3b,0xc0,0x04,0x81,0x6b,0x61,0xfb,
  0x07,0x2a,0x81,0x21,0x56,0x2c,0x66,0x4c,0x67,0x56,
  0x89,0xeb,0x7c,0xf4,0xbe,0xcf,0x60,0x42,0x85,0x3c,
  0x30,0x58,0xf2,0x57,0x94,0xb3,0x5b,0x15,0x1e,0xbd,
  0x10,0x25,0xe7,0x92,0x46,0x3d,0xbe,0xad,0x89,0x26,
  0x03,0x13,0x11,0x7f,0x07,0xd0,0x4e,0x67,0x12,0xd4,
  0xa3,0x42,0x2c,0x96,0x9a,0xc0,0x49,0xf5,0xd5,0x67,
  0xb2,0xe6,0x8d,0x99,0x78,0xd3,0xd7,0x36,0x80,0x60,
  0x5c,0x84,0x73,0x6e,0x03,0x7a,0x3e,0x52,0xe2,0x50,
  0x26,0x85,0x92,0x52,0x1b,0x2c,0x13,0x64,0x22,0xe8,
  0xcc,0xd4,0xce,0x59,0x6e,0x46,0x2c,0x45,0x7d,0xad,
  0xa5,0xd9,0x31,0x19,0x47,0x34,0x93,0x85,0x86,0x75,
  0xd5,0xac,0xfb,0x68,0xff,0x16,0x94,0x12,0x7b,0xb6,
  0xfa,0x47,0x8b,0xc9,0xa0,0xf9,0x0f,0xcc,0x3e,0x8c,
  0x79,0xe3,0x66,0xaa,0xfc,0xad,0xdf,0x90,0x33,0x65,
  0x05,0x08,0x12,0x00,0x70,0x11,0x17,0x05,0x23,0x92,
  0xbb,0x1d,0xd9,0x46,0xe6,0x79,0x3f,0xf6,0x45,0x7d,
  0x82,0xbf,0x61,0xe8,0x69,0x5d,0x96,0x48,0xed,0xc9,
  0xae,0xf3,0xd1,0xc0,0xf3,0x42,0xd1,0x0a,0x47,0xf4,
  0x9c,0x02,0x11,0x75,0x49,0xf8,0xee,0x88,0xee,0x34,
  0x06,0x70,0xf3,0x67,0x59,0x5c,0xc4,0xef,0xa5,0xb2,
  0xb8,0x53,0xa5,0x89,0x13,0x98,0xcb,0xe4,0xa3,0x12,
  0xd8,0x3f,0x15,0xe9,0xb5,0x5e,0xe1,0xa3,0xe6,0xcf,
  0xd7,0xec,0x40,0xca,0x53,0x99,0x27,0x18,0x88,0xcc,
  0xca,0x40,0x1f,0x6f,0xc9,0x32,0x07,0x95,0x16,0xaa,
  0xa7,0xee,0xea,0xbc,0xd7,0x9f,0x1a,0xb9,0x42,0x01,
  0x88,0x1a,0xed,0xc8,0xe4,0x41,0x61,0x0b,0x59,0xe9,
  0xd7,0x23,0x29,0xf6,0x92,0xf3,0x28,0x99,0x88,0x3e,
  0x44,0x2f,0x2c,0x2e,0xec,0x04,0xcd,0x06,0xbd,0x0f,
  0x07,0x45,0x29,0xf5,0x0e,0x0e,0x36,0x6f,0x19,0x8f,
  0x59,0xf1,0xb2,0x82,0xe7,0x44,0x75,0x10,0xdd,0xfd,
  0x4e,0x21,0x2d,0x7b,0x4f,0x19,0x7f,0x1c,0x1f,0x3c,
  0x2c,0x27,0x81,0x55,0x1c,0x8f,0x63,0x52,0xff,0x7d,
  0xe1,0x58,0x6e,0x93,0xda,0x55,0xd7,0x50,0x65,0xb4,
  0x4d,0xb4,0xd6,0x7a,0x2f,0x25,0x93,0xae,0x42,0xb3,
  0xea,0x6e,0xda,0x6b,0xc3,0xf6,0xfb,0x27,0x48,0xfa,
  0xa4,0x29,0x52,0x12,0xbc,0x2c,0x67,0x93,0x7c,0xcd,
  0x47,0xca,0x81,0x1d,0x44,0xb0,0x43,0xd8,0x5e,0x85,
  0x8b,0x48,0xf3,0x65,0xb3,0xb6,0x5b,0xae,0xdd,0xa3,
  0xa8,0x81,0xcc,0xfa,0x93,0x88,0x27,0xfb,0x1b,0xa3,
  0xc8,0x62,0x6d,0x49,0x80,0xb2,0xf9,0xc3,0x8a,0x57,
  0x48,0x15,0x9f,0x3b,0x7a,0x52,0xf1,0xd5,0x01,0xcf,
  0x78,0xa9,0x50,0x44,0xa4,0xe4,0xcc,0xcb,0xdf,0xe7,
  0x6e,0xa7,0x49,0xdc,0xf0,0xc9,0x8e,0xe9,0x8c,0x18,
  0x40,0xd4,0x2d,0xdf,0x0f,0xa7,0x31,0x01,0x7c,0x32,
  0xd0,0xf4,0xdc,0x20,0x38,0x80,0x04,0x04,0x4b,0xe3,
  0xeb,0xb9,0x8a,0x34,0x95,0x7a,0xfe,0x23,0x63,0x8a,
  0x3b,0xa3,0x5f,0x68,0x82,0x6e,0x0f,0xb4,0x6f,0x8b,
  0xe6,0x3f,0x7f,0xc2,0x60,0xb7,0x42,0x64,0xbb,0x8d,
  0x48,0xa6,0x47,0xd2,0xdb,0xdc,0x4d,0xd9,0x00,0xb0,
  0x63,0x3b,0x54,0xc2,0xa4,0xd6,0x31,0xb3,0x8a,0xa0,
  0x3f,0x71,0xe0,0xbe,0x33,0x40,0x76,0x76,0xa4,0x31,
  0x03,0xec,0xd8,0x4a,0xbf,0xb3,0x27,0x0c,0x8c,0x27,
  0xbc,0xef,0x62,0x10,0xb2,0x06,0xe7,0xe3,0xba,0x71,
  0x83,0xf9,0xe2,0x63,0xb7,0x16,0xa3,0x2d,0x8c,0x48,
  0x5f,0x8f,0x34,0x37,0xda,0xf3,0xea,0x01,0xff,0x76,
  0x28,0xbc,0x65,0x8a,0xcc,0x17,0x91,0xb3,0xfa,0x4b,
  0x25,0x7e,0x44,0x07,0xe1,0xfb,0x1d,0x85,0x29,0xa9,
  0xcd,0x88,0x39,0x01,0xbf,0x13,0xf5,0xa9,0x14,0xf4,
  0x1f,0x3c,0xb0,0x84,0xc6,0x7d,0x9c,0x57,0x30,0x96,
  0xa2,0x55,0x14,0xe6,0x5d,0xf6,0xe2,0x7a,0x7b,0x0b,
  0x24,0x48,0x93,0x5d,0x49,0x52,0x70,0x3e,0xfb,0x84,
  0x33,0x1a,0xc0,0xe3,0x9e,0x86,0x60,0x3a,0xde,0x91,
  0xd1,0x80,0xe6,0xe5,0x67,0x43,0xdb,0x49,0xbe,0x56,
  0x54,0xe2,0x9e,0xe7,0x3f,0xe8,0x39,0xaf,0x26,0x34,
  0x33,0x59,0x4e,0xf3,0x3d,0xec,0x79,0x9d,0x27,0x57,
  0x2e,0xf8,0xd8,0x15,0xdd,0x3f,0x58,0xb9,0x88,0x16,
  0x0f,0xdc,0xf8,0xae,0xc3,0x37,0x96,0xfc,0xe6,0xbc,
  0x30,0x19,0x16,0x7e,0x0c,0x53,0x6a,0x86,0xf0,0x91,
  0xdd,0x1f,0x89,0xb5,0x34,0x67,0xf4,0x8c,0x20,0x7c,
  0xa3,0x2f,0x58,0x9b,0xdd,0x1b,0xd3,0x73,0x17,0xb9,
  0x30,0x47,0xd3,0x46,0xc5,0xdf,0x99,0x30,0x65,0x89,
  0xc1,0x43,0xa8,0x4b,0xf8,0xdc,0xb2,0xed,0x69,0xd2,
  0x69,0x0c,0x01,0xc2,0xa7,0xdf,0xdd,0x7a,0x52,0xf5,
  0x34,0x82,0x3c,0x07,0xc8,0x02,0xe6,0x61,0x32,0x4c,
  0xeb,0xf3,0x8f,0x93,0x3e,0x87,0x70,0xf0,0x74,0xd9,
  0xc2,0xde,0xe5,0xc4,0xa0,0x8c,0xa3,0x7d,0x07,0xf5,
  0x72,0x3b,0x78,0xaf,0x42,0x40,0xb1,0x28,0xa2,0xe3,
  0x74,0x8d,0xd6,0x03,0x20,0x15,0x8b,0x90,0x05,0xff,
  0x69,0xc8,0xdd,0x4e,0x8c,0x7d,0xdb,0x2f,0xfb,0xe2,
  0x24,0x6d,0x1d,0x9c,0x1c,0x5f,0xdd,0xcd,0x87,0x7f,
  0xb0,0xfc,0x0c,0x87,0xff,0x2c,0x9c,0x8a,0xbd,0xa1,
  0x8a,0x26,0x69,0x67,0x75,0xf5,0xe5,0x50,0x24,0xe0,
  0x32,0x49,0x4d,0x4f,0xe5,0x6a,0xae,0xc2,0x37,0x35,
  0x41,0xe8,0x31,0x4d,0x6f,0x31,0x7a,0x0b,0xbb,0x37,
  0xac,0x45,0x5d,0x16,0xad,0xd2,0x0b,0x92,0x22,0x30,
  0x72,0x54,0x79,0xbf,0xa3,0x5e,0x29,0x51,0x21,0x61,
  0x87,0x62,0x49,0xb8,0xb0,0xb8,0xe9,0x2a,0xc3,0xa5,
  0x61,0x6f,0xea,0xbe,0x85,0x97,0x91,0x91,0x29,0xb3,
  0xc1,0x9b,0x08,0x3a,0x5b,0xab,0x98,0x84,0xfd,0xb9,
  0xe5,0x84,0x1c,0x2e,0x3c,0xcc,0xe6,0x26,0xf6,0xa9,
  0xcb,0x57,0x19,0xb5,0x15,0x9e,0x4d,0xa6,0x2f,0x76,
  0x5a,0xf0,0x12,0x62,0x2a,0x6d,0x0d,0xc3,0xf1,0x0a,
  0x7c,0xd7,0x8e,0x98,0x05,0xcb,0x64,0xec,0xf1,0x5a,
  0x95,0xbc,0xb1,0xae,0x71,0xc7,0x4d,0xbe,0x6d,0x7c,
  0x35,0xc7,0x6d,0x47,0x29,0x97,0xb4,0x37,0x5a,0xa5,
  0x41,0xd7,0x7c,0xd0,0x6f,0x82,0x9b,0xd4,0x6e,0x8c,
  0x2e,0x03,0x48,0xe0,0xb2,0xb9,0xa7,0xff,0x78,0x14,
  0x7b,0xad,0xdc,0xe8,0xf4,0x05,0x80,0xa8,0x3c,0xda,
  0x4d,0x7e,0xb1,0xca,0x4e,0x21,0x4c,0xe9,0xf5,0xba,
  0x75,0x23,0xbd,0xbd,0x03,0x6f,0x76,0xaa,0x6e,0xee,
  0xbf,0xea,0x9b,0x9b,0xd2,0x8f,0xa0,0x52,0x37,0xdd,
  0x2d,0x85,0x5b,0xde,0x4f,0xa9,0xff,0x9b,0x92,0xf4,
  0x55,0x07,0x18,0x12,0xc4,0x1b,0x82,0x3a,0xc6,0xf0,
  0x29,0x85,0xda,0xc4,0x20,0xad,0x54,0xc0,0xff,0x8b,
  0x9d,0x2c,0x10,0xf8,0x0b,0x5f,0xa1,0x0a,0xfa,0x33,
  0xff,0x4f,0x3a,0x17,0x62,0xfe,0x32,0xe4,0x39,0xf8,
  0xd4,0x62,0x7d,0xaf,0x26,0x9d,0x5c,0x7a,0x5e,0x5b,
  0x06,0xfb,0x88,0x16,0xf4,0x93,0x76,0x95,0x9d,0x70,
  0xc9,0x9c,0xc0,0x03,0xb3,0x22,0x02,0xe6,0x06,0x3b,
  0xde,0xda,0x9d,0x5c,0x89,0xc3,0xf9,0xe5,0x3e,0x57,
  0x41,0x44,0x53,0xc9,0x5a,0x47,0x5c,0xd0,0xdc,0xf9,
  0x41,0xa5,0x96,0x01,0xa9,0x49,0x23,0xab,0x2f,0x29,
  0xe6,0x0e,0x03,0x83,0x6a,0x8d,0x46,0x63,0x72,0x84,
  0xbb,0xb3,0xc8,0x0e,0x7c,0x23,0x55,0xd8,0xf3,0x31,
  0xd2,0x34,0xd7,0x68,0x35,0x80,0xb1,0x58,0x2b,0xe1,
  0x81,0x11,0xef,0x85,0x94,0x59,0x12,0xda,0xbc,0x84,
  0x5f,0x77,0x38,0x27,0x85,0xb4,0x4a,0xda,0x8d,0x3e,
  0x0c,0x5f,0x72,0xe3,0xc7,0xa8,0x63,0x78,0x00,0x8e,
  0x59,0x82,0x9f,0x48,0x07,0x33,0xa1,0x19,0x0d,0x5e,
  0x9d,0x6c,0xd5,0xd5,0x94,0x5b,0x8a,0xde,0x35,0x17,
  0x1c,0x41,0x76,0x8f,0x24,0x3d,0x37,0x87,0xb5,0x37,
  0x15,0x0f,0xb9,0xb4,0x57,0xc0,0xe7,0xf9,0xd9,0xf5,
  0x57,0x77,0x61,0x2c,0x4c,0xf5,0x87,0xd6,0xd4,0xbd,
  0xed,0xf0,0xfe,0x63,0x7f,0x23,0xa0,0xb6,0xaa,0x56,
  0xee,0xc0,0x65,0xa7,0x74,0xbc,0x68,0x5c,0xb5,0x41,
  0x51,0x0c,0xb8,0xb2,0x39,0x05,0xa8,0xc0,0xdb,0x7c,
  0x7d,0xc9,0x6c,0x7c,0x2c,0xec,0x9f,0xcd,0xa2,0x49,
  0x23,0x90,0x09,0x88,0x38,0x7e,0x44,0xa0,0xda,0xfa,
  0xe1,0x2b,0x06,0x9a,0xdd,0x3f,0x9f,0x85,0x00,0x7a,
  0x01,0x7d,0x43,0x6e,0xf9,0x70,0x5a,0x98,0x3d,0xfc,
  0xe2,0x60,0x8d,0xeb,0xe8,0xc5,0x69,0x2c,0x65,0x43,
  0x26,0x46,0x6e,0x2d,0xe0,0x4c,0x6c,0x7f,0xd1,0x6c,
  0xfa,0xd3,0xea,0x3d,0x41,0xe3,0xad,0x9b,0x7c,0xea,
  0x97,0x5e,0x4a,0x24,0x49,0x32,0xe9,0xb3,0x5f,0x4e,
  0xf6,0x85,0x95,0x65,0xb2,0x75,0xb1,0x1f,0xf5,0x82,
  0x8b,0xef,0x55,0x75,0x2c,0x96,0x59,0xda,0x31,0xd5,
  0xc4,0xc9,0x33,0x0f,0xed,0x7c,0x41,0xd7,0x2f,0xa0,
  0x25,0x26,0x26,0xba,0x8b,0xd8,0x30,0x3c,0xf7,0x25,
  0xbe,0x83,0x14,0x14,0xf8,0x40,0xaa,0x51,0x1a,0xdc,
  0x26,0xdf,0xa5,0x59,0xee,0x92,0xd6,0x2f,0x69,0x05,
  0xd0,0x8f,0x2b,0xf6,0x49,0xb6,0xce,0x79,0xf2,0xc6,
  0x9e,0xb1,0x49,0xb2,0xc5,0x41,0xf3,0x6f,0x93,0x0d,
  0x4b,0xb9,0xec,0xf0,0x13,0xda,0x83,0xe9,0x0a,0xec,
  0xee,0xda,0x7b,0x1a,0xd0,0xc5,0xd0,0x9e,0x3e,0xc3,
  0x64,0xdd,0x74,0xad,0x8f,0x39,0xef,0x82,0xa8,0x82,
  0x90,0xf4,0x3b,0x7c,0xe4,0x4e,0x57,0x67,0x37,0x61,
  0x54,0x26,0x3b,0xcf,0x40,0x0b,0x94,0x10,0xa9,0xd3,
  0xd3,0x0e,0xb0,0x47,0xbb,0x3f,0x80,0xaa,0xc2,0x29,
  0x2c,0x52,0x1d,0x68,0xce,0x01,0xb6,0x25,0x69,0xee,
  0x86,0xbd,0x14,0xc1,0x8c,0x54,0xcc,0x21,0x64,0x76,
  0xf4,0x38,0x84,0xa4,0x7f,0x3f,0xe3,0x00,0xea,0xa5,
  0x29,0x16,0xf7,0x46,0x7e,0xc6,0x47,0x35,0xeb,0xb0,
  0x23,0x72,0x6d,0x37,0x33,0xfa,0x8b,0x00,0x1b,0xef,
  0x76,0x0f,0x27,0xfa,0xb3,0xa7,0x39,0x96,0xa7,0x23,
  0x3c,0xd0,0x3a,0x33,0x16,0xb8,0xf9,0x5d,0xed,0xe5,
  0x0e,0x10,0x57,0x7b,0x47,0x8a,0x75,0xd2,0x8a,0x90,
  0xc2,0x00,0x9f,0xe9,0xfa,0x52,0x90,0x34,0xe9,0x37,
  0x57,0x25,0x07,0x91,0x58,0x1d,0x4a,0x52,0x7b,0x37,
  0x37,0x89,0x48,0x8e,0x04,0x8f,0x18,0x7a,0x62,0xa3,
  0x0a,0x24,0xa3,0xaa,0x0d,0x9e,0xfc,0x9e,0xd2,0xe5,
  0xd5,0x29,0x0a,0xdd,0xbb,0x63,0xfa,0x05,0xb5,0x75,
  0x3c,0xec,0xfe,0x84,0x7a,0x03,0x14,0x92,0x7d,0x76,
  0x35,0x87,0x9a,0xd9,0x31,0xa7,0x77,0x2e,0x45,0x49,
  0x13,0x1b,0x72,0x1e,0xf8,0x2d,0x81,0xf2,0x32,0x36,
  0x68,0x6f,0x22,0x66,0xf3,0x9c,0x69,0x07,0x2e,0xe6,
  0x7d,0x64,0x6e,0x17,0x3d,0x9f,0xbf,0xb4,0xcd,0x04,
  0xfd,0xe1,0x1f,0x6f,0xff,0x17,0x9d,0x80,0x0a,0xcf,
  0xb6,0x72,0x3e,0xd8,0xd8,0x32,0x74,0x42,0x39,0xa2,
  0x28,0xb7,0x06,0x96,0xce,0x43,0x36,0x8d,0xf7,0x03,
  0x92,0xf4,0xe4,0xb1,0x64,0xe3,0xc9,0x01,0x63,0xd3,
  0xd0,0x19,0x45,0x0f,0xf1,0x1d,0x41,0x65,0x5f,0x7a,
  0x08,0x88,0x31,0x0e,0x1e,0x00,0x52,0x54,0x8d,0x49,
  0x58,0x1f,0x3e,0x3c,0xd1,0xa2,0x20,0x9a,0xa3,0x83,
  0x6d,0x73,0x9d,0xb2,0x82,0x8e,0xcf,0xc3,0xf4,0x2f,
  0x3e,0xfc,0xb7,0x6f,0x0a,0xd5,0x6f,0x5c,0x2a,0xfd,
  0xa6,0x82,0x1c,0xe4,0xbe,0xed,0x86,0xde,0x87,0x29,
  0x62,0xf4,0x9c,0xff,0xa6,0x1f,0x8d,0x76,0xe2,0x81,
  0xa5,0x20,0x7d,0x5c,0x90,0x88,0x31,0xff,0xe4,0x5b,
  0xfc,0x8a,0xdd,0x19,0x6e,0x9c,0x06,0xf4,0x7a,0x8e,
  0x1d,0xdc,0x82,0xba,0xdb,0x29,0xd9,0x69,0x9f,0xbb,
  0xea,0x44,0xdc,0x68,0xa0,0x6c,0xf0,0xd1,0x6b,0xd4,
  0x2d,0x68,0x5f,0x0a,0x81,0xcd,0xa6,0x87,0xc2,0x21,
  0x15,0xdf,0xfd,0x98,0x99,0xd9,0xc1,0x72,0x42,0x60,
  0x2e,0x2c,0xa4,0x0a,0x94,0x44,0x76,0x84,0x15,0xe1,
  0x59,0x42,0x49,0xb8,0x4d,0xca,0x85,0xf3,0x52,0x47,
  0x14,0x67,0x27,0x12,0xff,0xc0,0xeb,0xc0,0x33,0x2d,
  0x20,0x61,0x59,0xc4,0x6b,0xee,0x08,0xe1,0x72,0x1e,
  0xc2,0xcb,0x60,0x0c,0x83,0xad,0xd6,0x09,0xa1,0x28,
  0x50,0xb5,0x90,0x77,0xc7,0x8f,0x38,0xb2,0x50,0x6b,
  0xdf,0x70,0xcc,0x39,0x35,0x37,0x27,0x3d,0x18,0x99,
  0x5b,0xda,0x65,0xbc,0xe6,0xe8,0x69,0xbd,0xf1,0x0a,
  0xe5,0x42,0xc0,0x75,0xb9,0x87,0x05,0xf1,0x3a,0x55,
  0x5c,0x19,0xc5,0x28,0x52,0xfa,0x5f,0x79,0x38,0x77,
  0x13,0x93,0x52,0x78,0x4f,0x38,0x60,0xb9,0xf5,0x52,
  0xc3,0xdb,0x94,0x83,0x50,0x4d,0x0b,0x55,0x3f,0x45,
  0xaa,0x9b,0x5e,0x70,0xc4,0xb1,0x6a,0x23,0x2a,0xa2,
  0x9b,0x3d,0x36,0xed,0xb5,0x85,0x25,0x16,0x3e,0x1b,
  0x68,0x02,0xf6,0xfc,0x85,0x46,0x49,0x90,0x9c,0x88,
  0xd5,0x46,0x24,0x34,0xb6,0xe8,0xe5,0x21,0x0b,0x0f,
  0xc3,0xa6,0x4d,0xf9,0x93,0x02,0x7f,0xb9,0x18,0xbd,
  0xd4,0x80,0xbf,0xca,0x7c,0x45,0x10,0xc6,0xd5,0xac,
  0x4e,0xab,0xf3,0x72,0xdf,0xa9,0x5a,0xc4,0xca,0x66,
  0xd3,0x8e,0x0c,0x20,0x87,0xa0,0x23,0x06,0x59,0x3b,
  0xc4,0x2d,0xbc,0x83,0xf7,0x38,0xc8,0x07,0xfe,0x9e,
  0xb4,0x4d,0x49,0xa7,0xbf,0x28,0x50,0x1a,0xec,0x1b,
  0x80,0xbf,0xa9,0x8c,0xe0,0x30,0x2c,0x03,0x37,0x85,
  0x3e,0xfb,0xb2,0xfa,0x7e,0xa9,0x33,0x47,0xb1,0x31,
  0xe5,0x65,0x7e,0x2e,0x0c,0x3e,0x56,0x5c,0x58,0x42,
  0x77,0xd8,0x01,0x20,0x64,0xe1,0x51,0x91,0xe4,0x88,
  0x16,0x23,0x83,0xc9,0x1d,0x01,0x72,0x50,0x48,0x23,
  0x82,0x2d,0x88,0x00,0x5b,0x94,0x3e,0xb1,0xf1,0x96,
  0xf3,0x68,0x6e,0xf5,0x89,0xd3,0xd6,0xda,0x64,0xbb,
  0x62,0x7a,0xde,0xe5,0x43,0xfb,0xe6,0xb6,0x4c,0x2f,
  0xd9,0xce,0x5c,0x62,0xce,0xb8,0xf6,0x0d,0x69,0xe7,
  0xa3,0x5d,0x50,0x12,0x52,0xd9,0xe5,0x28,0xb3,0x49,
  0xe3,0x15,0xc3,0xc1,0xfa,0x07,0xbd,0xe0,0xbd,0x09,
  0x0f,0x96,0xd7,0x6c,0xf8,0xa5,0x24,0xef,0xb2,0x8d,
  0xd6,0x56,0xea,0x26,0x68,0x3c,0xff,0x4d,0x65,0xb2,
  0x96,0x48,0xc7,0x59,0x0a,0xc1,0x60,0xc7,0xa2,0x1d,
  0xd0,0xb1,0xb4,0xa7,0x1d,0xac,0x4c,0x41,0x9b,0xff,
  0xcf,0x72,0x55,0xb9,0x98,0xbd,0xf6,0x98,0x0a,0x5b,
  0x4a,0xa0,0xa3,0x12,0xf9,0xad,0xd3,0x5a,0x74,0x75,
  0x77,0x44,0x27,0x2b,0xeb,0x44,0xd8,0x38,0x86,0x73,
  0x37,0x55,0xe5,0x8c,0x0e,0x7e,0x49,0x04,0x16,0x53,
  0x5f,0x60,0xf3,0x03,0x72,0xec,0xb0,0x46,0x46,0x25,
  0xbb,0xbe,0x69,0xe2,0xe9,0x55,0x27,0xc1,0x8d,0xad,
  0x35,0xc4,0x02,0x1a,0x50,0x10,0x98,0x99,0x15,0xae,
  0xec,0x74,0x0f,0xdf,0x77,0x81,0xcb,0x28,0xc7,0x12,
  0x4d,0x83,0xd0,0xb6,0x65,0xb9,0x0b,0x8c,0x7b,0x98,
  0x39,0xb0,0x5c,0x3b,0xca,0xac,0x4c,0x63,0x45,0x61,
  0x11,0x31,0xd5,0x20,0x10,0x4d,0xa2,0xdc,0x75,0x69,
  0xee,0xc2,0xec,0xbe,0x78,0x52,0x77,0x84,0xde,0xf2,
  0x1c,0x18,0xa2,0x79,0x53,0x6d,0x25,0x9f,0xd0,0x6b,
  0x00,0xe1,0x9c,0xd6,0x02,0xad,0x23,0xa4,0x89,0x98,
  0x0d,0x77,0x5a,0xfa,0x35,0xd2,0x4c,0xac,0x56,0x2a,
  0x9f,0x73,0x42,0x41,0xec,0x96,0xae,0x11,0x35,0x7e,
  0x7c,0x36,0x60,0x19,0x0c,0x62,0xc6,0x2f,0x06,0x4f,
  0xc7,0x13,0xc6,0x21,0x0d,0xfb,0xf3,0x59,0xa7,0x4a,
  0x84,0x46,0xbd,0xc6,0x88,0xa9,0x5c,0x36,0xba,0x92,
  0xb5,0x37,0xc8,0x15,0x50,0xd4,0x77,0x16,0x03,0x7d,
  0x65,0xca,0x90,0x2b,0xeb,0x9e,0x26,0xde,0xf7,0xcd,
  0x28,0x7b,0x14,0xe5,0x42,0x9c,0x8e,0x9e,0xd2,0x49,
  0x30,0x87,0x80,0xf8,0x9c,0xd0,0xcc,0x13,0xe6,0xcf,
  0x90,0x4b,0x99,0x21,0x76,0x84,0xbf,0x9c,0x63,0xb6,
  0x69,0x8b,0x32,0x7d,0x71,0x74,0x19,0xff,0x12,0xec,
  0x48,0x43,0x73,0xc8,0x3b,0x10,0x98,0x08,0x23,0x7e,
  0xd7,0xb4,0xc9,0x71,0xd5,0x3f,0xf5,0x94,0xdb,0x58,
  0x4a,0x45,0xe4,0x7c,0xc2,0x55,0xf0,0xdc,0x54,0x03,
  0xc8,0x9d,0x46,0x3b,0x65,0x81,0x4b,0xfe,0x89,0x6f,
  0x7c,0x61,0x23,0x46,0xd2,0xf8,0x85,0xc7,0x8c,0x61,
  0x20,0xd6,0xa6,0x04,0x53,0x68,0x59,0x43,0x44,0xad,
  0x46,0x0c,0x4a,0x8c,0x48,0xb0,0x0e,0x93,0xae,0x97,
  0x02,0x2a,0xf8,0x25,0x70,0xca,0x1d,0xf6,0x92,0xa9,
  0x57,0xb2,0x80,0xfd,0xb6,0xd3,0x65,0x0f,0x16,0xaa,
  0xbc,0x5d,0xb6,0x07,0xe9,0xfe,0xb7,0xf7,0x92,0x65,
  0x8f,0x94,0x8f,0x87,0xba,0x00,0x52,0xd7,0xf6,0xe4,
  0x81,0x4d,0x96,0x01,0x4a,0x4c,0xd4,0xaf,0x5b,0xea,
  0x59,0x17,0x47,0x10,0x1e,0x31,0x0e,0xd5,0x28,0xa0,
  0x3a,0xb7,0x35,0xca,0x3f,0xef,0xca,0x91,0xc6,0xc0,
  0x75,0x47,0x0d,0x0b,0x48,0x57,0x57,0x1c,0x06,0xb2,
  0x07,0x60,0xc9,0x4e,0x70,0xe8,0x7f,0x7e,0xbd,0xa8,
  0x1f,0xf8,0x5f,0x54,0xc2,0x9e,0x43,0x8c,0x2f,0x09,
  0x4c,0xa4,0x51,0x59,0xaf,0x99,0xb0,0x06,0xb6,0xb6,
  0xb8,0xbd,0x16,0x82,0x0b,0x86,0x6a,0x8b,0x05,0x27,
  0x33,0x24,0x1f,0x92,0x78,0xe1,0x31,0xbb,0x6d,0x60,
  0xc4,0xb9,0x05,0x15,0x12,0xb4,0xaf,0xc2,0xbb,0x65,
  0x79,0x73,0x22,0x8f,0xf5,0x2d,0x16,0x5f,0xb8,0x1b,
  0x87,0xeb,0x3f,0xa6,0x7e,0xb7,0x88,0xaf,0x72,0xf5,
  0x0f,0x36,0xaf,0x14,0x4c,0xc1,0xc9,0xfb,0x84,0x84,
  0x60,0xfd,0xf7,0x82,0x8c,0xed,0xaf,0xa2,0x4c,0x68,
  0xbd,0xd3,0x53,0xfc,0x7a,0xd1,0xb3,0x02,0x80,0x25,
  0xf7,0x90,0x5c,0xa6,0xa4,0xa8,0x68,0x6d,0xa3,0xec,
  0xf1,0x03,0xe9,0xe9,0x85,0x75,0xd6,0x34,0x18,0x22,
  0x9c,0xd5,0xf6,0xf0,0xd2,0x70,0xc1,0x85,0x72,0x42,
  0xab,0x69,0xd2,0x07,0x10,0x76,0xaf,0x78,0xe4,0x52,
  0x64,0xd5,0x55,0x4d,0xbe,0xda,0xc2,0x94,0x0e,0xda,
  0xb7,0xab,0xb0,0xad,0x9b,0x82,0x1d,0x5c,0x07,0x8f,
  0x9e,0xb2,0xf8,0x70,0xb9,0x08,0xe7,0x68,0x80,0xcb,
  0xba,0xe4,0xa0,0x0f,0x31,0x5f,0xe9,0xf4,0xf3,0xf8,
  0xce,0xaa,0xa3,0x7e,0x57,0x3e,0x00,0x74,0x9a,0x08,
  0x03,0x39,0xba,0xfc,0xa9,0x74,0x04,0x90,0xdc,0x85,
  0x5b,0x97,0x69,0xfc,0xa6,0x9b,0x5b,0x90,0x8f,0x4e,
  0x88,0x5d,0xf9,0x2b,0xdc,0x50,0x69,0xdc,0xc5,0x03,
  0xe4,0xc8,0x3c,0x9f,0xc4,0xe6,0x13,0xc9,0x76,0xef,
  0x4e,0xd2,0x86,0xb7,0xce,0x2d,0x52,0x29,0xbd,0xe1,
  0x77,0x45,0x3f,0x70,0x70,0x1b,0xc1,0xd9,0xf7,0x86,
  0xdc,0xdc,0x4e,0x19,0x7b,0x13,0xff,0x8e,0xdc,0x75,
  0x7d,0x2a,0x47,0x04,0xe1,0x15,0x31,0x34,0x3e,0xee,
  0x15,0xb6,0x33,0x54,0x26,0xa3,0x6f,0xe7,0x7c,0x67,
  0x6d,0x58,0x43,0xbc,0x71,0xbe,0xcf,0x70,0x4c,0xab,
  0xe6,0xc9,0xd5,0x2d,0xcd,0xb6,0x43,0xfe,0xea,0x81,
  0xec,0x00,0x37,0x1f,0x54,0x5e,0xc2,0xc4,0x45,0x3e,
  0x2b,0xb3,0x97,0x6e,0x6f,0x08,0x2c,0x3e,0x79,0x78,
  0xe9,0x5f,0x41,0xbe,0x8c,0x0f,0x74,0xcf,0x0d,0x5f,
  0x51,0xfa,0x5f,0x88,0x19,0xb3,0xe6,0xdc,0x77,0x2c,
  0x1a,0xa2,0xdf,0xb1,0x10,0x4e,0xba,0x3c,0x8c,0x33,
  0xb4,0x75,0x92,0xf6,0x33,0x1e,0x05,0xa7,0xee,0x12,
  0x06,0x3f,0x0c,0x65,0xc7,0x26,0x19,0xae,0x02,0x90,
  0xda,0x1c,0x33,0xb9,0xce,0x43,0x07,0x88,0x80,0x93,
  0xbb,0x34,0x08,0x4d,0x2a,0x3b,0x6b,0x2f,0xe2,0x59,
  0x42,0xe9,0x98,0x4e,0x4e,0x60,0x74,0x67,0x0e,0x76,
  0xf8,0xe8,0x93,0x2b,0xa1,0x61,0x6e,0xa8,0xe9,0xee,
  0x3b,0xa4,0x23,0x43,0xf1,0x4d,0x7e,0x5c,0x7d,0x60,
  0xb6,0xbf,0x49,0x4e,0x0d,0x98,0xae,0x82,0xff,0xbc,
  0xf8,0xf7,0xa4,0x8b,0x22,0x45,0xec,0x91,0xed,0xd5,
  0x7f,0x28,0x79,0xa2,0x6b,0x6a,0xf0,0xe9,0xc7,0x6d,
  0x4a,0x7d,0x2c,0x93,0xcb,0x39,0x2b,0x7a,0xbb,0x2b,
  0x36,0xb4,0x22,0xdb,0x3f,0x45,0x20,0x2c,0xd6,0x0e,
  0x01,0x55,0x36,0x7b,0xf8,0xa2,0xe5,0xe8,0x8b,0xac,
  0x55,0xd5,0x29,0x81,0x69,0xf5,0xba,0x94,0x6f,0x76,
  0xbf,0xa5,0x2a,0xe2,0x80,0x69,0x27,0xa1,0x95,0xfd,
  0xaf,0x97,0x52,0xe5,0x12,0x4a,0x87,0xf7,0x32,0x13,
  0xa4,0x87,0xe8,0xcd,0x08,0x51,0xc2,0xc3,0xe6,0x31,
  0x39,0xa5,0xd7,0x63,0x87,0x57,0xcc,0xae,0xf8,0x62,
  0xab,0xa7,0xf9,0xfe,0x8d,0x0b,0x48,0x14,0x02,0x7b,
  0x27,0xa6,0x02,0x10,0x74,0x0b,0x61,0x36,0xce,0x47,
  0x68,0x07,0xed,0x3f,0x6a,0x74,0x96,0x36,0x23,0x8f,
  0x98,0xce,0x36,0x91,0xcc,0xc3,0x9c,0x15,0xd8,0x9f,
  0x90,0xff,0x45,0x92,0x0f,0xb9,0x9d,0x71,0xf0,0x6b,
  0xb8,0x58,0x72,0xa5,0x97,0xdc,0x1a,0x2d,0x13,0x3d,
  0xbc,0xab,0x0b,0xf3,0x3d,0xd8,0xb6,0xd9,0xed,0x8e,
  0x78,0x7d,0x8e,0xbe,0x0f,0x9d,0x77,0xad,0x0e,0x67,
  0x18,0xc7,0xbf,0x8b,0x6c,0x56,0x67,0x86,0x84,0x7a,
  0xc3,0x40,0x26,0xcf,0x33,0x63,0xa7,0xea,0x3c,0x94,
  0x78,0xb5,0x11,0x06,0x73,0x20,0xa4,0xea,0xcd,0xb2,
  0x52,0xe6,0x79,0x11,0x71,0xe6,0x68,0xd8,0x6c,0xec,
  0x53,0x30,0x2c,0x79,0xff,0x60,0xdc,0xa6,0x4a,0x18,
  0x3a,0xc2,0xcd,0x4b,0xc9,0x40,0x6b,0x6d,0x2b,0x39,
  0x1f,0x7d,0x1f,0x99,0x8e,0x90,0x7f,0xf6,0x68,0xeb,
  0xe2,0xbb,0x1b,0x0f,0x34,0x1a,0x6f,0x10,0xc0,0xb9,
  0x29,0xfa,0x7b,0xf6,0x45,0x44,0x37,0xb1,0xb1,0x62,
  0xea,0xd1,0xdf,0x09,0x6a,0x6d,0x99,0xe9,0x64,0x01,
  0xd4,0x46,0xbd,0xf0,0x55,0xf1,0x0a,0xc4,0x02,0xcb,
  0x7d,0x2b,0xc5,0xf9,0x21,0x0b,0x3d,0x58,0xbc,0xef,
  0xba,0xa6,0xc0,0x99,0xaf,0x2a,0x07,0x48,0x13,0x6b,
  0x49,0xe7,0xb1,0x06,0xd7,0x07,0xf8,0xe2,0xcb,0xfa,
  0xad,0x49,0x25,0x72,0x42,0x46,0x7d,0x7f,0x9f,0x39,
  0x6e,0x59,0xdf,0x2e,0xf3,0x8e,0x58,0xfa,0xd6,0x6b,
  0x65,0x20,0x53,0x16,0x26,0x2a,0x1d,0x1e,0x0c,0xe9,
  0x18,0xb9,0x32,0x3d,0x2c,0x74,0x84,0xa9,0xf3,0x23,
  0xe3,0x62,0x7c,0xc2,0x90,0x6f,0x51,0xe9,0x69,0x27,
  0x54,0xce,0x47,0xa7,0xe5,0x6e,0xd2,0x02,0x8c,0xde,
  0xeb,0xa5,0x98,0x1d,0xe2,0xc4,0x91,0x66,0x6d,0x85,
  0x89,0x50,0xe7,0x06,0x13,0x77,0x75,0x64,0x60,0xdf,
  0x8b,0xb5,0xad,0xd3,0x5c,0x92,0x41,0x2e,0x95,0xcd,
  0x0d,0x80,0x72,0xa5,0x9e,0x55,0x69,0x2f,0xbb,0xd6,
  0xb4,0x45,0x27,0x9b,0x4b,0x3a,0x13,0xc0,0x9e,0x73,
  0x9f,0x29,0x28,0x4d,0xfc,0x85,0xdf,0x3d,0xb3,0x74,
  0x0b,0xc0,0xf5,0x7d,0x65,0x93,0xd2,0xce,0xc2,0x8e,
  0xa5,0x77,0xd3,0xcc,0x12,0x1e,0x06,0x25,0xde,0xa4,
  0x99,0x7e,0xcd,0xc1,0xcb,0xca,0x46,0xaa,0x07,0xfa,
  0x1f,0x12,0xba,0x14,0x90,0x20,0xa7,0x62,0xee,0x69,
  0xf0,0x93,0xe0,0xc3,0x5f,0xf3,0xe1,0x65,0x18,0xc0,
  0x09,0xb1,0x3e,0xd7,0x73,0x09,0xa1,0xb9,0xb3,0xa8,
  0xb3,0xd2,0xbb,0x6e,0xe6,0x4b,0x8e,0x8d,0xad,0x7c,
  0xf7,0x9e,0x10,0xd7,0x61,0x6f,0xca,0x43,0xd5,0xe3,
  0x03,0xde,0x94,0x41,0xb5,0x07,0x4a,0x56,0xc1,0xfd,
  0xff,0x74,0xd0,0xba,0xe2,0xb6,0x05,0x70,0x44,0xb2,
  0xed,0x3b,0x50,0xfd,0x12,0xb2,0x6c,0xdd,0xf5,0x41,
  0xc0,0xf8,0x20,0x54,0x39,0xd5,0x5c,0x83,0x2c,0x1d,
  0x80,0x2b,0x91,0x50,0xe5,0x74,0x07,0xea,0xe4,0x4b,
  0x9c,0xd1,0x86,0xed,0xce,0x98,0x9f,0x3b,0x75,0x94,
  0x7c,0x35,0x8c,0x9c,0x8a,0xc5,0x72,0xe6,0x48,0x9e,
  0x03,0xc8,0xc9,0x94,0x19,0xae,0x08,0x20,0x98,0xed,
  0x6b,0x34,0xbe,0xf1,0x21,0x8d,0x89,0xc0,0xc8,0xff,
  0x54,0x44,0x34,0xe0,0xe1,0xbe,0xa5,0x53,0xa4,0xed,
  0xf1,0xa7,0xb6,0xba,0x3c,0xcf,0x68,0x44,0xef,0x00,
  0x31,0x5a,0x34,0xf0,0x4b,0x56,0x7d,0xd4,0x16,0x45,
  0xd3,0x6b,0x89,0x08,0x4b,0x6a,0xc6,0xf1,0xbd,0x6b,
  0xde,0xae,0x12,0x94,0x68,0x4e,0x63,0xd0,0x93,0x52,
  0xd0,0xc4,0xac,0x05,0xb4,0xf7,0x5b,0x31,0xcc,0x71,
  0x76,0x9f,0xdc,0x00,0xa7,0x28,0x6a,0x6e,0x19,0x28,
  0xd9,0xf7,0xd6,0xeb,0x8c,0x3f,0x3a,0xef,0x0f,0xcd,
  0x42,0xe0,0x91,0xee,0xe5,0x46,0xe6,0x40,0x77,0xb2,
  0xb1,0xee,0x51,0x8e,0xee,0xf9,0xb6,0x58,0x67,0xcf,
  0x80,0x40,0xc6,0x57,0x2b,0x52,0x96,0x65,0x42,0xa5,
  0x32,0x84,0x85,0xc4,0x72,0x6a,0x0a,0x58,0xaa,0x81,
  0x0a,0x5c,0x6f,0x5c,0xea,0x5d,0x55,0xa0,0xb6,0xbc,
  0x6f,0x36,0xfc,0x35,0x8d,0x27,0x88,0x23,0x8d,0xca,
  0xc9,0xbf,0x4e,0x4e,0x83,0xc0,0xb9,0x8d,0x19,0x63,
  0x0f,0x23,0xbf,0x7e,0x7f,0xa9,0xdc,0xd4,0x49,0x92,
  0x90,0xb8,0xc8,0x8c,0xee,0x56,0xb4,0x76,0x79,0x41,
  0x40,0x42,0x00,0x8e,0x91,0x84,0x4e,0x4a,0x11,0x67,
  0xad,0x20,0x8b,0x6d,0x9f,0x0a,0x16,0x7b,0xdf,0x60,
  0x0d,0x6f,0x18,0xd5,0xfc,0x06,0x2b,0xb0,0x7c,0xa5,
  0xf1,0xbc,0xe7,0xf1,0x4a,0x78,0x75,0x99,0xc2,0x87,
  0x00,0x70,0xa7,0x8b,0xdd,0x46,0x96,0xf3,0xc1,0x75,
  0x53,0xce,0xe4,0x6c,0xa4,0xe0,0x72,0xcf,0x90,0xef,
  0x74,0x81,0xab,0x5c,0x73,0xf6,0xd4,0xe8,0x8f,0x97,
  0x6f,0x8f,0x07,0x17,0x1b,0xe4,0x5d,0xb1,0xd7,0x1f,
  0x26,0x2b,0xed,0x0a,0x97,0x91,0xeb,0x09,0x61,0x7b,
  0xf8,0xd5,0xfd,0xa4,0x31,0x70,0x9a,0x06,0x58,0x29,
  0x9d,0xc8,0xb8,0xa4,0xdf,0xd3,0x88,0x3c,0x84,0x5f,
  0x5b,0xaa,0x8a,0x49,0xb5,0x21,0xda,0xa0,0x2b,0x3b,
  0x1b,0x23,0x11,0x18,0xc7,0x42,0x88,0x61,0x48,0xe1,
  0x8a,0xe5,0xa9,0x43,0x89,0x88,0x16,0x11,0xc4,0x9b,
  0x71,0x20,0x45,0xfb,0x69,0xfa,0x1d,0x43,0x9a,0x48,
  0x7f,0xb6,0x6b,0x90,0xce,0x33,0xd2,0x57,0x94,0x1b,
  0x38,0x1f,0x00,0xe1,0x62,0x8a,0x69,0x78,0x9b,0x2d,
  0x13,0x0c,0x4d,0x59,0x08,0xb6,0x53,0x25,0xfa,0xee,
  0x6d,0x79,0xa4,0xd8,0x09,0x72,0x0b,0xdb,0xc9,0xa0,
  0xf6,0x01,0xbf,0xf7,0xe2,0x21,0x81,0x4b,0x99,0x1c,
  0x79,0xad,0x29,0xc6,0x06,0x31,0x7d,0x59,0x56,0x77,
  0x47,0xc3,0xf0,0xeb,0x9b,0xf9,0x5e,0xa7,0xd4,0x27,
  0x47,0xcb,0x29,0x06,0xc2,0x0b,0x27,0x43,0x57,0xc0,
  0x5f,0xd0,0x6d,0x88,0x96,0x73,0xb9,0x13,0xcd,0x0f,
  0x8a,0x14,0xd2,0x7a,0x00,0x6e,0x73,0x5e,0x15,0x48,
  0x85,0x5c,0x13,0xae,0x62,0xd5,0xba,0x89,0x18,0x11,
  0x49,0x77,0xe1,0xb7,0x00,0x77,0x2a,0xb9,0x8b,0xf7,
  0xc9,0x15,0x0c,0x9b,0x90,0x0c,0x09,0x03,0x6a,0x1e,
  0x4b,0xef,0x7a,0x5e,0x9e,0xdc,0x33,0x58,0x65,0x4b,
  0x69,0xaf,0xc3,0x4a,0x66,0xc3,0xc1,0x90,0x7c,0x4c,
  0x88,0x45,0x62,0x94,0xe1,0xf2,0xa0,0xea,0xf5,0x0a,
  0x09,0x41,0xf9,0x83,0x9f,0x97,0x60,0xd3,0xef,0xc5,
  0x1e,0x58,0x74,0xe1,0xa2,0xda,0xa4,0x64,0x6b,0x21,
  0xb0,0xf3,0x66,0x12,0x87,0x47,0x04}},
{ -1 }};

int main(int ac, char **av)
{
  int i, pass;
  SshUInt32 crc;
  unsigned char *buf, *mask;
  size_t buf_len, mask_len, buf_len_max;
  SshUInt32 mask_crc, buf_crc, old_buf_crc;
  size_t offset;

  for (pass = 0; pass < 1000; pass++)
    {
      for (i = 0; testdata[i].len != -1; i++)
        {
          crc = crc32_buffer(testdata[i].data, testdata[i].len);
          if (crc != testdata[i].crc)
            {
              printf("crc test fails i=%d crc=0x%lx expected 0x%lx\n",
                     i, crc, testdata[i].crc);
              exit(1);
            }
        }
    }

#if 0
  gf_division_test();
  exit(1);
#endif

  buf_len_max = 100000;
  buf_len = buf_len_max / 2;
  buf = ssh_xmalloc(buf_len_max);
  mask_len = 100;
  mask = ssh_xmalloc(mask_len);

  ssh_rand_seed((SshUInt32)ssh_time());

  for (i = 0; i < buf_len; i++)
    buf[i] = (unsigned char) (ssh_rand() % 0xff);

  buf_crc = crc32_buffer(buf, buf_len);

  for (pass = 0; pass < 100; pass++)
    {
      offset = ssh_rand() % (buf_len - mask_len);
      for (i = 0; i < mask_len; i++)
        mask[i] = (unsigned char) (ssh_rand() % 0xff);

      for (i = 0; i < mask_len; i++)
        buf[i + offset] ^= mask[i];

      /* printf("Offset %u\n", offset); */

      old_buf_crc = buf_crc;
      buf_crc = crc32_buffer(buf, buf_len);
      /* printf("The crc of old one: %08x\n", buf_crc); */

      mask_crc = crc32_mask(mask, mask_len, offset, buf_len,
                            old_buf_crc);
      if (mask_crc != buf_crc)
        {
          ssh_fatal("Buffer and mask crc's are different!");
        }

      /* Adding few extra bytes. */
      buf_len += ssh_rand() % buf_len;
      for (i = buf_len_max/2; i < buf_len; i++)
        {
          buf[i] = 0;
        }

      old_buf_crc = buf_crc;
      buf_crc = crc32_buffer(buf, buf_len);

      mask_crc = crc32_extend(old_buf_crc, buf_len - buf_len_max/2);
      if (buf_crc != mask_crc)
        {
          ssh_fatal("Buffer and mask crc's are different! (2)");
        }

      /* Truncate back to correct length. */
      old_buf_crc = buf_crc;
      buf_crc = crc32_buffer(buf, buf_len_max/2);
      mask_crc = crc32_truncate(old_buf_crc, buf_len - buf_len_max/2);
      if (mask_crc != buf_crc)
        {
          ssh_fatal("Buffer and mask crc's are different! (3)");
        }
      buf_len = buf_len_max/2;
    }

  ssh_xfree(buf);
  ssh_xfree(mask);
  ssh_util_uninit();
  return 0;
}
