/*
* Copyright (c) 2013 Qualcomm Atheros, Inc..
* All Rights Reserved.
* Qualcomm Atheros Confidential and Proprietary.
*/
#if UNIFIED_SMARTANTENNA

#include <ieee80211_var.h>
#include <ieee80211_smart_ant_api.h>
#include <if_smart_ant.h>

struct smartantenna_ops *g_sa_ops = NULL;

/* TODO: Optimization can be do for searching operation */
uint32_t rate_table_24[12] = {0x1b,0x1a,0x19,0x18,0x0b,0x0f,0x0a,0x0e,0x09,0x0d, 0x08,0x0c};
uint32_t rate_table_5[12] = {0x43,0x42,0x41,0x40,0x03,0x07,0x02,0x06,0x01,0x05,0x00,0x04};

inline uint32_t ieee80211_smart_ant_convert_rate_5g(uint32_t rate_code)
{
    uint32_t rate_code_converted = 0;
    uint8_t mcs = 0, nss = 0, i=0;
    if (IS_HT_RATE(rate_code)) {
        rate_code &= HT_RATE_MASK;
        nss = (rate_code & HT_NSS_MASK) >> 3;
        mcs = (rate_code & HT_MCS_MASK);
        rate_code_converted = AR600P_ASSEMBLE_HW_RATECODE(mcs, nss, AR600P_PREAMBLE_HT); 
    } else {
        for(i=0; i < MAX_OFDM_CCK_RATES; i++) {
            if (rate_table_24[i] == rate_code)
                break;
        }
        if (i < MAX_OFDM_CCK_RATES)
            rate_code_converted = rate_table_5[i];
    }
    return rate_code_converted;
}

inline uint32_t ieee80211_smart_ant_convert_rate_2g(uint32_t rate_code)
{
    uint32_t rate_code_converted = 0;
    uint8_t preamble = (rate_code & VHT_PREAMBLE_MASK) >> 6;
    uint8_t nss = 0, mcs = 0;
    int i =0 ;
    if ( preamble == 2) {
        nss = (rate_code & VHT_NSS_MASK) >> 4;
        mcs = (rate_code & VHT_MCS_MASK);

        rate_code_converted =  (HT_RATE_FLAG | nss << 3 | mcs);
    } else { 
        for(i=0;i < MAX_OFDM_CCK_RATES;i++) {   
            if (rate_table_5[i] == rate_code)
                break;
        }  
        if (i < MAX_OFDM_CCK_RATES) 
            rate_code_converted = rate_table_24[i];
    }   
    return rate_code_converted;
}

static inline int __ieee80211_smart_ant_get_default_txantenna( struct ieee80211com *ic,  u_int32_t *default_txant)
{
    if (g_sa_ops->sa_get_txdefaultantenna) {
        return (g_sa_ops->sa_get_txdefaultantenna(ic->interface_id, default_txant));
    } else {
        ASSERT(FALSE); /* This condition should not happen */
    }
    return -1;
}

int __ieee80211_smart_ant_get_bcn_txantenna( struct ieee80211com *ic,  u_int32_t *bcn_txant)
{
    if (g_sa_ops->sa_get_bcn_txantenna) {
        return (g_sa_ops->sa_get_bcn_txantenna(ic->interface_id, bcn_txant));
    } else {
        ASSERT(FALSE); /* This condition should not happen */
    }
    return -1;
}

int __ieee80211_smart_ant_get_rxantenna(struct ieee80211com *ic, uint32_t *rx_ant)
{
    if (g_sa_ops->sa_get_rxantenna) {
        return (g_sa_ops->sa_get_rxantenna(ic->interface_id, rx_ant));
    } else {
        ASSERT(FALSE); /* This condition should not happen */
    }
    return -1;
}

static inline int __ieee80211_smart_ant_get_txantenna(struct ieee80211_node *ni, uint32_t *tx_ant_array)
{
    if (g_sa_ops->sa_get_txantenna) {
        return (g_sa_ops->sa_get_txantenna(ni->smart_ant_ccp, tx_ant_array));
    } else {
        ASSERT(FALSE); /* This condition should not happen */
    }
    return -1;
}

static inline int __ieee80211_smart_ant_get_traininfo(struct ieee80211_node *ni, uint32_t *train_rate_array, uint32_t *train_ant_array, uint32_t *num_train_pkts)
{
    if (g_sa_ops->sa_get_traininginfo) {
        return (g_sa_ops->sa_get_traininginfo(ni->smart_ant_ccp, train_rate_array, train_ant_array, num_train_pkts));
    } else {
        ASSERT(FALSE); /* This condition should not happen */
    }
    return -1;
}


int __ieee80211_smart_ant_update_txfeedback(struct ieee80211_node *ni, void *tx_feedback) 
{
    uint32_t rx_antenna, tx_antenna_array[SMART_ANT_MAX_SA_CHAINS];
    uint8_t status = 0;
    struct ieee80211com *ic = ni->ni_ic;
    uint32_t train_rate_array[SMART_ANT_MAX_RATE_SERIES];
    uint32_t train_antenna_array[SMART_ANT_MAX_SA_CHAINS], num_train_pkts; 

    if (ni->smart_ant_ccp == NULL) {
        return -1;
    }
    if (g_sa_ops->sa_update_txfeedback) {
        if (SMART_ANT_STATUS_SUCCESS == g_sa_ops->sa_update_txfeedback(ni->smart_ant_ccp, (struct  sa_tx_feedback *)tx_feedback, &status)) {
            if (status) {
                if (status & SMART_ANT_RX_CONFIG_REQUIRED) {
                    if ( SMART_ANT_STATUS_SUCCESS == __ieee80211_smart_ant_get_rxantenna(ic, &rx_antenna)) {
                        /* set RX antenna */
                        ic->ic_smart_ant_set_rx_antenna(ic, rx_antenna);
                    }     
                } 
                if (status & SMART_ANT_TX_CONFIG_REQUIRED) {
                    if ( SMART_ANT_STATUS_SUCCESS == __ieee80211_smart_ant_get_txantenna(ni, &tx_antenna_array)) {
                        /* set TX antenna array */
                        ic->ic_smart_ant_set_tx_antenna(ni, &tx_antenna_array);
                    }     
                } 
                if (status & SMART_ANT_TRAINING_REQUIRED) {
                    /* TODO: Instead of passing 3 arguments we can pass structure with required fields */
                    /* Get train parameters and program train info to lower modules */
                    if ( SMART_ANT_STATUS_SUCCESS == g_sa_ops->sa_get_traininginfo(ni->smart_ant_ccp, &train_rate_array, &train_antenna_array, &num_train_pkts)) {
                        ic->ic_smart_ant_set_training_info(ni, &train_rate_array, &train_antenna_array, num_train_pkts);
                    }
                }
            }
        }
        return 0;
    } else {
        return -1;
    }

}

int __ieee80211_smart_ant_update_rxfeedback(struct ieee80211_node *ni, void *rx_feedback) 
{
    uint32_t rx_antenna;
    uint8_t status = 0;
    struct ieee80211com *ic = ni->ni_ic;
    uint32_t train_rate_array[SMART_ANT_MAX_RATE_SERIES];
    uint32_t train_antenna_array[SMART_ANT_MAX_SA_CHAINS], num_train_pkts; 

    if (ni->smart_ant_ccp == NULL) {
        return -1;
    }
    if (g_sa_ops->sa_update_rxfeedback) {
        if( SMART_ANT_STATUS_SUCCESS == g_sa_ops->sa_update_rxfeedback(ni->smart_ant_ccp, (struct sa_rx_feedback *)rx_feedback, &status)) {
            if (status) {
                if (status & SMART_ANT_RX_CONFIG_REQUIRED) {
                    if ( SMART_ANT_STATUS_SUCCESS == __ieee80211_smart_ant_get_rxantenna(ic, &rx_antenna)) {
                        /* set RX antenna */
                        ic->ic_smart_ant_set_rx_antenna(ic, rx_antenna);
                    }     
                } 
                if (status & SMART_ANT_TRAINING_REQUIRED) {
                    /* TODO: Instead of passing 3 arguments we can pass structure with required fields */
                    /* Get train parameters and program train info to lower modules */
                    if ( SMART_ANT_STATUS_SUCCESS == g_sa_ops->sa_get_traininginfo(ni->smart_ant_ccp, &train_rate_array, &train_antenna_array, &num_train_pkts)) {
                        ic->ic_smart_ant_set_training_info(ni, &train_rate_array, &train_antenna_array, num_train_pkts);
                    }
                }
            }
            return 0;
        }
    } else {
        return -1;
    }
}

void __ieee80211_smart_ant_node_disconnect(struct ieee80211_node *ni)
{
    struct ieee80211vap *vap = ni->ni_vap;
    /*  Do we need to check removing own vap/node ??? */
    if ((vap->iv_opmode == IEEE80211_M_HOSTAP) && (ni != ni->ni_bss_node)) {
        if (g_sa_ops->sa_node_disconnect) {
            if (ni->smart_ant_ccp != NULL) {
                g_sa_ops->sa_node_disconnect(ni->smart_ant_ccp);
                ni->smart_ant_ccp = NULL;
            }
        }
    } else if ((vap->iv_opmode == IEEE80211_M_STA) && 
               (!IEEE80211_ADDR_EQ(ni->ni_macaddr, vap->iv_myaddr))) {
        if (g_sa_ops->sa_node_disconnect) {
            if (ni->smart_ant_ccp != NULL) {
                g_sa_ops->sa_node_disconnect(ni->smart_ant_ccp);
                ni->smart_ant_ccp = NULL;
            }
        }
    }
}

void __ieee80211_smart_ant_node_connect(struct ieee80211_node *ni, struct sa_rate_cap *rate_cap)
{
    struct sa_node_info node_info;
    struct ieee80211com *ic = ni->ni_ic;
    uint8_t i = 0;
    uint32_t htindex = 0, legacyindex = 0;
    
    OS_MEMZERO(&node_info, sizeof(struct sa_node_info));

    if (ic->ic_smart_ant_prepare_rateset) {
        ic->ic_smart_ant_prepare_rateset(ic, ni);
        /* form rate set to sa module */
        for(i=0;i < ni->rate_info.num_of_rates; i++) {
            if (IS_HT_RATE(ni->rate_info.rates[i].ratecode)) { /* ht rate */
                /* TODO: Optimize this */
                if (ni->ni_chwidth == IEEE80211_CWM_WIDTH20) {
                    node_info.rate_cap.ratecode_20[htindex] = ieee80211_smart_ant_convert_rate_5g(ni->rate_info.rates[i].ratecode);
                    htindex++;    
                    node_info.rate_cap.ratecount[1]++;
                } else {
                    node_info.rate_cap.ratecode_40[htindex] = ieee80211_smart_ant_convert_rate_5g(ni->rate_info.rates[i].ratecode);
                    htindex++;    
                    node_info.rate_cap.ratecount[2]++;
                }
            } else { /* legacy rate */
                node_info.rate_cap.ratecode_legacy[legacyindex] = ieee80211_smart_ant_convert_rate_5g(ni->rate_info.rates[i].ratecode);
                legacyindex++;
                node_info.rate_cap.ratecount[0]++;
            }
        }
    } else {
        /* rates are already set */
        if (rate_cap != NULL) {
            OS_MEMCPY(&node_info.rate_cap, rate_cap, sizeof(struct sa_rate_cap));
            /* cache rate information in node */
            OS_MEMCPY(&ni->rate_cap, rate_cap, sizeof(struct sa_rate_cap));
        } else {
            OS_MEMCPY(&node_info.rate_cap, &ni->rate_cap, sizeof(struct sa_rate_cap));
        }
    }

    IEEE80211_ADDR_COPY(node_info.mac_addr, ni->ni_macaddr);
    node_info.radio_id = ic->interface_id;

    node_info.max_ch_bw = ni->ni_chwidth;
    node_info.chainmask = ((ni->ni_streams) | (ni->ni_rxstreams << 4));
    node_info.opmode = ((ni->ni_flags & IEEE80211_NODE_VHT) ? OPMODE_VHT : (ni->ni_flags & IEEE80211_NODE_HT ? OPMODE_HT :OPMODE_CCK_OFDM));
    node_info.ni_cap = 0; /* TODO: refined cap need to be filled */

    if (ic->radio_id == RADIO_ID_OFF_LOAD)
        node_info.ni_cap |= DYNAMIC_BW_SUPPORTED; /* TODO: refined cap need to be filled */

    node_info.channel_num =  ic->ic_curchan->ic_ieee;
    if (g_sa_ops->sa_node_connect) {
        g_sa_ops->sa_node_connect(&ni->smart_ant_ccp, &node_info);
    }
}

int __ieee80211_smart_ant_init( struct ieee80211com *ic, struct ieee80211vap *vap, int new_init)
{
    struct sa_config sa_init_config;
    u_int32_t rx_antenna;
    u_int32_t antenna_array[SMART_ANT_MAX_RATE_SERIES];
    int i = 0;
    struct ieee80211_node *ni;
    struct ieee80211_node_table  *nt = &ic->ic_sta; 
    osdev_t osdev = ic->ic_osdev;
    char * devname = osdev->netdev->name;

    if (g_sa_ops == NULL) {
        printk("%s: Smart Antenna functions are not registered !!! \n", __func__);
        return -1;
    }

    if (ic->ic_smart_ant_enable == NULL) {
        printk("%s: Smart Antenna is not supported \n", __func__);
        ic->smart_ant_enable = 0;
        return -1;
    }
    /*
     *  handling Multile VAP cases
     */
    if (ic->ic_smart_ant_state & SMART_ANT_STATE_INIT_DONE) {
        return 0;
    }

    if (new_init) {
        while (*devname) {
            devname++;
        }
        --devname;
        ic->interface_id = (uint8_t) (*devname) - '0';
        devname = osdev->netdev->name;
        printk("%s: devname = %s,  interface_id = %d\n", __func__, devname, ic->interface_id);
    }

    if ((vap->iv_opmode == IEEE80211_M_HOSTAP) || (vap->iv_opmode == IEEE80211_M_STA)) {
        /* TODO: What abt repeater case, need to check calling place for repeater*/
        if (g_sa_ops->sa_init) {
            sa_init_config.radio_id = (ic->interface_id << SMART_ANT_INTERFACE_ID_SHIFT) | ic->radio_id;
            sa_init_config.max_fallback_rates = ic->max_fallback_rates; 
            if (vap->iv_opmode == IEEE80211_M_HOSTAP)
                sa_init_config.bss_mode = SMART_ANT_BSS_MODE_AP; 
            else if (vap->iv_opmode == IEEE80211_M_STA)
                sa_init_config.bss_mode = SMART_ANT_BSS_MODE_STA;
            if (new_init & SMART_ANT_STA_NOT_CONNECTED) {
                new_init &= ~SMART_ANT_STA_NOT_CONNECTED;
                /* Set Channel number to 0 ("zero") to request default params from SA module
                 * to help scanning while station is not connected.
                 * Helpful only in IEEE80211_M_STA mode.
                 */
                sa_init_config.channel_num = 0;
            } else {
                sa_init_config.channel_num = ic->ic_curchan->ic_ieee;
            }
            ic->ic_smart_ant_mode = g_sa_ops->sa_init(&sa_init_config, new_init);
            ASSERT(ic->ic_smart_ant_mode < 0);  /* -ve value: init error */

            __ieee80211_smart_ant_get_rxantenna(ic, &rx_antenna);
            /* Enable smart antenna , params@ enable, mode, RX antenna */
            ic->ic_smart_ant_enable(ic, 1, ic->ic_smart_ant_mode, rx_antenna);
            ic->ic_smart_ant_state |= SMART_ANT_STATE_INIT_DONE;
            ic->ic_smart_ant_state &= ~(SMART_ANT_STATE_DEINIT_DONE); /* clear de init */
            ic->smart_ant_enable = 1;

            for (i=0; i<=ic->max_fallback_rates; i++) {
                antenna_array[i] = rx_antenna;
            }

            TAILQ_FOREACH(ni, &nt->nt_node, ni_list) {
                /* set TX antenna to default antennas to BSS node */
                if (IEEE80211_ADDR_EQ(ni->ni_macaddr, vap->iv_myaddr)) {
                    ic->ic_smart_ant_set_tx_antenna(ni, &antenna_array);
                }
            }
        }
    }
    return SMART_ANT_STATUS_SUCCESS; 
}

int __ieee80211_smart_ant_deinit( struct ieee80211com *ic, struct ieee80211vap *vap, int notify)
{
    if (ic->ic_smart_ant_state & SMART_ANT_STATE_DEINIT_DONE ) {
        printk("Deinit is already done !!! \n");
        return 0;
    }
    if (g_sa_ops->sa_deinit) {
        if (notify) {
            g_sa_ops->sa_deinit(ic->interface_id);
        }
        ic->ic_smart_ant_enable(ic, 0, ic->ic_smart_ant_mode, 0);
        ic->smart_ant_enable = 0;
        ic->ic_smart_ant_state |= SMART_ANT_STATE_DEINIT_DONE;
        ic->ic_smart_ant_state &= ~(SMART_ANT_STATE_INIT_DONE); /* clear init */
    }
    return SMART_ANT_STATUS_SUCCESS; 
}

int __ieee80211_smart_ant_channel_change(struct ieee80211com *ic)
{
    struct ieee80211_node_table  *nt = &ic->ic_sta;
    struct ieee80211_node *ni = NULL, *next = NULL;
    rwlock_state_t lock_state;
    struct ieee80211vap *vap;

    vap = TAILQ_FIRST(&ic->ic_vaps);
    if (wlan_scan_in_progress(vap)) {
        return 0;
    }
    if ((ic->ic_smart_ant_state != SMART_ANT_STATE_INIT_DONE)) {
        return -1; 
    }

    /* call smart antenna deint and init with re configuration */
    ieee80211_smart_ant_deinit(ic, vap, SMART_ANT_RECONFIGURE);

    if (ic->ic_opmode == IEEE80211_M_STA) {
        ieee80211_smart_ant_init(ic, vap, SMART_ANT_RECONFIGURE);
        ic->sta_not_connected_cfg = FALSE;
    } else {
        ieee80211_smart_ant_init(ic, vap, SMART_ANT_RECONFIGURE); 
    }

    /* call node_connect to each node in the list */
    OS_RWLOCK_READ_LOCK(&nt->nt_nodelock, &lock_state);
    TAILQ_FOREACH_SAFE(ni, &nt->nt_node, ni_list, next) {
        if (IEEE80211_ADDR_EQ(ni->ni_macaddr, vap->iv_myaddr)) {
            continue;
        }
        if (ieee80211_node_is_authorized(ni)) {
            __ieee80211_smart_ant_node_connect(ni, NULL);
        }
    }
    OS_RWLOCK_READ_UNLOCK(&nt->nt_nodelock, &lock_state);
}

int ieee80211_smart_ant_cwm_action(struct ieee80211com *ic)
{
    struct ieee80211_node_table  *nt = &ic->ic_sta;
    struct ieee80211_node *ni = NULL, *next = NULL;
    rwlock_state_t lock_state;
    struct ieee80211vap *vap;
    /* get current cwm mode */
    enum ieee80211_cwm_width ic_cw_width = ic->ic_cwm_get_width(ic);
    vap = TAILQ_FIRST(&ic->ic_vaps);

    if (!ic->smart_ant_enable) {
        return -1;
    }

    /* call node_connect to each node in the list */
    OS_RWLOCK_READ_LOCK(&nt->nt_nodelock, &lock_state);
    TAILQ_FOREACH_SAFE(ni, &nt->nt_node, ni_list, next) {
        if (IEEE80211_ADDR_EQ(ni->ni_macaddr, vap->iv_myaddr)) {
            continue;
        }
        if ( (ni->ni_flags & IEEE80211_NODE_HT ) && (ni->ni_chwidth != ic_cw_width)) {
            if (ic_cw_width == IEEE80211_CWM_WIDTH40) {
                if (ni->ni_htcap & IEEE80211_HTCAP_C_CHWIDTH40) {
                    ni->ni_chwidth = ic_cw_width;
                    ieee80211_smart_ant_node_connect(ni, NULL);
                }
            }

            if (ic_cw_width == IEEE80211_CWM_WIDTH20) {
                ni->ni_chwidth = ic_cw_width;
                ieee80211_smart_ant_node_connect(ni, NULL);
            }
        }
    }
    OS_RWLOCK_READ_UNLOCK(&nt->nt_nodelock, &lock_state);

   return 0;
}


/* TODO: Ideally 3rd party module should export their functions to qca module
 *       need to re look into this later
 */
int register_smart_ant_ops(struct smartantenna_ops *sa_ops)
{
    g_sa_ops = sa_ops;
    return SMART_ANT_STATUS_SUCCESS; 
}

EXPORT_SYMBOL(register_smart_ant_ops);

int deregister_smart_ant_ops(char *dev_name)
{
    struct ath_softc_net80211 *scn = NULL;
    struct ieee80211com *ic = NULL;
    struct net_device *dev = NULL;
    struct ieee80211vap *vap = NULL;

    dev = dev_get_by_name(&init_net, dev_name);
    if (!dev) {
        printk("%s: device %s not Found! \n", __func__, dev_name);
        return 0;
    }
    scn = ath_netdev_priv(dev);
    ic = &scn->sc_ic;
    vap = TAILQ_FIRST(&ic->ic_vaps);
    ieee80211_smart_ant_deinit(ic, vap, SMART_ANT_NEW_CONFIGURATION);
    dev_put(dev);
    return SMART_ANT_STATUS_SUCCESS;
}
EXPORT_SYMBOL(deregister_smart_ant_ops);

#endif

