/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */


/*****************************************************************************
*
* Filename:
* ---------
*   upmu_hw.h
*
* Project:
* --------
*   Android
*
* Description:
* ------------
*   Unified PMU HW register definition
*
* Author:
* -------
*
****************************************************************************/

#ifndef _MT6575_PMIC_UPMU_HW_H_
#define _MT6575_PMIC_UPMU_HW_H_

//==============================================================================
// Common Offset
//==============================================================================
//STATUS
#define STATUS_CON0_OFFSET          0x00
#define STATUS_CON1_OFFSET          0x01
#define STATUS_CON2_OFFSET          0x02
#define STATUS_CON3_OFFSET          0x03

#define STATUS_PG_CON0_OFFSET       0x00

#define STATUS_CHR_CON0_OFFSET      0x00

#define STATUS_OC_CON0_OFFSET       0x00
#define STATUS_OC_CON1_OFFSET       0x01
#define STATUS_OC_CON2_OFFSET       0x02
#define STATUS_OC_CON3_OFFSET       0x03

//STARTUP
#define STARTUP_CON0_OFFSET         0x00
#define STARTUP_CON1_OFFSET         0x01
#define STARTUP_CON2_OFFSET         0x02
#define STARTUP_CON3_OFFSET         0x03
#define STARTUP_CON4_OFFSET         0x04
#define STARTUP_CON5_OFFSET         0x05
#define STARTUP_CON6_OFFSET         0x06
#define STARTUP_CON7_OFFSET         0x07

//INTTERRUPT
#define INTTERRUPT_CON0_OFFSET      0x00
#define INTTERRUPT_CON1_OFFSET      0x01
#define INTTERRUPT_CON2_OFFSET      0x02
#define INTTERRUPT_CON3_OFFSET      0x03
#define INTTERRUPT_CON4_OFFSET      0x04
#define INTTERRUPT_CON5_OFFSET      0x05

//CHARGER
#define CHR_CON0_OFFSET          0x00
#define CHR_CON1_OFFSET          0x01
#define CHR_CON2_OFFSET          0x02
#define CHR_CON3_OFFSET          0x03
#define CHR_CON4_OFFSET          0x04
#define CHR_CON5_OFFSET          0x05
#define CHR_CON6_OFFSET          0x06
#define CHR_CON7_OFFSET          0x07
#define CHR_CON8_OFFSET          0x08
#define CHR_CON9_OFFSET          0x09
#define CHR_CONA_OFFSET          0x0A
#define CHR_CONB_OFFSET          0x0B
#define CHR_CONC_OFFSET          0x0C
#define CHR_COND_OFFSET          0x0D
#define CHR_CONE_OFFSET          0x0E
#define CHR_CONF_OFFSET          0x0F
#define CHR_CON11_OFFSET         0x10
#define CHR_CON12_OFFSET         0x11
#define CHR_CON13_OFFSET         0x12
#define CHR_CON14_OFFSET         0x13
#define CHR_CON15_OFFSET         0x14
#define CHR_CON16_OFFSET         0x15
#define CHR_CON17_OFFSET         0x16
#define CHR_CON18_OFFSET         0x17
#define CHR_CON19_OFFSET         0x18
#define CHR_CON1A_OFFSET         0x19
#define CHR_CON1B_OFFSET         0x1A
#define CHR_CON1C_OFFSET         0x1B
#define CHR_CON1D_OFFSET         0x1C

//BUCK
#define BUCK_CON0_OFFSET          0x00
#define BUCK_CON1_OFFSET          0x01
#define BUCK_CON2_OFFSET          0x02
#define BUCK_CON3_OFFSET          0x03
#define BUCK_CON4_OFFSET          0x04
#define BUCK_CON5_OFFSET          0x05
#define BUCK_CON6_OFFSET          0x06
#define BUCK_CON7_OFFSET          0x07
#define BUCK_CON8_OFFSET          0x08
#define BUCK_CON9_OFFSET          0x09
#define BUCK_CONA_OFFSET          0x0A
#define BUCK_CONB_OFFSET          0x0B
#define BUCK_CONC_OFFSET          0x0C
#define BUCK_COND_OFFSET          0x0D
#define BUCK_CONE_OFFSET          0x0E
#define BUCK_CONF_OFFSET          0x0F

//LDO
#define LDO_CON0_OFFSET          0x00
#define LDO_CON1_OFFSET          0x01
#define LDO_CON2_OFFSET          0x02
#define LDO_CON3_OFFSET          0x03
#define LDO_CON4_OFFSET          0x04
#define LDO_CON5_OFFSET          0x05
#define LDO_CON6_OFFSET          0x06
#define LDO_CON7_OFFSET          0x07

//BUCK CALIBRATION
#define BUCK_K_CON0_OFFSET       0x00
#define BUCK_K_CON1_OFFSET       0x01
#define BUCK_K_CON2_OFFSET       0x02

//AUXADC
#define AUXADC_CON0_OFFSET          0x00
#define AUXADC_CON1_OFFSET          0x01
#define AUXADC_CON2_OFFSET          0x02
#define AUXADC_CON3_OFFSET          0x03
#define AUXADC_CON4_OFFSET          0x04
#define AUXADC_CON5_OFFSET          0x05
#define AUXADC_CON6_OFFSET          0x06
#define AUXADC_CON7_OFFSET          0x07
#define AUXADC_CON8_OFFSET          0x08
#define AUXADC_CON9_OFFSET          0x09
#define AUXADC_CON10_OFFSET         0x0A
#define AUXADC_CON11_OFFSET         0x0B
#define AUXADC_CON12_OFFSET         0x0C
#define AUXADC_CON13_OFFSET         0x0D
#define AUXADC_CON14_OFFSET         0x0E
#define AUXADC_CON15_OFFSET         0x0F
#define AUXADC_CON16_OFFSET         0x10
#define AUXADC_CON17_OFFSET         0x11
#define AUXADC_CON18_OFFSET         0x12
#define AUXADC_CON19_OFFSET         0x13
#define AUXADC_CON20_OFFSET         0x14
#define AUXADC_CON21_OFFSET         0x15
#define AUXADC_CON22_OFFSET         0x16
#define AUXADC_CON23_OFFSET         0x17
#define AUXADC_CON24_OFFSET         0x18
#define AUXADC_CON25_OFFSET         0x19
#define AUXADC_CON26_OFFSET         0x1A
#define AUXADC_CON27_OFFSET         0x1B
#define AUXADC_CON28_OFFSET         0x1C
#define AUXADC_CON29_OFFSET         0x1D

//TESTMODE
#define TESTMODE_CON0_OFFSET        0x00
#define TESTMODE_CON1_OFFSET        0x01
#define TESTMODE_CON2_OFFSET        0x02
#define TESTMODE_CON3_OFFSET        0x03
#define TESTMODE_CON4_OFFSET        0x04
#define TESTMODE_CON5_OFFSET        0x05
#define TESTMODE_CON6_OFFSET        0x06
#define TESTMODE_CON7_OFFSET        0x07
#define TESTMODE_CON8_OFFSET        0x08
#define TESTMODE_CON9_OFFSET        0x09
#define TESTMODE_CON10_OFFSET       0x0A
#define TESTMODE_CON11_OFFSET       0x0B
#define TESTMODE_CON12_OFFSET       0x0C
#define TESTMODE_CON13_OFFSET       0x0D

//TOP2
#define TOP2_CON0_OFFSET          	0x00
#define TOP2_CON1_OFFSET          	0x01
#define TOP2_CON2_OFFSET          	0x02
#define TOP2_CON3_OFFSET          	0x03
#define TOP2_CON4_OFFSET          	0x04

//FLASH
#define FLASH_CON0_OFFSET          	0x00
#define FLASH_CON1_OFFSET          	0x01
#define FLASH_CON2_OFFSET          	0x02
#define FLASH_CON3_OFFSET          	0x03
#define FLASH_CON4_OFFSET          	0x04

//KPLED
#define KPLED_CON0_OFFSET          	0x00
#define KPLED_CON1_OFFSET          	0x01
#define KPLED_CON2_OFFSET          	0x02
#define KPLED_CON3_OFFSET          	0x03
#define KPLED_CON4_OFFSET          	0x04

//ISINKS
#define ISINKS_CON0_OFFSET          0x00
#define ISINKS_CON1_OFFSET          0x01
#define ISINKS_CON2_OFFSET          0x02
#define ISINKS_CON3_OFFSET          0x03
#define ISINKS_CON4_OFFSET          0x04
#define ISINKS_CON5_OFFSET          0x05
#define ISINKS_CON6_OFFSET          0x06
#define ISINKS_CON7_OFFSET          0x07
#define ISINKS_CON8_OFFSET          0x08
#define ISINKS_CON9_OFFSET          0x09
#define ISINKS_CON10_OFFSET         0x0A
#define ISINKS_CON11_OFFSET         0x0B
#define ISINKS_CON12_OFFSET         0x0C
#define ISINKS_CON13_OFFSET         0x0D
#define ISINKS_CON14_OFFSET         0x0E
#define ISINKS_CON15_OFFSET         0x0F

//BOOST
#define BOOST_CON0_OFFSET          	0x00
#define BOOST_CON1_OFFSET          	0x01
#define BOOST_CON2_OFFSET          	0x02
#define BOOST_CON3_OFFSET          	0x03
#define BOOST_CON4_OFFSET          	0x04

//SPK
#define SPK_CON0_OFFSET          0x00
#define SPK_CON1_OFFSET          0x01
#define SPK_CON2_OFFSET          0x02
#define SPK_CON3_OFFSET          0x03
#define SPK_CON4_OFFSET          0x04
#define SPK_CON5_OFFSET          0x05
#define SPK_CON6_OFFSET          0x06
#define SPK_CON7_OFFSET          0x07
#define SPK_CON8_OFFSET          0x08
#define SPK_CON9_OFFSET          0x09
#define SPK_CON10_OFFSET         0x0A
#define SPK_CON11_OFFSET         0x0B
#define SPK_CON12_OFFSET         0x0C
#define SPK_CON13_OFFSET         0x0D
#define SPK_CON14_OFFSET         0x0E
#define SPK_CON15_OFFSET         0x0F
#define SPK_CON16_OFFSET         0x10
#define SPK_CON17_OFFSET         0x11
#define SPK_CON18_OFFSET         0x12
#define SPK_CON19_OFFSET         0x13

//ASW
#define ASW_CON0_OFFSET          0x00

//FGPLL
#define FGPLL_CON0_OFFSET          0x00
#define FGPLL_CON1_OFFSET          0x01
#define FGPLL_CON2_OFFSET          0x02
#define FGPLL_CON3_OFFSET          0x03
#define FGPLL_CON4_OFFSET          0x04
#define FGPLL_CON5_OFFSET          0x05
#define FGPLL_CON6_OFFSET          0x06

//FGADC
#define FGADC_CON0_OFFSET          0x00
#define FGADC_CON1_OFFSET          0x01
#define FGADC_CON2_OFFSET          0x02
#define FGADC_CON3_OFFSET          0x03
#define FGADC_CON4_OFFSET          0x04
#define FGADC_CON5_OFFSET          0x05
#define FGADC_CON6_OFFSET          0x06
#define FGADC_CON7_OFFSET          0x07
#define FGADC_CON8_OFFSET          0x08
#define FGADC_CON9_OFFSET          0x09
#define FGADC_CON10_OFFSET         0x0A
#define FGADC_CON11_OFFSET         0x0B
#define FGADC_CON12_OFFSET         0x0C
#define FGADC_CON13_OFFSET         0x0D
#define FGADC_CON14_OFFSET         0x0E
#define FGADC_CON15_OFFSET         0x0F
#define FGADC_CON16_OFFSET         0x10
#define FGADC_CON17_OFFSET         0x11
#define FGADC_CON18_OFFSET         0x12
#define FGADC_CON19_OFFSET         0x13
#define FGADC_CON20_OFFSET         0x14
#define FGADC_CON21_OFFSET         0x15
#define FGADC_CON22_OFFSET         0x16
#define FGADC_CON23_OFFSET         0x17
#define FGADC_CON24_OFFSET         0x18
#define FGADC_CON25_OFFSET         0x19
#define FGADC_CON26_OFFSET         0x1A
#define FGADC_CON27_OFFSET         0x1B
#define FGADC_CON28_OFFSET         0x1C
#define FGADC_CON29_OFFSET         0x1D
#define FGADC_CON30_OFFSET         0x1E

//OTPC
#define OTPC_CON0_OFFSET          0x00
#define OTPC_CON1_OFFSET          0x01
#define OTPC_CON2_OFFSET          0x02
#define OTPC_CON3_OFFSET          0x03
#define OTPC_CON4_OFFSET          0x04
#define OTPC_CON5_OFFSET          0x05
#define OTPC_CON6_OFFSET          0x06
#define OTPC_CON7_OFFSET          0x07
#define OTPC_CON8_OFFSET          0x08
#define OTPC_CON9_OFFSET          0x09
#define OTPC_CON10_OFFSET         0x0A
#define OTPC_CON11_OFFSET         0x0B
#define OTPC_CON12_OFFSET         0x0C
#define OTPC_CON13_OFFSET         0x0D
#define OTPC_CON14_OFFSET         0x0E
#define OTPC_CON15_OFFSET         0x0F
#define OTPC_CON16_OFFSET         0x10
#define OTPC_CON17_OFFSET         0x11
#define OTPC_CON18_OFFSET         0x12
#define OTPC_CON19_OFFSET         0x13
#define OTPC_CON20_OFFSET         0x14
#define OTPC_CON21_OFFSET         0x15

//I2C
#define I2C_CON0_OFFSET          0x00
#define I2C_CON1_OFFSET          0x01

//==============================================================================
// Common HW mask and shift
//==============================================================================
//BUCK - CON0
#define BANK_0_RG_BUCK_CSL_MASK 0x3
#define BANK_0_RG_BUCK_CSL_SHIFT 0x6

#define BANK_0_RG_BUCK_CSR_MASK 0x3
#define BANK_0_RG_BUCK_CSR_SHIFT 0x4

#define BANK_0_RG_BUCK_CC_MASK 0x3
#define BANK_0_RG_BUCK_CC_SHIFT 0x2

#define BANK_0_RG_BUCK_RZSEL_MASK 0x3
#define BANK_0_RG_BUCK_RZSEL_SHIFT 0x0

//BUCK - CON1
#define BANK_0_RG_BUCK_SLP_MASK 0x3
#define BANK_0_RG_BUCK_SLP_SHIFT 0x6

#define BANK_0_RG_BUCK_ZX_OS_MASK 0x3
#define BANK_0_RG_BUCK_ZX_OS_SHIFT 0x4

#define BANK_0_RG_BUCK_SLEW_MASK 0x3
#define BANK_0_RG_BUCK_SLEW_SHIFT 0x2

#define BANK_0_RG_BUCK_SLEW_NMOS_MASK 0x3
#define BANK_0_RG_BUCK_SLEW_NMOS_SHIFT 0x0

//BUCK - CON2
#define BANK_0_RG_BUCK_AVP_OS_MASK 0x7
#define BANK_0_RG_BUCK_AVP_OS_SHIFT 0x4

#define BANK_0_RG_BUCK_AVP_EN_MASK 0x1
#define BANK_0_RG_BUCK_AVP_EN_SHIFT 0x1

#define BANK_0_RG_BUCK_MODESET_MASK 0x1
#define BANK_0_RG_BUCK_MODESET_SHIFT 0x0

//BUCK - CON3
#define BANK_0_QI_BUCK_EN_MASK 0x1
#define BANK_0_QI_BUCK_EN_SHIFT 0x7

#define BANK_0_RG_BUCK_ON_CTRL_MASK 0x1
#define BANK_0_RG_BUCK_ON_CTRL_SHIFT 0x1

#define BANK_0_RG_BUCK_EN_MASK 0x1
#define BANK_0_RG_BUCK_EN_SHIFT 0x0

//BUCK - CON4
#define BANK_0_RG_BUCK_STBTD_MASK 0x3
#define BANK_0_RG_BUCK_STBTD_SHIFT 0x6

#define BANK_0_RG_BUCK_BURST_MASK 0x3
#define BANK_0_RG_BUCK_BURST_SHIFT 0x4

#define BANK_0_RG_BUCK_VFBADJ_MASK 0x7
#define BANK_0_RG_BUCK_VFBADJ_SHIFT 0x1

#define BANK_0_RG_BUCK_OCFB_EN_MASK 0x1
#define BANK_0_RG_BUCK_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_BUCK_NDIS_EN_MASK 0x1
#define BANK_0_RG_BUCK_NDIS_EN_SHIFT 0x0

//BUCK - CON5
#define BANK_0_RG_BUCK_VOSEL_MASK 0x1F
#define BANK_0_RG_BUCK_VOSEL_SHIFT 0x0

//BUCK - CON6
#define BANK_0_BUCK_VOSEL_SRCLKEN0_MASK 0x1F
#define BANK_0_BUCK_VOSEL_SRCLKEN0_SHIFT 0x0

#define BANK_0_RG_BUCK_VOSEL_CON1_MASK 0x1F
#define BANK_0_RG_BUCK_VOSEL_CON1_SHIFT 0x0

#define BANK_0_RG_PASEL_SET0_MASK 0x1F
#define BANK_0_RG_PASEL_SET0_SHIFT 0x0

//BUCK - CON7
#define BANK_0_BUCK_VOSEL_SRCLKEN1_MASK 0x1F
#define BANK_0_BUCK_VOSEL_SRCLKEN1_SHIFT 0x0

#define BANK_0_RO_QI_BUCK_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_BUCK_OC_STATUS_SHIFT 0x0

#define BANK_0_RG_PASEL_SET1_MASK 0x1F
#define BANK_0_RG_PASEL_SET1_SHIFT 0x0

//BUCK - CON8
#define BANK_0_BUCK_VOSEL_DVS00_MASK 0x1F
#define BANK_0_BUCK_VOSEL_DVS00_SHIFT 0x0

#define BANK_0_RG_PASEL_SET2_MASK 0x1F
#define BANK_0_RG_PASEL_SET2_SHIFT 0x0

//BUCK - CON9
#define BANK_0_BUCK_VOSEL_DVS01_MASK 0x1F
#define BANK_0_BUCK_VOSEL_DVS01_SHIFT 0x0

#define BANK_0_RG_PASEL_SET3_MASK 0x1F
#define BANK_0_RG_PASEL_SET3_SHIFT 0x0

//BUCK - CONA
#define BANK_0_BUCK_VOSEL_DVS10_MASK 0x1F
#define BANK_0_BUCK_VOSEL_DVS10_SHIFT 0x0

#define BANK_0_RG_PASEL_SET4_MASK 0x1F
#define BANK_0_RG_PASEL_SET4_SHIFT 0x0

//BUCK - CONB
#define BANK_0_BUCK_VOSEL_DVS11_MASK 0x1F
#define BANK_0_BUCK_VOSEL_DVS11_SHIFT 0x0

#define BANK_0_RG_PASEL_SET5_MASK 0x1F
#define BANK_0_RG_PASEL_SET5_SHIFT 0x0

//BUCK - CONC
#define BANK_0_RG_BUCK_VOSEL_SFCHG_EN_MASK 0x1
#define BANK_0_RG_BUCK_VOSEL_SFCHG_EN_SHIFT 0x2

#define BANK_0_RG_BUCK_CTRL_MASK 0x3
#define BANK_0_RG_BUCK_CTRL_SHIFT 0x0

#define BANK_0_RG_PASEL_SET6_MASK 0x1F
#define BANK_0_RG_PASEL_SET6_SHIFT 0x0

//BUCK - COND
#define BANK_0_RG_BUCK_SMPS_TESTMODE_MASK 0x3F
#define BANK_0_RG_BUCK_SMPS_TESTMODE_SHIFT 0x0

#define BANK_0_RG_PASEL_SET7_MASK 0x1F
#define BANK_0_RG_PASEL_SET7_SHIFT 0x0

//BUCK - CONE

//BUCK - CONF
#define BANK_0_QI_BUCK_VOSEL_MASK 0x1F
#define BANK_0_QI_BUCK_VOSEL_SHIFT 0x0

//LDO - CON0
#define BANK_0_RG_LDO_CAL_MASK 0x1F // only VM12_INT need 0x1F, others is 0xF
#define BANK_0_RG_LDO_CAL_SHIFT 0x0

//LDO - CON1
#define BANK_0_QI_LDO_EN_MASK 0x1
#define BANK_0_QI_LDO_EN_SHIFT 0x7

#define BANK_0_RG_LDO_VOSEL_MASK 0x7
#define BANK_0_RG_LDO_VOSEL_SHIFT 0x4

#define BANK_0_LDO_ON_CTRL_MASK 0x1
#define BANK_0_LDO_ON_CTRL_SHIFT 0x1

#define BANK_0_LDO_EN_MASK 0x1
#define BANK_0_LDO_EN_SHIFT 0x0

//LDO - CON2
#define BANK_0_RG_LDO_STBTD_MASK 0x3
#define BANK_0_RG_LDO_STBTD_SHIFT 0x4

#define BANK_0_RG_LDO_THR_SHDN_EN_MASK 0x1
#define BANK_0_RG_LDO_THR_SHDN_EN_SHIFT 0x3

#define BANK_0_RG_LDO_STB_SEL_MASK 0x1
#define BANK_0_RG_LDO_STB_SEL_SHIFT 0x2

#define BANK_0_RG_LDO_OCFB_EN_MASK 0x1
#define BANK_0_RG_LDO_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_LDO_NDIS_EN_MASK 0x1
#define BANK_0_RG_LDO_NDIS_EN_SHIFT 0x0

//LDO - CON3
#define BANK_0_QI_LDO_MODE_MASK 0x1
#define BANK_0_QI_LDO_MODE_SHIFT 0x7

#define BANK_0_LDO_LP_SET_MASK 0x1
#define BANK_0_LDO_LP_SET_SHIFT 0x1

#define BANK_0_LDO_LP_SEL_MASK 0x1
#define BANK_0_LDO_LP_SEL_SHIFT 0x0

//==============================================================================
// PMIC6329 BANK 0
//==============================================================================
#define BANK_0_CID0_MASK 0xFF
#define BANK_0_CID0_SHIFT 0x0

#define BANK_0_CID1_MASK 0xFF
#define BANK_0_CID1_SHIFT 0x0

#define BANK_0_VCORE_STATUS_MASK 0x1
#define BANK_0_VCORE_STATUS_SHIFT 0x7

#define BANK_0_VPROC_STATUS_MASK 0x1
#define BANK_0_VPROC_STATUS_SHIFT 0x6

#define BANK_0_VIO18_STATUS_MASK 0x1
#define BANK_0_VIO18_STATUS_SHIFT 0x5

#define BANK_0_VRF18_STATUS_MASK 0x1
#define BANK_0_VRF18_STATUS_SHIFT 0x4

#define BANK_0_VPA_STATUS_MASK 0x1
#define BANK_0_VPA_STATUS_SHIFT 0x3

#define BANK_0_VRF_STATUS_MASK 0x1
#define BANK_0_VRF_STATUS_SHIFT 0x2

#define BANK_0_VTCXO_STATUS_MASK 0x1
#define BANK_0_VTCXO_STATUS_SHIFT 0x1

#define BANK_0_VA1_STATUS_MASK 0x1
#define BANK_0_VA1_STATUS_SHIFT 0x0

#define BANK_0_VCAMA_STATUS_MASK 0x1
#define BANK_0_VCAMA_STATUS_SHIFT 0x7

#define BANK_0_VM12_1_STATUS_MASK 0x1
#define BANK_0_VM12_1_STATUS_SHIFT 0x6

#define BANK_0_VM12_INT_STATUS_MASK 0x1
#define BANK_0_VM12_INT_STATUS_SHIFT 0x5

#define BANK_0_VIO28_STATUS_MASK 0x1
#define BANK_0_VIO28_STATUS_SHIFT 0x4

#define BANK_0_VSIM1_STATUS_MASK 0x1
#define BANK_0_VSIM1_STATUS_SHIFT 0x3

#define BANK_0_VSIM2_STATUS_MASK 0x1
#define BANK_0_VSIM2_STATUS_SHIFT 0x2

#define BANK_0_VUSB_STATUS_MASK 0x1
#define BANK_0_VUSB_STATUS_SHIFT 0x1

#define BANK_0_VCAMD_STATUS_MASK 0x1
#define BANK_0_VCAMD_STATUS_SHIFT 0x0

#define BANK_0_VCAM_IO_STATUS_MASK 0x1
#define BANK_0_VCAM_IO_STATUS_SHIFT 0x7

#define BANK_0_VCAM_AF_STATUS_MASK 0x1
#define BANK_0_VCAM_AF_STATUS_SHIFT 0x6

#define BANK_0_VMC_STATUS_MASK 0x1
#define BANK_0_VMC_STATUS_SHIFT 0x5

#define BANK_0_VMCH_STATUS_MASK 0x1
#define BANK_0_VMCH_STATUS_SHIFT 0x4

#define BANK_0_VGP_STATUS_MASK 0x1
#define BANK_0_VGP_STATUS_SHIFT 0x3

#define BANK_0_VGP2_STATUS_MASK 0x1
#define BANK_0_VGP2_STATUS_SHIFT 0x2

#define BANK_0_VM12_2_STATUS_MASK 0x1
#define BANK_0_VM12_2_STATUS_SHIFT 0x1

#define BANK_0_VIBR_STATUS_MASK 0x1
#define BANK_0_VIBR_STATUS_SHIFT 0x0

#define BANK_0_VA2_STATUS_MASK 0x1
#define BANK_0_VA2_STATUS_SHIFT 0x5

#define BANK_0_VRTC_STATUS_MASK 0x1
#define BANK_0_VRTC_STATUS_SHIFT 0x4

#define BANK_0_VTCXO_PG_STATUS_MASK 0x1
#define BANK_0_VTCXO_PG_STATUS_SHIFT 0x0

#define BANK_0_VCORE_PG_STATUS_MASK 0x1
#define BANK_0_VCORE_PG_STATUS_SHIFT 0x7

#define BANK_0_VPROC_PG_STATUS_MASK 0x1
#define BANK_0_VPROC_PG_STATUS_SHIFT 0x6

#define BANK_0_VIO18_PG_STATUS_MASK 0x1
#define BANK_0_VIO18_PG_STATUS_SHIFT 0x5

#define BANK_0_VIO28_PG_STATUS_MASK 0x1
#define BANK_0_VIO28_PG_STATUS_SHIFT 0x4

#define BANK_0_VA1_PG_STATUS_MASK 0x1
#define BANK_0_VA1_PG_STATUS_SHIFT 0x3

#define BANK_0_VM12_1_PG_STATUS_MASK 0x1
#define BANK_0_VM12_1_PG_STATUS_SHIFT 0x2

#define BANK_0_VM12_2_PG_STATUS_MASK 0x1
#define BANK_0_VM12_2_PG_STATUS_SHIFT 0x1

#define BANK_0_VM12_INT_PG_STATUS_MASK 0x1
#define BANK_0_VM12_INT_PG_STATUS_SHIFT 0x0

#define BANK_0_CV_MASK 0x1
#define BANK_0_CV_SHIFT 0x7

#define BANK_0_RO_BATON_UNDET_MASK 0x1
#define BANK_0_RO_BATON_UNDET_SHIFT 0x6

#define BANK_0_PCHR_CHRDET_MASK 0x1
#define BANK_0_PCHR_CHRDET_SHIFT 0x5

#define BANK_0_VBAT_OV_MASK 0x1
#define BANK_0_VBAT_OV_SHIFT 0x4

#define BANK_0_PWRKEY_DEB_MASK 0x1
#define BANK_0_PWRKEY_DEB_SHIFT 0x3

#define BANK_0_USBDL_MASK 0x1
#define BANK_0_USBDL_SHIFT 0x2

#define BANK_0_TEST_MODE_POR_MASK 0x1
#define BANK_0_TEST_MODE_POR_SHIFT 0x0

#define BANK_0_VCAMA_OC_STATUS_MASK 0x1
#define BANK_0_VCAMA_OC_STATUS_SHIFT 0x7

#define BANK_0_VM12_1_OC_STATUS_MASK 0x1
#define BANK_0_VM12_1_OC_STATUS_SHIFT 0x6

#define BANK_0_VM12_OC_STATUS_MASK 0x1
#define BANK_0_VM12_OC_STATUS_SHIFT 0x5

#define BANK_0_VIO28_OC_STATUS_MASK 0x1
#define BANK_0_VIO28_OC_STATUS_SHIFT 0x4

#define BANK_0_VSIM1_OC_STATUS_MASK 0x1
#define BANK_0_VSIM1_OC_STATUS_SHIFT 0x3

#define BANK_0_VSIM2_OC_STATUS_MASK 0x1
#define BANK_0_VSIM2_OC_STATUS_SHIFT 0x2

#define BANK_0_VUSB_OC_STATUS_MASK 0x1
#define BANK_0_VUSB_OC_STATUS_SHIFT 0x1

#define BANK_0_VCAMD_OC_STATUS_MASK 0x1
#define BANK_0_VCAMD_OC_STATUS_SHIFT 0x0

#define BANK_0_VCAM_IO_OC_STATUS_MASK 0x1
#define BANK_0_VCAM_IO_OC_STATUS_SHIFT 0x7

#define BANK_0_VCAM_AF_OC_STATUS_MASK 0x1
#define BANK_0_VCAM_AF_OC_STATUS_SHIFT 0x6

#define BANK_0_VMC_OC_STATUS_MASK 0x1
#define BANK_0_VMC_OC_STATUS_SHIFT 0x5

#define BANK_0_VMCH_OC_STATUS_MASK 0x1
#define BANK_0_VMCH_OC_STATUS_SHIFT 0x4

#define BANK_0_VGP_OC_STATUS_MASK 0x1
#define BANK_0_VGP_OC_STATUS_SHIFT 0x3

#define BANK_0_VGP2_OC_STATUS_MASK 0x1
#define BANK_0_VGP2_OC_STATUS_SHIFT 0x2

#define BANK_0_VM12_2_OC_STATUS_MASK 0x1
#define BANK_0_VM12_2_OC_STATUS_SHIFT 0x1

#define BANK_0_VIBR_OC_STATUS_MASK 0x1
#define BANK_0_VIBR_OC_STATUS_SHIFT 0x0

#define BANK_0_HOMEKEY_DEB_MASK 0x1
#define BANK_0_HOMEKEY_DEB_SHIFT 0x6

#define BANK_0_BOOST_OC_STATUS_MASK 0x1
#define BANK_0_BOOST_OC_STATUS_SHIFT 0x5

#define BANK_0_VA2_OC_STATUS_MASK 0x1
#define BANK_0_VA2_OC_STATUS_SHIFT 0x4

#define BANK_0_NI_SPK_OC_DET_D_R_MASK 0x1
#define BANK_0_NI_SPK_OC_DET_D_R_SHIFT 0x3

#define BANK_0_NI_SPK_OC_DET_D_L_MASK 0x1
#define BANK_0_NI_SPK_OC_DET_D_L_SHIFT 0x2

#define BANK_0_NI_SPK_OC_DET_AB_R_MASK 0x1
#define BANK_0_NI_SPK_OC_DET_AB_R_SHIFT 0x1

#define BANK_0_NI_SPK_OC_DET_AB_L_MASK 0x1
#define BANK_0_NI_SPK_OC_DET_AB_L_SHIFT 0x0

#define BANK_0_VCORE_OC_STATUS_MASK 0x1
#define BANK_0_VCORE_OC_STATUS_SHIFT 0x7

#define BANK_0_VPROC_OC_STATUS_MASK 0x1
#define BANK_0_VPROC_OC_STATUS_SHIFT 0x6

#define BANK_0_VIO18_OC_STATUS_MASK 0x1
#define BANK_0_VIO18_OC_STATUS_SHIFT 0x5

#define BANK_0_VRF18_OC_STATUS_MASK 0x1
#define BANK_0_VRF18_OC_STATUS_SHIFT 0x4

#define BANK_0_VPA_OC_STATUS_MASK 0x1
#define BANK_0_VPA_OC_STATUS_SHIFT 0x3

#define BANK_0_VRF_OC_STATUS_MASK 0x1
#define BANK_0_VRF_OC_STATUS_SHIFT 0x2

#define BANK_0_VTCXO_OC_STATUS_MASK 0x1
#define BANK_0_VTCXO_OC_STATUS_SHIFT 0x1

#define BANK_0_VA1_OC_STATUS_MASK 0x1
#define BANK_0_VA1_OC_STATUS_SHIFT 0x0

#define BANK_0_RG_THRDET_SEL_MASK 0x1
#define BANK_0_RG_THRDET_SEL_SHIFT 0x6

#define BANK_0_RG_THR_HWPDN_EN_MASK 0x1
#define BANK_0_RG_THR_HWPDN_EN_SHIFT 0x5

#define BANK_0_RG_STRUP_THR_SEL_MASK 0x3
#define BANK_0_RG_STRUP_THR_SEL_SHIFT 0x3

#define BANK_0_RG_THR_TMODE_MASK 0x1
#define BANK_0_RG_THR_TMODE_SHIFT 0x1

#define BANK_0_RG_FORCE_NON_THERMAL_MASK 0x1
#define BANK_0_RG_FORCE_NON_THERMAL_SHIFT 0x0

#define BANK_0_RG_VREF_BG_MASK 0x7
#define BANK_0_RG_VREF_BG_SHIFT 0x4

#define BANK_0_RG_STRUP_IREF_TRIM_MASK 0xF
#define BANK_0_RG_STRUP_IREF_TRIM_SHIFT 0x0

#define BANK_0_RG_BB_PROC_SEL_MASK 0x1
#define BANK_0_RG_BB_PROC_SEL_SHIFT 0x7

#define BANK_0_RG_STRUP_RST_DRVSEL_MASK 0x1
#define BANK_0_RG_STRUP_RST_DRVSEL_SHIFT 0x6

#define BANK_0_RG_PMU_LEV_UNGATE_MASK 0x1
#define BANK_0_RG_PMU_LEV_UNGATE_SHIFT 0x1

#define BANK_0_RG_USBDL_EN_MASK 0x1
#define BANK_0_RG_USBDL_EN_SHIFT 0x0

#define BANK_0_RG_PMU_RSV_MASK 0xF
#define BANK_0_RG_PMU_RSV_SHIFT 0x4

#define BANK_0_RG_BIAS_GEN_EN_FORCE_MASK 0x1
#define BANK_0_RG_BIAS_GEN_EN_FORCE_SHIFT 0x5

#define BANK_0_RG_STRUP_PWRON_FORCE_MASK 0x1
#define BANK_0_RG_STRUP_PWRON_FORCE_SHIFT 0x4

#define BANK_0_RG_STRUP_TEST_MASK 0x1
#define BANK_0_RG_STRUP_TEST_SHIFT 0x3

#define BANK_0_RG_STRUP_FT_CTRL_MASK 0x3
#define BANK_0_RG_STRUP_FT_CTRL_SHIFT 0x0

#define BANK_0_PMU_THR_STATUS_MASK 0x7
#define BANK_0_PMU_THR_STATUS_SHIFT 0x4

#define BANK_0_RG_THERMAL_TEST_MASK 0x3
#define BANK_0_RG_THERMAL_TEST_SHIFT 0x2

#define BANK_0_RG_VCORE_PG_ENB_MASK 0x1
#define BANK_0_RG_VCORE_PG_ENB_SHIFT 0x7

#define BANK_0_RG_VPROC_PG_ENB_MASK 0x1
#define BANK_0_RG_VPROC_PG_ENB_SHIFT 0x6

#define BANK_0_RG_VIO18_PG_ENB_MASK 0x1
#define BANK_0_RG_VIO18_PG_ENB_SHIFT 0x5

#define BANK_0_RG_VIO28_PG_ENB_MASK 0x1
#define BANK_0_RG_VIO28_PG_ENB_SHIFT 0x4

#define BANK_0_RG_VA1_PG_ENB_MASK 0x1
#define BANK_0_RG_VA1_PG_ENB_SHIFT 0x3

#define BANK_0_RG_VM12_1_PG_ENB_MASK 0x1
#define BANK_0_RG_VM12_1_PG_ENB_SHIFT 0x2

#define BANK_0_RG_VM12_2_PG_ENB_MASK 0x1
#define BANK_0_RG_VM12_2_PG_ENB_SHIFT 0x1

#define BANK_0_RG_VM12_INT_PG_ENB_MASK 0x1
#define BANK_0_RG_VM12_INT_PG_ENB_SHIFT 0x0

#define BANK_0_RG_STRUP_DIG_RSV_MASK 0xF
#define BANK_0_RG_STRUP_DIG_RSV_SHIFT 0x4

#define BANK_0_RG_VTCXO_PG_ENB_MASK 0x1
#define BANK_0_RG_VTCXO_PG_ENB_SHIFT 0x0

#define BANK_0_RG_OV_INT_EN_MASK 0x1
#define BANK_0_RG_OV_INT_EN_SHIFT 0x7

#define BANK_0_RG_CHRDET_INT_EN_MASK 0x1
#define BANK_0_RG_CHRDET_INT_EN_SHIFT 0x6

#define BANK_0_RG_BVALID_DET_INT_EN_MASK 0x1
#define BANK_0_RG_BVALID_DET_INT_EN_SHIFT 0x5

#define BANK_0_RG_VBATON_UNDET_INT_EN_MASK 0x1
#define BANK_0_RG_VBATON_UNDET_INT_EN_SHIFT 0x4

#define BANK_0_RG_THR_H_INT_EN_MASK 0x1
#define BANK_0_RG_THR_H_INT_EN_SHIFT 0x3

#define BANK_0_RG_THR_L_INT_EN_MASK 0x1
#define BANK_0_RG_THR_L_INT_EN_SHIFT 0x2

#define BANK_0_RG_PWRKEY_INT_EN_MASK 0x1
#define BANK_0_RG_PWRKEY_INT_EN_SHIFT 0x1

#define BANK_0_RG_WATCHDOG_INT_EN_MASK 0x1
#define BANK_0_RG_WATCHDOG_INT_EN_SHIFT 0x0

#define BANK_0_RG_FG_BAT_H_INT_EN_MASK 0x1
#define BANK_0_RG_FG_BAT_H_INT_EN_SHIFT 0x7

#define BANK_0_RG_FG_BAT_L_INT_EN_MASK 0x1
#define BANK_0_RG_FG_BAT_L_INT_EN_SHIFT 0x6

#define BANK_0_RG_HIGH_BAT_INT_EN_MASK 0x1
#define BANK_0_RG_HIGH_BAT_INT_EN_SHIFT 0x5

#define BANK_0_RG_LOW_BAT_INT_EN_MASK 0x1
#define BANK_0_RG_LOW_BAT_INT_EN_SHIFT 0x4

#define BANK_0_RG_SPKR_D_OC_INT_EN_MASK 0x1
#define BANK_0_RG_SPKR_D_OC_INT_EN_SHIFT 0x3

#define BANK_0_RG_SPKL_D_OC_INT_EN_MASK 0x1
#define BANK_0_RG_SPKL_D_OC_INT_EN_SHIFT 0x2

#define BANK_0_RG_SPKR_AB_OC_INT_EN_MASK 0x1
#define BANK_0_RG_SPKR_AB_OC_INT_EN_SHIFT 0x1

#define BANK_0_RG_SPKL_AB_OC_INT_EN_MASK 0x1
#define BANK_0_RG_SPKL_AB_OC_INT_EN_SHIFT 0x0

#define BANK_0_RG_HOMEKEY_INT_EN_MASK 0x1
#define BANK_0_RG_HOMEKEY_INT_EN_SHIFT 0x5

#define BANK_0_RG_VRF18_OC_INT_EN_MASK 0x1
#define BANK_0_RG_VRF18_OC_INT_EN_SHIFT 0x4

#define BANK_0_RG_VPA_OC_INT_EN_MASK 0x1
#define BANK_0_RG_VPA_OC_INT_EN_SHIFT 0x3

#define BANK_0_RG_LDO_OC_INT_EN_MASK 0x1
#define BANK_0_RG_LDO_OC_INT_EN_SHIFT 0x2

#define BANK_0_RG_OV_INT_STATUS_MASK 0x1
#define BANK_0_RG_OV_INT_STATUS_SHIFT 0x7

#define BANK_0_RG_CHRDET_INT_STATUS_MASK 0x1
#define BANK_0_RG_CHRDET_INT_STATUS_SHIFT 0x6

#define BANK_0_RG_BVALID_DET_INT_STATUS_MASK 0x1
#define BANK_0_RG_BVALID_DET_INT_STATUS_SHIFT 0x5

#define BANK_0_RG_VBATON_UNDET_INT_STATUS_MASK 0x1
#define BANK_0_RG_VBATON_UNDET_INT_STATUS_SHIFT 0x4

#define BANK_0_RG_THR_H_INT_STATUS_MASK 0x1
#define BANK_0_RG_THR_H_INT_STATUS_SHIFT 0x3

#define BANK_0_RG_THR_L_INT_STATUS_MASK 0x1
#define BANK_0_RG_THR_L_INT_STATUS_SHIFT 0x2

#define BANK_0_RG_PWRKEY_INT_STATUS_MASK 0x1
#define BANK_0_RG_PWRKEY_INT_STATUS_SHIFT 0x1

#define BANK_0_RG_WATCHDOG_INT_STATUS_MASK 0x1
#define BANK_0_RG_WATCHDOG_INT_STATUS_SHIFT 0x0

#define BANK_0_RG_FG_BAT_H_INT_STATUS_MASK 0x1
#define BANK_0_RG_FG_BAT_H_INT_STATUS_SHIFT 0x7

#define BANK_0_RG_FG_BAT_L_INT_STATUS_MASK 0x1
#define BANK_0_RG_FG_BAT_L_INT_STATUS_SHIFT 0x6

#define BANK_0_RG_HIGH_BAT_INT_STATUS_MASK 0x1
#define BANK_0_RG_HIGH_BAT_INT_STATUS_SHIFT 0x5

#define BANK_0_RG_LOW_BAT_INT_STATUS_MASK 0x1
#define BANK_0_RG_LOW_BAT_INT_STATUS_SHIFT 0x4

#define BANK_0_RG_SPKR_D_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_SPKR_D_OC_INT_STATUS_SHIFT 0x3

#define BANK_0_RG_SPKL_D_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_SPKL_D_OC_INT_STATUS_SHIFT 0x2

#define BANK_0_RG_SPKR_AB_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_SPKR_AB_OC_INT_STATUS_SHIFT 0x1

#define BANK_0_RG_SPKL_AB_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_SPKL_AB_OC_INT_STATUS_SHIFT 0x0

#define BANK_0_RG_HOMEKEY_INT_STATUS_MASK 0x1
#define BANK_0_RG_HOMEKEY_INT_STATUS_SHIFT 0x5

#define BANK_0_RG_VRF18_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_VRF18_OC_INT_STATUS_SHIFT 0x4

#define BANK_0_RG_VPA_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_VPA_OC_INT_STATUS_SHIFT 0x3

#define BANK_0_RG_LDO_OC_INT_STATUS_MASK 0x1
#define BANK_0_RG_LDO_OC_INT_STATUS_SHIFT 0x2

#define BANK_0_VCDT_HV_DET_MASK 0x1
#define BANK_0_VCDT_HV_DET_SHIFT 0x7

#define BANK_0_VCDT_LV_DET_MASK 0x1
#define BANK_0_VCDT_LV_DET_SHIFT 0x6

#define BANK_0_CHRDET_MASK 0x1
#define BANK_0_CHRDET_SHIFT 0x5

#define BANK_0_CHR_EN_MASK 0x1
#define BANK_0_CHR_EN_SHIFT 0x4

#define BANK_0_CSDAC_EN_MASK 0x1
#define BANK_0_CSDAC_EN_SHIFT 0x3

#define BANK_0_PCHR_AUTO_MASK 0x1
#define BANK_0_PCHR_AUTO_SHIFT 0x2

#define BANK_0_CHR_LDO_DET_MASK 0x1
#define BANK_0_CHR_LDO_DET_SHIFT 0x1

#define BANK_0_VCDT_HV_EN_MASK 0x1
#define BANK_0_VCDT_HV_EN_SHIFT 0x0

#define BANK_0_VCDT_HV_VTH_MASK 0xF
#define BANK_0_VCDT_HV_VTH_SHIFT 0x4

#define BANK_0_VCDT_LV_VTH_MASK 0xF
#define BANK_0_VCDT_LV_VTH_SHIFT 0x0

#define BANK_0_VBAT_CC_DET_MASK 0x1
#define BANK_0_VBAT_CC_DET_SHIFT 0x7

#define BANK_0_VBAT_CV_DET_MASK 0x1
#define BANK_0_VBAT_CV_DET_SHIFT 0x6

#define BANK_0_CS_DET_MASK 0x1
#define BANK_0_CS_DET_SHIFT 0x5

#define BANK_0_CS_EN_MASK 0x1
#define BANK_0_CS_EN_SHIFT 0x3

#define BANK_0_VBAT_CC_EN_MASK 0x1
#define BANK_0_VBAT_CC_EN_SHIFT 0x2

#define BANK_0_VBAT_CV_EN_MASK 0x1
#define BANK_0_VBAT_CV_EN_SHIFT 0x1

#define BANK_0_VBAT_CC_VTH_MASK 0x3
#define BANK_0_VBAT_CC_VTH_SHIFT 0x6

#define BANK_0_VBAT_CV_VTH_MASK 0x1F
#define BANK_0_VBAT_CV_VTH_SHIFT 0x0

#define BANK_0_CS_VTH_MASK 0xF
#define BANK_0_CS_VTH_SHIFT 0x0

#define BANK_0_TOLTC_MASK 0x7
#define BANK_0_TOLTC_SHIFT 0x4

#define BANK_0_TOHTC_MASK 0x7
#define BANK_0_TOHTC_SHIFT 0x0

#define BANK_0_VBAT_OV_DET_MASK 0x1
#define BANK_0_VBAT_OV_DET_SHIFT 0x6

#define BANK_0_VBAT_OV_DEG_MASK 0x1
#define BANK_0_VBAT_OV_DEG_SHIFT 0x5

#define BANK_0_VBAT_OV_VTH_MASK 0x3
#define BANK_0_VBAT_OV_VTH_SHIFT 0x1

#define BANK_0_VBAT_OV_EN_MASK 0x1
#define BANK_0_VBAT_OV_EN_SHIFT 0x0

#define BANK_0_BATON_UNDET_MASK 0x1
#define BANK_0_BATON_UNDET_SHIFT 0x7

#define BANK_0_BATON_HT_TRIM_MASK 0x7
#define BANK_0_BATON_HT_TRIM_SHIFT 0x4

#define BANK_0_BATON_HT_EN_MASK 0x1
#define BANK_0_BATON_HT_EN_SHIFT 0x2

#define BANK_0_BATON_EN_MASK 0x1
#define BANK_0_BATON_EN_SHIFT 0x1

#define BANK_0_CSDAC_DAT_H_MASK 0x3
#define BANK_0_CSDAC_DAT_H_SHIFT 0x0

#define BANK_0_CSDAC_DAT_L_MASK 0xFF
#define BANK_0_CSDAC_DAT_L_SHIFT 0x0

#define BANK_0_OTG_BVALID_MASK 0x1
#define BANK_0_OTG_BVALID_SHIFT 0x6

#define BANK_0_OTG_BVALID_EN_MASK 0x1
#define BANK_0_OTG_BVALID_EN_SHIFT 0x5

#define BANK_0_PCHR_FLAG_EN_MASK 0x1
#define BANK_0_PCHR_FLAG_EN_SHIFT 0x4

#define BANK_0_PCHR_FLAG_OUT_MASK 0xF
#define BANK_0_PCHR_FLAG_OUT_SHIFT 0x0

#define BANK_0_PCHR_FLAG_SEL_MASK 0x3F
#define BANK_0_PCHR_FLAG_SEL_SHIFT 0x0

#define BANK_0_PCHR_FT_CTRL_MASK 0x7
#define BANK_0_PCHR_FT_CTRL_SHIFT 0x4

#define BANK_0_PCHR_RST_MASK 0x1
#define BANK_0_PCHR_RST_SHIFT 0x2

#define BANK_0_CSDAC_TEST_MASK 0x1
#define BANK_0_CSDAC_TEST_SHIFT 0x1

#define BANK_0_PCHR_TEST_MASK 0x1
#define BANK_0_PCHR_TEST_SHIFT 0x0

#define BANK_0_CHRWDT_EN_MASK 0x1
#define BANK_0_CHRWDT_EN_SHIFT 0x4

#define BANK_0_CHRWDT_TD_MASK 0xF
#define BANK_0_CHRWDT_TD_SHIFT 0x0

#define BANK_0_PCHR_RV_MASK 0xFF
#define BANK_0_PCHR_RV_SHIFT 0x0

#define BANK_0_CHRWDT_OUT_MASK 0x1
#define BANK_0_CHRWDT_OUT_SHIFT 0x2

#define BANK_0_CHRWDT_FLAG_WR_MASK 0x1
#define BANK_0_CHRWDT_FLAG_WR_SHIFT 0x1

#define BANK_0_CHRWDT_INT_EN_MASK 0x1
#define BANK_0_CHRWDT_INT_EN_SHIFT 0x0

#define BANK_0_ADCIN_VCHR_EN_MASK 0x1
#define BANK_0_ADCIN_VCHR_EN_SHIFT 0x6

#define BANK_0_ADCIN_VSEN_EN_MASK 0x1
#define BANK_0_ADCIN_VSEN_EN_SHIFT 0x5

#define BANK_0_ADCIN_VBAT_EN_MASK 0x1
#define BANK_0_ADCIN_VBAT_EN_SHIFT 0x4

#define BANK_0_USBDL_SET_MASK 0x1
#define BANK_0_USBDL_SET_SHIFT 0x3

#define BANK_0_USBDL_RST_MASK 0x1
#define BANK_0_USBDL_RST_SHIFT 0x2

#define BANK_0_UVLO_VTHL_MASK 0x3
#define BANK_0_UVLO_VTHL_SHIFT 0x0

#define BANK_0_BGR_UNCHOP_MASK 0x1
#define BANK_0_BGR_UNCHOP_SHIFT 0x5

#define BANK_0_BGR_UNCHOP_PH_MASK 0x1
#define BANK_0_BGR_UNCHOP_PH_SHIFT 0x4

#define BANK_0_BGR_RSEL_MASK 0x7
#define BANK_0_BGR_RSEL_SHIFT 0x0

#define BANK_0_BC11_CMP_OUT_MASK 0x1
#define BANK_0_BC11_CMP_OUT_SHIFT 0x7

#define BANK_0_RG_BC11_VSRC_EN_MASK 0x3
#define BANK_0_RG_BC11_VSRC_EN_SHIFT 0x2

#define BANK_0_BC11_RST_MASK 0x1
#define BANK_0_BC11_RST_SHIFT 0x1

#define BANK_0_BC11_BB_CTRL_MASK 0x1
#define BANK_0_BC11_BB_CTRL_SHIFT 0x0

#define BANK_0_BC11_BIAS_EN_MASK 0x1
#define BANK_0_BC11_BIAS_EN_SHIFT 0x7

#define BANK_0_BC11_IPU_EN_MASK 0x3
#define BANK_0_BC11_IPU_EN_SHIFT 0x5

#define BANK_0_BC11_IPD_EN_MASK 0x3
#define BANK_0_BC11_IPD_EN_SHIFT 0x3

#define BANK_0_BC11_CMP_EN_MASK 0x3
#define BANK_0_BC11_CMP_EN_SHIFT 0x1

#define BANK_0_BC11_VREF_VTH_MASK 0x1
#define BANK_0_BC11_VREF_VTH_SHIFT 0x0

#define BANK_0_CSDAC_STP_DEC_MASK 0x7
#define BANK_0_CSDAC_STP_DEC_SHIFT 0x4

#define BANK_0_CSDAC_STP_INC_MASK 0x7
#define BANK_0_CSDAC_STP_INC_SHIFT 0x0

#define BANK_0_CSDAC_STP_MASK 0x7
#define BANK_0_CSDAC_STP_SHIFT 0x4

#define BANK_0_CSDAC_DLY_MASK 0x7
#define BANK_0_CSDAC_DLY_SHIFT 0x0

#define BANK_0_RG_CHRIND_DIMMING_MASK 0x1
#define BANK_0_RG_CHRIND_DIMMING_SHIFT 0x7

#define BANK_0_RG_CHRIND_ON_MASK 0x1
#define BANK_0_RG_CHRIND_ON_SHIFT 0x6

#define BANK_0_RG_LOW_ICH_DB_MASK 0x3F
#define BANK_0_RG_LOW_ICH_DB_SHIFT 0x0

#define BANK_0_RG_ULC_DET_EN_MASK 0x1
#define BANK_0_RG_ULC_DET_EN_SHIFT 0x7

#define BANK_0_RG_HWCV_EN_MASK 0x1
#define BANK_0_RG_HWCV_EN_SHIFT 0x6

#define BANK_0_BATON_TDET_EN_MASK 0x1
#define BANK_0_BATON_TDET_EN_SHIFT 0x5

#define BANK_0_TRACKING_EN_MASK 0x1
#define BANK_0_TRACKING_EN_SHIFT 0x4

#define BANK_0_CSDAC_MODE_MASK 0x1
#define BANK_0_CSDAC_MODE_SHIFT 0x2

#define BANK_0_VCDT_MODE_MASK 0x1
#define BANK_0_VCDT_MODE_SHIFT 0x1

#define BANK_0_CV_MODE_MASK 0x1
#define BANK_0_CV_MODE_SHIFT 0x0

#define BANK_0_RG_ICHRG_TRIM_MASK 0xF
#define BANK_0_RG_ICHRG_TRIM_SHIFT 0x4

#define BANK_0_RG_BGR_TRIM_EN_MASK 0x1
#define BANK_0_RG_BGR_TRIM_EN_SHIFT 0x0

#define BANK_0_RG_BGR_TRIM_MASK 0x1F
#define BANK_0_RG_BGR_TRIM_SHIFT 0x0

#define BANK_0_RG_OVP_TRIM_MASK 0xF
#define BANK_0_RG_OVP_TRIM_SHIFT 0x0

#define BANK_0_CHR_RSV0_MASK 0x1
#define BANK_0_CHR_RSV0_SHIFT 0x7

#define BANK_0_RG_BGR_TEST_RSTB_MASK 0x1
#define BANK_0_RG_BGR_TEST_RSTB_SHIFT 0x6

#define BANK_0_RG_BGR_TEST_EN_MASK 0x1
#define BANK_0_RG_BGR_TEST_EN_SHIFT 0x5

#define BANK_0_RG_CHR_OSC_TRIM_MASK 0x1F
#define BANK_0_RG_CHR_OSC_TRIM_SHIFT 0x0

#define BANK_0_CHR_RSV1_MASK 0xFF
#define BANK_0_CHR_RSV1_SHIFT 0x0

#define BANK_0_RG_VPROC_CSL_MASK 0x3
#define BANK_0_RG_VPROC_CSL_SHIFT 0x6

#define BANK_0_RG_VPROC_CSR_MASK 0x3
#define BANK_0_RG_VPROC_CSR_SHIFT 0x4

#define BANK_0_RG_VPROC_CC_MASK 0x3
#define BANK_0_RG_VPROC_CC_SHIFT 0x2

#define BANK_0_RG_VPROC_RZSEL_MASK 0x3
#define BANK_0_RG_VPROC_RZSEL_SHIFT 0x0

#define BANK_0_RG_VPROC_SLP_MASK 0x3
#define BANK_0_RG_VPROC_SLP_SHIFT 0x6

#define BANK_0_RG_VPROC_ZX_OS_MASK 0x3
#define BANK_0_RG_VPROC_ZX_OS_SHIFT 0x4

#define BANK_0_RG_VPROC_SLEW_MASK 0x3
#define BANK_0_RG_VPROC_SLEW_SHIFT 0x2

#define BANK_0_RG_VPROC_SLEW_NMOS_MASK 0x3
#define BANK_0_RG_VPROC_SLEW_NMOS_SHIFT 0x0

#define BANK_0_RG_VPROC_AVP_OS_MASK 0x7
#define BANK_0_RG_VPROC_AVP_OS_SHIFT 0x4

#define BANK_0_RG_VPROC_AVP_EN_MASK 0x1
#define BANK_0_RG_VPROC_AVP_EN_SHIFT 0x1

#define BANK_0_RG_VPROC_MODESET_MASK 0x1
#define BANK_0_RG_VPROC_MODESET_SHIFT 0x0

#define BANK_0_QI_VPROC_EN_MASK 0x1
#define BANK_0_QI_VPROC_EN_SHIFT 0x7

#define BANK_0_RG_VPROC_EN_MASK 0x1
#define BANK_0_RG_VPROC_EN_SHIFT 0x0

#define BANK_0_RG_VPROC_BURST_MASK 0x3
#define BANK_0_RG_VPROC_BURST_SHIFT 0x4

#define BANK_0_RG_VPROC_VFBADJ_MASK 0x7
#define BANK_0_RG_VPROC_VFBADJ_SHIFT 0x1

#define BANK_0_RG_VPROC_NDIS_EN_MASK 0x1
#define BANK_0_RG_VPROC_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VPROC_VOSEL_MASK 0x1F
#define BANK_0_RG_VPROC_VOSEL_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_SRCLKEN0_MASK 0x1F
#define BANK_0_VPROC_VOSEL_SRCLKEN0_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_SRCLKEN1_MASK 0x1F
#define BANK_0_VPROC_VOSEL_SRCLKEN1_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_DVS00_MASK 0x1F
#define BANK_0_VPROC_VOSEL_DVS00_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_DVS01_MASK 0x1F
#define BANK_0_VPROC_VOSEL_DVS01_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_DVS10_MASK 0x1F
#define BANK_0_VPROC_VOSEL_DVS10_SHIFT 0x0

#define BANK_0_VPROC_VOSEL_DVS11_MASK 0x1F
#define BANK_0_VPROC_VOSEL_DVS11_SHIFT 0x0

#define BANK_0_RG_VPROC_RSV_MASK 0xF
#define BANK_0_RG_VPROC_RSV_SHIFT 0x4

#define BANK_0_RG_VPROC_VOSEL_SFCHG_EN_MASK 0x1
#define BANK_0_RG_VPROC_VOSEL_SFCHG_EN_SHIFT 0x2

#define BANK_0_RG_VPROC_CTRL_MASK 0x3
#define BANK_0_RG_VPROC_CTRL_SHIFT 0x0

#define BANK_0_RG_SMPS_TESTMODE_MASK 0x3F
#define BANK_0_RG_SMPS_TESTMODE_SHIFT 0x0

#define BANK_0_RG_SMPS_RSV_MASK 0xFF
#define BANK_0_RG_SMPS_RSV_SHIFT 0x0

#define BANK_0_QI_VPROC_VOSEL_MASK 0x1F
#define BANK_0_QI_VPROC_VOSEL_SHIFT 0x0

#define BANK_0_RG_BUCK_RSV_MASK 0xFF
#define BANK_0_RG_BUCK_RSV_SHIFT 0x0

#define BANK_0_RG_VCORE_CSL_MASK 0x3
#define BANK_0_RG_VCORE_CSL_SHIFT 0x6

#define BANK_0_RG_VCORE_CSR_MASK 0x3
#define BANK_0_RG_VCORE_CSR_SHIFT 0x4

#define BANK_0_RG_VCORE_CC_MASK 0x3
#define BANK_0_RG_VCORE_CC_SHIFT 0x2

#define BANK_0_RG_VCORE_RZSEL_MASK 0x3
#define BANK_0_RG_VCORE_RZSEL_SHIFT 0x0

#define BANK_0_RG_VCORE_SLP_MASK 0x3
#define BANK_0_RG_VCORE_SLP_SHIFT 0x6

#define BANK_0_RG_VCORE_ZX_OS_MASK 0x3
#define BANK_0_RG_VCORE_ZX_OS_SHIFT 0x4

#define BANK_0_RG_VCORE_SLEW_MASK 0x3
#define BANK_0_RG_VCORE_SLEW_SHIFT 0x2

#define BANK_0_RG_VCORE_SLEW_NMOS_MASK 0x3
#define BANK_0_RG_VCORE_SLEW_NMOS_SHIFT 0x0

#define BANK_0_RG_VCORE_AVP_OS_MASK 0x7
#define BANK_0_RG_VCORE_AVP_OS_SHIFT 0x4

#define BANK_0_RG_VCORE_AVP_EN_MASK 0x1
#define BANK_0_RG_VCORE_AVP_EN_SHIFT 0x1

#define BANK_0_RG_VCORE_MODESET_MASK 0x1
#define BANK_0_RG_VCORE_MODESET_SHIFT 0x0

#define BANK_0_QI_VCORE_EN_MASK 0x1
#define BANK_0_QI_VCORE_EN_SHIFT 0x7

#define BANK_0_RG_VCORE_EN_MASK 0x1
#define BANK_0_RG_VCORE_EN_SHIFT 0x0

#define BANK_0_RG_VCORE_BURST_MASK 0x3
#define BANK_0_RG_VCORE_BURST_SHIFT 0x4

#define BANK_0_RG_VCORE_VFBADJ_MASK 0x7
#define BANK_0_RG_VCORE_VFBADJ_SHIFT 0x1

#define BANK_0_RG_VCORE_NDIS_EN_MASK 0x1
#define BANK_0_RG_VCORE_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCORE_VOSEL_MASK 0x1F
#define BANK_0_RG_VCORE_VOSEL_SHIFT 0x0

#define BANK_0_RG_VCORE_VOSEL_CON1_MASK 0x1F
#define BANK_0_RG_VCORE_VOSEL_CON1_SHIFT 0x0

#define BANK_0_RG_VCORE_RSV_MASK 0xF
#define BANK_0_RG_VCORE_RSV_SHIFT 0x4

#define BANK_0_RG_VCORE_VOSEL_SFCHG_EN_MASK 0x1
#define BANK_0_RG_VCORE_VOSEL_SFCHG_EN_SHIFT 0x2

#define BANK_0_RG_VCORE_CTRL_MASK 0x1
#define BANK_0_RG_VCORE_CTRL_SHIFT 0x0

#define BANK_0_QI_VCORE_VOSEL_MASK 0x1F
#define BANK_0_QI_VCORE_VOSEL_SHIFT 0x0

#define BANK_0_RG_VRF18_CSL_MASK 0x3
#define BANK_0_RG_VRF18_CSL_SHIFT 0x6

#define BANK_0_RG_VRF18_CSR_MASK 0x3
#define BANK_0_RG_VRF18_CSR_SHIFT 0x4

#define BANK_0_RG_VRF18_CC_MASK 0x3
#define BANK_0_RG_VRF18_CC_SHIFT 0x2

#define BANK_0_RG_VRF18_RZSEL_MASK 0x3
#define BANK_0_RG_VRF18_RZSEL_SHIFT 0x0

#define BANK_0_RG_VRF18_SLP_MASK 0x3
#define BANK_0_RG_VRF18_SLP_SHIFT 0x6

#define BANK_0_RG_VRF18_ZX_OS_MASK 0x3
#define BANK_0_RG_VRF18_ZX_OS_SHIFT 0x4

#define BANK_0_RG_VRF18_SLEW_MASK 0x3
#define BANK_0_RG_VRF18_SLEW_SHIFT 0x2

#define BANK_0_RG_VRF18_SLEW_NMOS_MASK 0x3
#define BANK_0_RG_VRF18_SLEW_NMOS_SHIFT 0x0

#define BANK_0_RG_VRF18_AVP_EN_MASK 0x1
#define BANK_0_RG_VRF18_AVP_EN_SHIFT 0x1

#define BANK_0_RG_VRF18_MODESET_MASK 0x1
#define BANK_0_RG_VRF18_MODESET_SHIFT 0x0

#define BANK_0_QI_VRF18_EN_MASK 0x1
#define BANK_0_QI_VRF18_EN_SHIFT 0x7

#define BANK_0_RG_VRF18_ON_CTRL_MASK 0x1
#define BANK_0_RG_VRF18_ON_CTRL_SHIFT 0x1

#define BANK_0_RG_VRF18_EN_MASK 0x1
#define BANK_0_RG_VRF18_EN_SHIFT 0x0

#define BANK_0_RG_VRF18_STBTD_MASK 0x3
#define BANK_0_RG_VRF18_STBTD_SHIFT 0x6

#define BANK_0_RG_VRF18_BURST_MASK 0x3
#define BANK_0_RG_VRF18_BURST_SHIFT 0x4

#define BANK_0_RG_VRF18_OCFB_EN_MASK 0x1
#define BANK_0_RG_VRF18_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VRF18_NDIS_EN_MASK 0x1
#define BANK_0_RG_VRF18_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VRF18_VOSEL_MASK 0x1F
#define BANK_0_RG_VRF18_VOSEL_SHIFT 0x0

#define BANK_0_RG_VRF18_RSV_MASK 0xF
#define BANK_0_RG_VRF18_RSV_SHIFT 0x0

#define BANK_0_RO_QI_VRF18_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VRF18_OC_STATUS_SHIFT 0x0

#define BANK_0_RG_VIO18_CSL_MASK 0x3
#define BANK_0_RG_VIO18_CSL_SHIFT 0x6

#define BANK_0_RG_VIO18_CSR_MASK 0x3
#define BANK_0_RG_VIO18_CSR_SHIFT 0x4

#define BANK_0_RG_VIO18_CC_MASK 0x3
#define BANK_0_RG_VIO18_CC_SHIFT 0x2

#define BANK_0_RG_VIO18_RZSEL_MASK 0x3
#define BANK_0_RG_VIO18_RZSEL_SHIFT 0x0

#define BANK_0_RG_VIO18_SLP_MASK 0x3
#define BANK_0_RG_VIO18_SLP_SHIFT 0x6

#define BANK_0_RG_VIO18_ZX_OS_MASK 0x3
#define BANK_0_RG_VIO18_ZX_OS_SHIFT 0x4

#define BANK_0_RG_VIO18_SLEW_MASK 0x3
#define BANK_0_RG_VIO18_SLEW_SHIFT 0x2

#define BANK_0_RG_VIO18_SELW_NMOS_MASK 0x3
#define BANK_0_RG_VIO18_SELW_NMOS_SHIFT 0x0

#define BANK_0_RG_VIO18_AVP_EN_MASK 0x1
#define BANK_0_RG_VIO18_AVP_EN_SHIFT 0x1

#define BANK_0_RG_VIO18_MODESET_MASK 0x1
#define BANK_0_RG_VIO18_MODESET_SHIFT 0x0

#define BANK_0_NI_VIO18_EN_MASK 0x1
#define BANK_0_NI_VIO18_EN_SHIFT 0x7

#define BANK_0_RG_VIO18_EN_MASK 0x1
#define BANK_0_RG_VIO18_EN_SHIFT 0x0

#define BANK_0_RG_VIO18_BURST_MASK 0x3
#define BANK_0_RG_VIO18_BURST_SHIFT 0x4

#define BANK_0_RG_VIO18_NDIS_EN_MASK 0x1
#define BANK_0_RG_VIO18_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VIO18_VOSEL_MASK 0x1F
#define BANK_0_RG_VIO18_VOSEL_SHIFT 0x0

#define BANK_0_RG_VIO18_RSV_MASK 0xF
#define BANK_0_RG_VIO18_RSV_SHIFT 0x4

#define BANK_0_RG_VPA_CSL_MASK 0x3
#define BANK_0_RG_VPA_CSL_SHIFT 0x6

#define BANK_0_RG_VPA_CSR_MASK 0x3
#define BANK_0_RG_VPA_CSR_SHIFT 0x4

#define BANK_0_RG_VPA_CC_MASK 0x3
#define BANK_0_RG_VPA_CC_SHIFT 0x2

#define BANK_0_RG_VPA_RZSEL_MASK 0x3
#define BANK_0_RG_VPA_RZSEL_SHIFT 0x0

#define BANK_0_RG_VPA_SLP_MASK 0x3
#define BANK_0_RG_VPA_SLP_SHIFT 0x6

#define BANK_0_RG_VPA_ZX_OS_MASK 0x3
#define BANK_0_RG_VPA_ZX_OS_SHIFT 0x4

#define BANK_0_RG_VPA_SLEW_MASK 0x3
#define BANK_0_RG_VPA_SLEW_SHIFT 0x2

#define BANK_0_RG_VPA_SLEW_NMOS_MASK 0x3
#define BANK_0_RG_VPA_SLEW_NMOS_SHIFT 0x0

#define BANK_0_RG_VPA_AVP_EN_MASK 0x1
#define BANK_0_RG_VPA_AVP_EN_SHIFT 0x1

#define BANK_0_RG_VPA_MODESET_MASK 0x1
#define BANK_0_RG_VPA_MODESET_SHIFT 0x0

#define BANK_0_RG_VPA_EN_MASK 0x1
#define BANK_0_RG_VPA_EN_SHIFT 0x0

#define BANK_0_RG_VPA_BURST_MASK 0x3
#define BANK_0_RG_VPA_BURST_SHIFT 0x4

#define BANK_0_RG_VPA_NDIS_EN_MASK 0x1
#define BANK_0_RG_VPA_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VPA_VOSEL_MASK 0x1F
#define BANK_0_RG_VPA_VOSEL_SHIFT 0x0

#define BANK_0_RG_PASEL_SET0_MASK 0x1F
#define BANK_0_RG_PASEL_SET0_SHIFT 0x0

#define BANK_0_RG_PASEL_SET1_MASK 0x1F
#define BANK_0_RG_PASEL_SET1_SHIFT 0x0

#define BANK_0_RG_PASEL_SET2_MASK 0x1F
#define BANK_0_RG_PASEL_SET2_SHIFT 0x0

#define BANK_0_RG_PASEL_SET3_MASK 0x1F
#define BANK_0_RG_PASEL_SET3_SHIFT 0x0

#define BANK_0_RG_PASEL_SET4_MASK 0x1F
#define BANK_0_RG_PASEL_SET4_SHIFT 0x0

#define BANK_0_RG_PASEL_SET5_MASK 0x1F
#define BANK_0_RG_PASEL_SET5_SHIFT 0x0

#define BANK_0_RG_PASEL_SET6_MASK 0x1F
#define BANK_0_RG_PASEL_SET6_SHIFT 0x0

#define BANK_0_RG_PASEL_SET7_MASK 0x1F
#define BANK_0_RG_PASEL_SET7_SHIFT 0x0

#define BANK_0_RG_VPA_RSV_MASK 0xF
#define BANK_0_RG_VPA_RSV_SHIFT 0x4

#define BANK_0_RG_VPA_CTRL_MASK 0x1
#define BANK_0_RG_VPA_CTRL_SHIFT 0x0

#define BANK_0_QI_VPA_VOSEL_MASK 0x1F
#define BANK_0_QI_VPA_VOSEL_SHIFT 0x0

#define BANK_0_RG_VM12_1_CAL_MASK 0xF
#define BANK_0_RG_VM12_1_CAL_SHIFT 0x0

#define BANK_0_QI_VM12_1_EN_MASK 0x1
#define BANK_0_QI_VM12_1_EN_SHIFT 0x7

#define BANK_0_VM12_1_EN_MASK 0x1
#define BANK_0_VM12_1_EN_SHIFT 0x0

#define BANK_0_RG_VM12_1_STBTD_MASK 0x3
#define BANK_0_RG_VM12_1_STBTD_SHIFT 0x4

#define BANK_0_RG_VM12_1_OCFB_EN_MASK 0x1
#define BANK_0_RG_VM12_1_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VM12_1_NDIS_EN_MASK 0x1
#define BANK_0_RG_VM12_1_NDIS_EN_SHIFT 0x0

#define BANK_0_QI_VM12_1_MODE_MASK 0x1
#define BANK_0_QI_VM12_1_MODE_SHIFT 0x7

#define BANK_0_VM12_1_LP_SET_MASK 0x1
#define BANK_0_VM12_1_LP_SET_SHIFT 0x1

#define BANK_0_VM12_1_LP_SEL_MASK 0x1
#define BANK_0_VM12_1_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VM12_2_CAL_MASK 0xF
#define BANK_0_RG_VM12_2_CAL_SHIFT 0x0

#define BANK_0_QI_VM12_2_EN_MASK 0x1
#define BANK_0_QI_VM12_2_EN_SHIFT 0x7

#define BANK_0_VM12_2_EN_MASK 0x1
#define BANK_0_VM12_2_EN_SHIFT 0x0

#define BANK_0_RG_VM12_2_STBTD_MASK 0x3
#define BANK_0_RG_VM12_2_STBTD_SHIFT 0x4

#define BANK_0_RG_VM12_2_OCFB_EN_MASK 0x1
#define BANK_0_RG_VM12_2_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VM12_2_NDIS_EN_MASK 0x1
#define BANK_0_RG_VM12_2_NDIS_EN_SHIFT 0x0

#define BANK_0_QI_VM12_2_MODE_MASK 0x1
#define BANK_0_QI_VM12_2_MODE_SHIFT 0x7

#define BANK_0_VM12_2_LP_SET_MASK 0x1
#define BANK_0_VM12_2_LP_SET_SHIFT 0x1

#define BANK_0_VM12_2_LP_SEL_MASK 0x1
#define BANK_0_VM12_2_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VM12_INT_CAL_MASK 0x1F
#define BANK_0_RG_VM12_INT_CAL_SHIFT 0x0

#define BANK_0_VM12_INT_SLEEP_MASK 0x1F
#define BANK_0_VM12_INT_SLEEP_SHIFT 0x0

#define BANK_0_VM12_INT_LOW_BOUND_MASK 0x1F
#define BANK_0_VM12_INT_LOW_BOUND_SHIFT 0x0

#define BANK_0_QI_VM12_INT_EN_MASK 0x1
#define BANK_0_QI_VM12_INT_EN_SHIFT 0x7

#define BANK_0_VM12_INT_EN_MASK 0x1
#define BANK_0_VM12_INT_EN_SHIFT 0x0

#define BANK_0_RG_VM12_INT_STBTD_MASK 0x3
#define BANK_0_RG_VM12_INT_STBTD_SHIFT 0x4

#define BANK_0_RG_VM12_INT_OCFB_EN_MASK 0x1
#define BANK_0_RG_VM12_INT_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VM12_INT_NDIS_EN_MASK 0x1
#define BANK_0_RG_VM12_INT_NDIS_EN_SHIFT 0x0

#define BANK_0_VM12_INT_CTRL_SEL_MASK 0x1
#define BANK_0_VM12_INT_CTRL_SEL_SHIFT 0x4

#define BANK_0_RG_VM12_INT_TRIM_MASK 0x7
#define BANK_0_RG_VM12_INT_TRIM_SHIFT 0x1

#define BANK_0_RG_VM12_INT_CAL_SFCHG_EN_MASK 0x1
#define BANK_0_RG_VM12_INT_CAL_SFCHG_EN_SHIFT 0x0

#define BANK_0_QI_VM12_INT_MODE_MASK 0x1
#define BANK_0_QI_VM12_INT_MODE_SHIFT 0x7

#define BANK_0_VM12_INT_LP_SET_MASK 0x1
#define BANK_0_VM12_INT_LP_SET_SHIFT 0x1

#define BANK_0_VM12_INT_LP_SEL_MASK 0x1
#define BANK_0_VM12_INT_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VIO28_CAL_MASK 0xF
#define BANK_0_RG_VIO28_CAL_SHIFT 0x0

#define BANK_0_QI_VIO28_EN_MASK 0x1
#define BANK_0_QI_VIO28_EN_SHIFT 0x7

#define BANK_0_VIO28_EN_MASK 0x1
#define BANK_0_VIO28_EN_SHIFT 0x0

#define BANK_0_RG_VIO28_STBTD_MASK 0x3
#define BANK_0_RG_VIO28_STBTD_SHIFT 0x4

#define BANK_0_RG_VIO28_OCFB_EN_MASK 0x1
#define BANK_0_RG_VIO28_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VIO28_NDIS_EN_MASK 0x1
#define BANK_0_RG_VIO28_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VSIM_CAL_MASK 0xF
#define BANK_0_RG_VSIM_CAL_SHIFT 0x0

#define BANK_0_RG_VSIM_VOSEL_MASK 0x1
#define BANK_0_RG_VSIM_VOSEL_SHIFT 0x4

#define BANK_0_RG_VSIM_EN_MASK 0x1
#define BANK_0_RG_VSIM_EN_SHIFT 0x0

#define BANK_0_RG_VSIM_STBTD_MASK 0x3
#define BANK_0_RG_VSIM_STBTD_SHIFT 0x4

#define BANK_0_RG_VSIM_OCFB_EN_MASK 0x1
#define BANK_0_RG_VSIM_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VSIM_NDIS_EN_MASK 0x1
#define BANK_0_RG_VSIM_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VSIM2_CAL_MASK 0xF
#define BANK_0_RG_VSIM2_CAL_SHIFT 0x0

#define BANK_0_RG_VSIM2_VOSEL_MASK 0x7
#define BANK_0_RG_VSIM2_VOSEL_SHIFT 0x4

#define BANK_0_RG_VSIM2_EN_MASK 0x1
#define BANK_0_RG_VSIM2_EN_SHIFT 0x0

#define BANK_0_RG_VSIM2_STBTD_MASK 0x3
#define BANK_0_RG_VSIM2_STBTD_SHIFT 0x4

#define BANK_0_RG_VSIM2_OCFB_EN_MASK 0x1
#define BANK_0_RG_VSIM2_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VSIM2_NDIS_EN_MASK 0x1
#define BANK_0_RG_VSIM2_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VUSB_CAL_MASK 0xF
#define BANK_0_RG_VUSB_CAL_SHIFT 0x0

#define BANK_0_QI_VUSB_EN_MASK 0x1
#define BANK_0_QI_VUSB_EN_SHIFT 0x7

#define BANK_0_RG_VUSB_EN_MASK 0x1
#define BANK_0_RG_VUSB_EN_SHIFT 0x0

#define BANK_0_RG_VUSB_STBTD_MASK 0x3
#define BANK_0_RG_VUSB_STBTD_SHIFT 0x4

#define BANK_0_RG_VUSB_OCFB_EN_MASK 0x1
#define BANK_0_RG_VUSB_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VUSB_NDIS_EN_MASK 0x1
#define BANK_0_RG_VUSB_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCAMD_CAL_MASK 0xF
#define BANK_0_RG_VCAMD_CAL_SHIFT 0x0

#define BANK_0_RG_VCAMD_VOSEL_MASK 0x7
#define BANK_0_RG_VCAMD_VOSEL_SHIFT 0x4

#define BANK_0_RG_VCAMD_EN_MASK 0x1
#define BANK_0_RG_VCAMD_EN_SHIFT 0x0

#define BANK_0_RG_VCAMD_STBTD_MASK 0x3
#define BANK_0_RG_VCAMD_STBTD_SHIFT 0x4

#define BANK_0_RG_VCAMD_OCFB_EN_MASK 0x1
#define BANK_0_RG_VCAMD_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VCAMD_NDIS_EN_MASK 0x1
#define BANK_0_RG_VCAMD_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCAM_IO_CAL_MASK 0xF
#define BANK_0_RG_VCAM_IO_CAL_SHIFT 0x0

#define BANK_0_RG_VCAM_IO_VOSEL_MASK 0x7
#define BANK_0_RG_VCAM_IO_VOSEL_SHIFT 0x4

#define BANK_0_RG_VCAM_IO_EN_MASK 0x1
#define BANK_0_RG_VCAM_IO_EN_SHIFT 0x0

#define BANK_0_RG_VCAM_IO_STBTD_MASK 0x3
#define BANK_0_RG_VCAM_IO_STBTD_SHIFT 0x4

#define BANK_0_RG_VCAM_IO_OCFB_EN_MASK 0x1
#define BANK_0_RG_VCAM_IO_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VCAM_IO_NDIS_EN_MASK 0x1
#define BANK_0_RG_VCAM_IO_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCAM_AF_CAL_MASK 0xF
#define BANK_0_RG_VCAM_AF_CAL_SHIFT 0x0

#define BANK_0_RG_VCAM_AF_VOSEL_MASK 0x7
#define BANK_0_RG_VCAM_AF_VOSEL_SHIFT 0x4

#define BANK_0_RG_VCAM_AF_EN_MASK 0x1
#define BANK_0_RG_VCAM_AF_EN_SHIFT 0x0

#define BANK_0_RG_VCAM_AF_STBTD_MASK 0x3
#define BANK_0_RG_VCAM_AF_STBTD_SHIFT 0x4

#define BANK_0_RG_VCAM_AF_OCFB_EN_MASK 0x1
#define BANK_0_RG_VCAM_AF_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VCAM_AF_NDIS_EN_MASK 0x1
#define BANK_0_RG_VCAM_AF_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VMC_CAL_MASK 0xF
#define BANK_0_RG_VMC_CAL_SHIFT 0x0

#define BANK_0_QI_VMC_EN_MASK 0x1
#define BANK_0_QI_VMC_EN_SHIFT 0x7

#define BANK_0_RG_VMC_VOSEL_MASK 0x7
#define BANK_0_RG_VMC_VOSEL_SHIFT 0x4

#define BANK_0_RG_VMC_EN_MASK 0x1
#define BANK_0_RG_VMC_EN_SHIFT 0x0

#define BANK_0_RG_VMC_STBTD_MASK 0x3
#define BANK_0_RG_VMC_STBTD_SHIFT 0x4

#define BANK_0_RG_VMC_OCFB_EN_MASK 0x1
#define BANK_0_RG_VMC_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VMC_NDIS_EN_MASK 0x1
#define BANK_0_RG_VMC_NDIS_EN_SHIFT 0x0

#define BANK_0_QI_VMC_MODE_MASK 0x1
#define BANK_0_QI_VMC_MODE_SHIFT 0x7

#define BANK_0_VMC_LP_MODE_SET_MASK 0x1
#define BANK_0_VMC_LP_MODE_SET_SHIFT 0x1

#define BANK_0_VMC_LP_SEL_MASK 0x1
#define BANK_0_VMC_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VMCH_CAL_MASK 0xF
#define BANK_0_RG_VMCH_CAL_SHIFT 0x0

#define BANK_0_QI_VMCH_EN_MASK 0x1
#define BANK_0_QI_VMCH_EN_SHIFT 0x7

#define BANK_0_RG_VMCH_VOSEL_MASK 0x7
#define BANK_0_RG_VMCH_VOSEL_SHIFT 0x4

#define BANK_0_RG_VMCH_EN_MASK 0x1
#define BANK_0_RG_VMCH_EN_SHIFT 0x0

#define BANK_0_RG_VMCH_STBTD_MASK 0x3
#define BANK_0_RG_VMCH_STBTD_SHIFT 0x4

#define BANK_0_RG_VMCH_OCFB_EN_MASK 0x1
#define BANK_0_RG_VMCH_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VMCH_NDIS_EN_MASK 0x1
#define BANK_0_RG_VMCH_NDIS_EN_SHIFT 0x0

#define BANK_0_QI_VMCH_MODE_MASK 0x1
#define BANK_0_QI_VMCH_MODE_SHIFT 0x7

#define BANK_0_VMCH_LP_MODE_SET_MASK 0x1
#define BANK_0_VMCH_LP_MODE_SET_SHIFT 0x1

#define BANK_0_VMCH_LP_SEL_MASK 0x1
#define BANK_0_VMCH_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VGP_CAL_MASK 0xF
#define BANK_0_RG_VGP_CAL_SHIFT 0x0

#define BANK_0_RG_VGP_VOSEL_MASK 0x7
#define BANK_0_RG_VGP_VOSEL_SHIFT 0x4

#define BANK_0_RG_VGP_EN_MASK 0x1
#define BANK_0_RG_VGP_EN_SHIFT 0x0

#define BANK_0_RG_VGP_STBTD_MASK 0x3
#define BANK_0_RG_VGP_STBTD_SHIFT 0x4

#define BANK_0_RG_VGP_OCFB_EN_MASK 0x1
#define BANK_0_RG_VGP_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VGP_NDIS_EN_MASK 0x1
#define BANK_0_RG_VGP_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VGP2_CAL_MASK 0xF
#define BANK_0_RG_VGP2_CAL_SHIFT 0x0

#define BANK_0_RG_VGP2_VOSEL_MASK 0x7
#define BANK_0_RG_VGP2_VOSEL_SHIFT 0x4

#define BANK_0_RG_VGP2_EN_MASK 0x1
#define BANK_0_RG_VGP2_EN_SHIFT 0x0

#define BANK_0_RG_VGP2_STBTD_MASK 0x3
#define BANK_0_RG_VGP2_STBTD_SHIFT 0x4

#define BANK_0_RG_VGP2_OCFB_EN_MASK 0x1
#define BANK_0_RG_VGP2_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VGP2_NDIS_EN_MASK 0x1
#define BANK_0_RG_VGP2_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VIBR_CAL_MASK 0xF
#define BANK_0_RG_VIBR_CAL_SHIFT 0x0

#define BANK_0_RG_VIBR_VOSEL_MASK 0x7
#define BANK_0_RG_VIBR_VOSEL_SHIFT 0x4

#define BANK_0_RG_VIBR_EN_MASK 0x1
#define BANK_0_RG_VIBR_EN_SHIFT 0x0

#define BANK_0_RG_VIBR_STBTD_MASK 0x3
#define BANK_0_RG_VIBR_STBTD_SHIFT 0x4

#define BANK_0_RG_VIBR_THR_SHDN_EN_MASK 0x1
#define BANK_0_RG_VIBR_THR_SHDN_EN_SHIFT 0x3

#define BANK_0_RG_VIBR_STB_SEL_MASK 0x1
#define BANK_0_RG_VIBR_STB_SEL_SHIFT 0x2

#define BANK_0_RG_VIBR_OCFB_EN_MASK 0x1
#define BANK_0_RG_VIBR_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VIBR_NDIS_EN_MASK 0x1
#define BANK_0_RG_VIBR_NDIS_EN_SHIFT 0x0

#define BANK_0_RO_QI_VM12_1_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VM12_1_OC_STATUS_SHIFT 0x0

#define BANK_0_RO_QI_VM12_2_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VM12_2_OC_STATUS_SHIFT 0x1

#define BANK_0_RO_QI_VM12_INT_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VM12_INT_OC_STATUS_SHIFT 0x2

#define BANK_0_RO_QI_VIO28_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VIO28_OC_STATUS_SHIFT 0x3

#define BANK_0_RO_QI_VSIM_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VSIM_OC_STATUS_SHIFT 0x4

#define BANK_0_RO_QI_VSIM2_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VSIM2_OC_STATUS_SHIFT 0x5

#define BANK_0_RO_QI_VUSB_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VUSB_OC_STATUS_SHIFT 0x6

#define BANK_0_RO_QI_VCAMD_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VCAMD_OC_STATUS_SHIFT 0x0

#define BANK_0_RO_QI_VCAM_IO_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VCAM_IO_OC_STATUS_SHIFT 0x1

#define BANK_0_RO_QI_VCAM_AF_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VCAM_AF_OC_STATUS_SHIFT 0x2

#define BANK_0_RO_QI_VMC_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VMC_OC_STATUS_SHIFT 0x3

#define BANK_0_RO_QI_VMCH_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VMCH_OC_STATUS_SHIFT 0x4

#define BANK_0_RO_QI_VGP_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VGP_OC_STATUS_SHIFT 0x5

#define BANK_0_RO_QI_VGP2_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VGP2_OC_STATUS_SHIFT 0x6

#define BANK_0_RO_QI_VIBR_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VIBR_OC_STATUS_SHIFT 0x7

#define BANK_0_QI_VM12_INT_CAL_MASK 0x1F
#define BANK_0_QI_VM12_INT_CAL_SHIFT 0x0

#define BANK_0_RG_DIGLDO_RSV_MASK 0xF
#define BANK_0_RG_DIGLDO_RSV_SHIFT 0x0

#define BANK_0_RG_VRF_CAL_MASK 0xF
#define BANK_0_RG_VRF_CAL_SHIFT 0x0

#define BANK_0_QI_VRF_EN_MASK 0x1
#define BANK_0_QI_VRF_EN_SHIFT 0x7

#define BANK_0_VRF_ON_CTRL_MASK 0x1
#define BANK_0_VRF_ON_CTRL_SHIFT 0x1

#define BANK_0_RG_VRF_EN_MASK 0x1
#define BANK_0_RG_VRF_EN_SHIFT 0x0

#define BANK_0_RG_VRF_STBTD_MASK 0x3
#define BANK_0_RG_VRF_STBTD_SHIFT 0x4

#define BANK_0_RG_VRF_OCFB_EN_MASK 0x1
#define BANK_0_RG_VRF_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VRF_NDIS_EN_MASK 0x1
#define BANK_0_RG_VRF_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VTCXO_CAL_MASK 0xF
#define BANK_0_RG_VTCXO_CAL_SHIFT 0x0

#define BANK_0_QI_VTCXO_EN_MASK 0x1
#define BANK_0_QI_VTCXO_EN_SHIFT 0x7

#define BANK_0_VTCXO_ON_CTRL_MASK 0x1
#define BANK_0_VTCXO_ON_CTRL_SHIFT 0x1

#define BANK_0_RG_VTCXO_EN_MASK 0x1
#define BANK_0_RG_VTCXO_EN_SHIFT 0x0

#define BANK_0_RG_VTCXO_STBTD_MASK 0x3
#define BANK_0_RG_VTCXO_STBTD_SHIFT 0x4

#define BANK_0_RG_VTCXO_OCFB_EN_MASK 0x1
#define BANK_0_RG_VTCXO_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VTCXO_NDIS_EN_MASK 0x1
#define BANK_0_RG_VTCXO_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VA1_CAL_MASK 0xF
#define BANK_0_RG_VA1_CAL_SHIFT 0x0

#define BANK_0_QI_VA1_EN_MASK 0x1
#define BANK_0_QI_VA1_EN_SHIFT 0x7

#define BANK_0_RG_VA1_VOSEL_MASK 0x3
#define BANK_0_RG_VA1_VOSEL_SHIFT 0x4

#define BANK_0_RG_VA1_EN_MASK 0x1
#define BANK_0_RG_VA1_EN_SHIFT 0x0

#define BANK_0_RG_VA1_STBTD_MASK 0x3
#define BANK_0_RG_VA1_STBTD_SHIFT 0x4

#define BANK_0_RG_VA1_OCFB_EN_MASK 0x1
#define BANK_0_RG_VA1_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VA1_NDIS_EN_MASK 0x1
#define BANK_0_RG_VA1_NDIS_EN_SHIFT 0x0

#define BANK_0_QI_VA1_MODE_MASK 0x1
#define BANK_0_QI_VA1_MODE_SHIFT 0x7

#define BANK_0_VA1_LP_SET_MASK 0x1
#define BANK_0_VA1_LP_SET_SHIFT 0x1

#define BANK_0_VA1_LP_SEL_MASK 0x1
#define BANK_0_VA1_LP_SEL_SHIFT 0x0

#define BANK_0_RG_VA2_CAL_MASK 0xF
#define BANK_0_RG_VA2_CAL_SHIFT 0x0

#define BANK_0_QI_VA2_EN_MASK 0x1
#define BANK_0_QI_VA2_EN_SHIFT 0x7

#define BANK_0_RG_VA2_VOSEL_MASK 0x1
#define BANK_0_RG_VA2_VOSEL_SHIFT 0x4

#define BANK_0_RG_VA2_EN_MASK 0x1
#define BANK_0_RG_VA2_EN_SHIFT 0x0

#define BANK_0_RG_VA2_STBTD_MASK 0x3
#define BANK_0_RG_VA2_STBTD_SHIFT 0x4

#define BANK_0_RG_VA2_OCFB_EN_MASK 0x1
#define BANK_0_RG_VA2_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VA2_NDIS_EN_MASK 0x1
#define BANK_0_RG_VA2_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCAMA_CAL_MASK 0xF
#define BANK_0_RG_VCAMA_CAL_SHIFT 0x0

#define BANK_0_RG_VCAMA_VOSEL_MASK 0x3
#define BANK_0_RG_VCAMA_VOSEL_SHIFT 0x4

#define BANK_0_RG_VCAMA_EN_MASK 0x1
#define BANK_0_RG_VCAMA_EN_SHIFT 0x0

#define BANK_0_RG_VCAMA_STBTD_MASK 0x3
#define BANK_0_RG_VCAMA_STBTD_SHIFT 0x4

#define BANK_0_RG_VCAMA_OCFB_EN_MASK 0x1
#define BANK_0_RG_VCAMA_OCFB_EN_SHIFT 0x1

#define BANK_0_RG_VCAMA_NDIS_EN_MASK 0x1
#define BANK_0_RG_VCAMA_NDIS_EN_SHIFT 0x0

#define BANK_0_RG_VCAMA_FBSEL_MASK 0x3
#define BANK_0_RG_VCAMA_FBSEL_SHIFT 0x0

#define BANK_0_RG_VRTC_VOSEL_MASK 0x3
#define BANK_0_RG_VRTC_VOSEL_SHIFT 0x0

#define BANK_0_QI_VRTC_EN_MASK 0x1
#define BANK_0_QI_VRTC_EN_SHIFT 0x7

#define BANK_0_VRTC_EN_MASK 0x1
#define BANK_0_VRTC_EN_SHIFT 0x0

#define BANK_0_RO_QI_VRF_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VRF_OC_STATUS_SHIFT 0x0

#define BANK_0_RO_QI_VTCXO_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VTCXO_OC_STATUS_SHIFT 0x1

#define BANK_0_RO_QI_VA1_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VA1_OC_STATUS_SHIFT 0x2

#define BANK_0_RO_QI_VA2_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VA2_OC_STATUS_SHIFT 0x3

#define BANK_0_RO_QI_VCAMA_OC_STATUS_MASK 0x1
#define BANK_0_RO_QI_VCAMA_OC_STATUS_SHIFT 0x4

#define BANK_0_RG_ANALDO_RSV_MASK 0xF
#define BANK_0_RG_ANALDO_RSV_SHIFT 0x0

#define BANK_0_rg_auto_k_MASK 0x1
#define BANK_0_rg_auto_k_SHIFT 0x6

#define BANK_0_rg_k_src_sel_MASK 0x1
#define BANK_0_rg_k_src_sel_SHIFT 0x5

#define BANK_0_rg_k_start_manual_MASK 0x1
#define BANK_0_rg_k_start_manual_SHIFT 0x4

#define BANK_0_rg_k_once_MASK 0x1
#define BANK_0_rg_k_once_SHIFT 0x3

#define BANK_0_rg_k_once_en_MASK 0x1
#define BANK_0_rg_k_once_en_SHIFT 0x2

#define BANK_0_rg_k_map_sel_MASK 0x1
#define BANK_0_rg_k_map_sel_SHIFT 0x1

#define BANK_0_rg_k_rst_done_MASK 0x1
#define BANK_0_rg_k_rst_done_SHIFT 0x0

#define BANK_0_rg_k_control_smps_MASK 0xF
#define BANK_0_rg_k_control_smps_SHIFT 0x0

#define BANK_0_k_control_MASK 0x1F
#define BANK_0_k_control_SHIFT 0x3

#define BANK_0_k_done_MASK 0x1
#define BANK_0_k_done_SHIFT 0x1

#define BANK_0_k_result_MASK 0x1
#define BANK_0_k_result_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_C0_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_C0_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_C0_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_C0_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_C0_MASK 0x1
#define BANK_0_RG_ADC_RDY_C0_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_C1_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_C1_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_C1_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_C1_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_C1_MASK 0x1
#define BANK_0_RG_ADC_RDY_C1_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_C2_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_C2_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_C2_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_C2_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_C2_MASK 0x1
#define BANK_0_RG_ADC_RDY_C2_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_C3_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_C3_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_C3_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_C3_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_C3_MASK 0x1
#define BANK_0_RG_ADC_RDY_C3_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_WAKEUP_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_WAKEUP_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_WAKEUP_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_WAKEUP_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_WAKEUP_MASK 0x1
#define BANK_0_RG_ADC_RDY_WAKEUP_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_LBAT_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_LBAT_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_LBAT_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_LBAT_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_LBAT_MASK 0x1
#define BANK_0_RG_ADC_RDY_LBAT_SHIFT 0x7

#define BANK_0_RG_ADC_OUT_TRIM_7_0_MASK 0xFF
#define BANK_0_RG_ADC_OUT_TRIM_7_0_SHIFT 0x0

#define BANK_0_RG_ADC_OUT_TRIM_9_8_MASK 0x3
#define BANK_0_RG_ADC_OUT_TRIM_9_8_SHIFT 0x0

#define BANK_0_RG_ADC_RDY_TRIM_MASK 0x1
#define BANK_0_RG_ADC_RDY_TRIM_SHIFT 0x7

#define BANK_0_RG_AUXADC_START_MASK 0x1
#define BANK_0_RG_AUXADC_START_SHIFT 0x0

#define BANK_0_RG_AUXADC_BIST_ENB_MASK 0x1
#define BANK_0_RG_AUXADC_BIST_ENB_SHIFT 0x1

#define BANK_0_RG_ADC_TRIM_COMP_MASK 0x1
#define BANK_0_RG_ADC_TRIM_COMP_SHIFT 0x2

#define BANK_0_RG_AUXADC_CHSEL_MASK 0xF
#define BANK_0_RG_AUXADC_CHSEL_SHIFT 0x4

#define BANK_0_RG_SPL_NUM_MASK 0xF
#define BANK_0_RG_SPL_NUM_SHIFT 0x4

#define BANK_0_RG_AVG_NUM_MASK 0x3
#define BANK_0_RG_AVG_NUM_SHIFT 0x2

#define BANK_0_RG_BUF_PWD_B_MASK 0x1
#define BANK_0_RG_BUF_PWD_B_SHIFT 0x1

#define BANK_0_RG_ADC_PWD_B_MASK 0x1
#define BANK_0_RG_ADC_PWD_B_SHIFT 0x0

#define BANK_0_RG_LBAT_DEBT_MAX_MASK 0xFF
#define BANK_0_RG_LBAT_DEBT_MAX_SHIFT 0x0

#define BANK_0_RG_LBAT_DEBT_MIN_MASK 0xFF
#define BANK_0_RG_LBAT_DEBT_MIN_SHIFT 0x0

#define BANK_0_RG_LBAT_DET_PRD_7_0_MASK 0xFF
#define BANK_0_RG_LBAT_DET_PRD_7_0_SHIFT 0x0

#define BANK_0_RG_LBAT_DET_PRD_15_8_MASK 0xFF
#define BANK_0_RG_LBAT_DET_PRD_15_8_SHIFT 0x0

#define BANK_0_RG_LBAT_DET_PRD_19_16_MASK 0xF
#define BANK_0_RG_LBAT_DET_PRD_19_16_SHIFT 0x0

#define BANK_0_RG_LBAT_VOLT_MAX_7_0_MASK 0xFF
#define BANK_0_RG_LBAT_VOLT_MAX_7_0_SHIFT 0x0

#define BANK_0_RG_LBAT_VOLT_MAX_9_8_MASK 0x3
#define BANK_0_RG_LBAT_VOLT_MAX_9_8_SHIFT 0x0

#define BANK_0_RG_LBAT_IRQ_EN_MAX_MASK 0x1
#define BANK_0_RG_LBAT_IRQ_EN_MAX_SHIFT 0x4

#define BANK_0_RG_LBAT_EN_MAX_MASK 0x1
#define BANK_0_RG_LBAT_EN_MAX_SHIFT 0x7

#define BANK_0_RG_LBAT_VOLT_MIN_7_0_MASK 0xFF
#define BANK_0_RG_LBAT_VOLT_MIN_7_0_SHIFT 0x0

#define BANK_0_RG_LBAT_VOLT_MIN_9_8_MASK 0x3
#define BANK_0_RG_LBAT_VOLT_MIN_9_8_SHIFT 0x0

#define BANK_0_RG_LBAT_IRQ_EN_MIN_MASK 0x1
#define BANK_0_RG_LBAT_IRQ_EN_MIN_SHIFT 0x4

#define BANK_0_RG_LBAT_EN_MIN_MASK 0x1
#define BANK_0_RG_LBAT_EN_MIN_SHIFT 0x7

#define BANK_0_RG_LBAT_MAX_IRQ_B_MASK 0x1
#define BANK_0_RG_LBAT_MAX_IRQ_B_SHIFT 0x7

#define BANK_0_RG_LBAT_MIN_IRQ_B_MASK 0x1
#define BANK_0_RG_LBAT_MIN_IRQ_B_SHIFT 0x6

#define BANK_0_RG_DA_DAC_7_0_MASK 0xFF
#define BANK_0_RG_DA_DAC_7_0_SHIFT 0x0

#define BANK_0_RG_DA_DAC_9_8_MASK 0x3
#define BANK_0_RG_DA_DAC_9_8_SHIFT 0x0

#define BANK_0_RG_NI_COMP_MASK 0x1
#define BANK_0_RG_NI_COMP_SHIFT 0x7

#define BANK_0_RG_AUXADC_RSV_MASK 0x7
#define BANK_0_RG_AUXADC_RSV_SHIFT 0x5

#define BANK_0_RG_DA_DAC_SEL_MASK 0x1
#define BANK_0_RG_DA_DAC_SEL_SHIFT 0x4

#define BANK_0_RG_AUX_OUT_SEL_MASK 0x1
#define BANK_0_RG_AUX_OUT_SEL_SHIFT 0x3

#define BANK_0_RG_ARB_PRIO_2_MASK 0x1
#define BANK_0_RG_ARB_PRIO_2_SHIFT 0x2

#define BANK_0_RG_ARB_PRIO_1_MASK 0x1
#define BANK_0_RG_ARB_PRIO_1_SHIFT 0x1

#define BANK_0_RG_ARB_PRIO_0_MASK 0x1
#define BANK_0_RG_ARB_PRIO_0_SHIFT 0x0

#define BANK_0_RG_AUXADC_CALI_MASK 0x3
#define BANK_0_RG_AUXADC_CALI_SHIFT 0x4

#define BANK_0_RG_BUF_CALI_MASK 0x3
#define BANK_0_RG_BUF_CALI_SHIFT 0x0

//==============================================================================
// PMIC6329 BANK 1
//==============================================================================
#define BANK_1_RG_MON_GRP_SEL_MASK 0xF
#define BANK_1_RG_MON_GRP_SEL_SHIFT 0x0

#define BANK_1_RG_MON_FLAG_SEL_MASK 0xFF
#define BANK_1_RG_MON_FLAG_SEL_SHIFT 0x0

#define BANK_1_RG_IO_PASEL0_SEL_MASK 0xF
#define BANK_1_RG_IO_PASEL0_SEL_SHIFT 0x4

#define BANK_1_RG_IO_PASEL1_SEL_MASK 0xF
#define BANK_1_RG_IO_PASEL1_SEL_SHIFT 0x0

#define BANK_1_RG_IO_PASEL2_SEL_MASK 0xF
#define BANK_1_RG_IO_PASEL2_SEL_SHIFT 0x4

#define BANK_1_RG_IO_INT_SEL_MASK 0xF
#define BANK_1_RG_IO_INT_SEL_SHIFT 0x0

#define BANK_1_RG_DIO_SMT_MASK 0x1
#define BANK_1_RG_DIO_SMT_SHIFT 0x5

#define BANK_1_RG_DIO_E2_MASK 0x1
#define BANK_1_RG_DIO_E2_SHIFT 0x4

#define BANK_1_RG_DIO_E4_MASK 0x1
#define BANK_1_RG_DIO_E4_SHIFT 0x3

#define BANK_1_RG_DIO_SR_MASK 0x1
#define BANK_1_RG_DIO_SR_SHIFT 0x2

#define BANK_1_RG_SCK_PU_MASK 0x1
#define BANK_1_RG_SCK_PU_SHIFT 0x1

#define BANK_1_RG_SCK_PD_MASK 0x1
#define BANK_1_RG_SCK_PD_SHIFT 0x0

#define BANK_1_RG_SDA_E2_MASK 0x1
#define BANK_1_RG_SDA_E2_SHIFT 0x7

#define BANK_1_RG_SDA_E4_MASK 0x1
#define BANK_1_RG_SDA_E4_SHIFT 0x6

#define BANK_1_RG_SDA_PU_MASK 0x1
#define BANK_1_RG_SDA_PU_SHIFT 0x5

#define BANK_1_RG_SDA_PD_MASK 0x1
#define BANK_1_RG_SDA_PD_SHIFT 0x4

#define BANK_1_RG_INT_E2_MASK 0x1
#define BANK_1_RG_INT_E2_SHIFT 0x3

#define BANK_1_RG_INT_E4_MASK 0x1
#define BANK_1_RG_INT_E4_SHIFT 0x2

#define BANK_1_RG_INT_PU_MASK 0x1
#define BANK_1_RG_INT_PU_SHIFT 0x1

#define BANK_1_RG_INT_PD_MASK 0x1
#define BANK_1_RG_INT_PD_SHIFT 0x0

#define BANK_1_RG_DVS_PU_MASK 0x1
#define BANK_1_RG_DVS_PU_SHIFT 0x5

#define BANK_1_RG_DVS_PD_MASK 0x1
#define BANK_1_RG_DVS_PD_SHIFT 0x4

#define BANK_1_RG_PASEL_PU_MASK 0x1
#define BANK_1_RG_PASEL_PU_SHIFT 0x3

#define BANK_1_RG_PASEL_PD_MASK 0x1
#define BANK_1_RG_PASEL_PD_SHIFT 0x2

#define BANK_1_RG_SYSRSTB_PU_MASK 0x1
#define BANK_1_RG_SYSRSTB_PU_SHIFT 0x1

#define BANK_1_RG_SYSRSTB_PD_MASK 0x1
#define BANK_1_RG_SYSRSTB_PD_SHIFT 0x0

#define BANK_1_RG_SRCLKEN_PU_MASK 0x1
#define BANK_1_RG_SRCLKEN_PU_SHIFT 0x3

#define BANK_1_RG_SRCLKEN_PD_MASK 0x1
#define BANK_1_RG_SRCLKEN_PD_SHIFT 0x2

#define BANK_1_RG_BL_PWM_PU_MASK 0x1
#define BANK_1_RG_BL_PWM_PU_SHIFT 0x1

#define BANK_1_RG_BL_PWM_PD_MASK 0x1
#define BANK_1_RG_BL_PWM_PD_SHIFT 0x0

#define BANK_1_RG_TEST_RSV_MASK 0x1
#define BANK_1_RG_TEST_RSV_SHIFT 0x3

#define BANK_1_RG_TEST_STRUP_MASK 0x1
#define BANK_1_RG_TEST_STRUP_SHIFT 0x2

#define BANK_1_RG_OTP_W_MODE_MASK 0x1
#define BANK_1_RG_OTP_W_MODE_SHIFT 0x1

#define BANK_1_RG_NANDTREE_MODE_MASK 0x1
#define BANK_1_RG_NANDTREE_MODE_SHIFT 0x0

#define BANK_1_RG_TEST_AUXADC_MASK 0x1
#define BANK_1_RG_TEST_AUXADC_SHIFT 0x7

#define BANK_1_RG_TEST_FGPLL_MASK 0x1
#define BANK_1_RG_TEST_FGPLL_SHIFT 0x6

#define BANK_1_RG_TEST_FG1_MASK 0x1
#define BANK_1_RG_TEST_FG1_SHIFT 0x5

#define BANK_1_RG_TEST_FG2_MASK 0x1
#define BANK_1_RG_TEST_FG2_SHIFT 0x4

#define BANK_1_RG_TEST_IO_FG_SEL_MASK 0x1
#define BANK_1_RG_TEST_IO_FG_SEL_SHIFT 0x3

#define BANK_1_RG_TEST_CLASSD_MASK 0x1
#define BANK_1_RG_TEST_CLASSD_SHIFT 0x2

#define BANK_1_RG_TEST_DRIVER_MASK 0x1
#define BANK_1_RG_TEST_DRIVER_SHIFT 0x1

#define BANK_1_RG_TEST_BOOST_MASK 0x1
#define BANK_1_RG_TEST_BOOST_SHIFT 0x0

#define BANK_1_RO_MON_MASK 0xFF
#define BANK_1_RO_MON_SHIFT 0x0

#define BANK_1_RO_DVS1_IN_MASK 0x1
#define BANK_1_RO_DVS1_IN_SHIFT 0x7

#define BANK_1_RO_DVS2_IN_MASK 0x1
#define BANK_1_RO_DVS2_IN_SHIFT 0x6

#define BANK_1_RO_PASEL0_IN_MASK 0x1
#define BANK_1_RO_PASEL0_IN_SHIFT 0x5

#define BANK_1_RO_PASEL1_IN_MASK 0x1
#define BANK_1_RO_PASEL1_IN_SHIFT 0x4

#define BANK_1_RO_PASEL2_IN_MASK 0x1
#define BANK_1_RO_PASEL2_IN_SHIFT 0x3

#define BANK_1_RO_SYSRSTB_IN_MASK 0x1
#define BANK_1_RO_SYSRSTB_IN_SHIFT 0x2

#define BANK_1_RO_SRCLKEN_IN_MASK 0x1
#define BANK_1_RO_SRCLKEN_IN_SHIFT 0x1

#define BANK_1_RO_BLPWM_IN_MASK 0x1
#define BANK_1_RO_BLPWM_IN_SHIFT 0x0

#define BANK_1_RG_PWRKEY_RST_EN_MASK 0x1
#define BANK_1_RG_PWRKEY_RST_EN_SHIFT 0x4

#define BANK_1_RG_HOMEKEY_RST_EN_MASK 0x1
#define BANK_1_RG_HOMEKEY_RST_EN_SHIFT 0x3

#define BANK_1_RG_PWRKEY_RST_TD_MASK 0x3
#define BANK_1_RG_PWRKEY_RST_TD_SHIFT 0x1

#define BANK_1_RG_PWRRST_TMR_DIS_MASK 0x1
#define BANK_1_RG_PWRRST_TMR_DIS_SHIFT 0x0

#define BANK_1_RG_RST_PART_SEL_MASK 0x1
#define BANK_1_RG_RST_PART_SEL_SHIFT 0x7

#define BANK_1_RG_OTP_MAN_RST_MASK 0x1
#define BANK_1_RG_OTP_MAN_RST_SHIFT 0x5

#define BANK_1_RG_PCHR_MAN_RST_EN_MASK 0x1
#define BANK_1_RG_PCHR_MAN_RST_EN_SHIFT 0x4

#define BANK_1_RG_PCHR_MAN_RST_MASK 0x1
#define BANK_1_RG_PCHR_MAN_RST_SHIFT 0x3

#define BANK_1_RG_STRUP_MAN_RST_EN_MASK 0x1
#define BANK_1_RG_STRUP_MAN_RST_EN_SHIFT 0x2

#define BANK_1_RG_SIF_TST_CK_DIS_MASK 0x1
#define BANK_1_RG_SIF_TST_CK_DIS_SHIFT 0x1

#define BANK_1_RG_SYSRSTB_EN_MASK 0x1
#define BANK_1_RG_SYSRSTB_EN_SHIFT 0x0

#define BANK_1_RG_75K_EXT_SEL_MASK 0x1
#define BANK_1_RG_75K_EXT_SEL_SHIFT 0x7

#define BANK_1_RG_FG_TST_CK_SEL_MASK 0x1
#define BANK_1_RG_FG_TST_CK_SEL_SHIFT 0x6

#define BANK_1_RG_CHR1M_TST_CK_SEL_MASK 0x1
#define BANK_1_RG_CHR1M_TST_CK_SEL_SHIFT 0x5

#define BANK_1_RG_CLK_TST_MASK 0x1
#define BANK_1_RG_CLK_TST_SHIFT 0x4

#define BANK_1_RG_AUXADC_CK_RST_MASK 0x1
#define BANK_1_RG_AUXADC_CK_RST_SHIFT 0x3

#define BANK_1_RG_AUXADC_CK_SEL_MASK 0x7
#define BANK_1_RG_AUXADC_CK_SEL_SHIFT 0x0

#define BANK_1_RG_FGADC_CK_PDN_MASK 0x1
#define BANK_1_RG_FGADC_CK_PDN_SHIFT 0x4

#define BANK_1_RG_OTPC_CK_PDN_MASK 0x1
#define BANK_1_RG_OTPC_CK_PDN_SHIFT 0x3

#define BANK_1_RG_BST_DRV_CK_PDN_MASK 0x1
#define BANK_1_RG_BST_DRV_CK_PDN_SHIFT 0x2

#define BANK_1_RG_SPK_CK_PDN_MASK 0x1
#define BANK_1_RG_SPK_CK_PDN_SHIFT 0x1

#define BANK_1_RG_PWMOC_CK_PDN_MASK 0x1
#define BANK_1_RG_PWMOC_CK_PDN_SHIFT 0x0

#define BANK_1_OC_GEAR_BVALID_DET_MASK 0x3
#define BANK_1_OC_GEAR_BVALID_DET_SHIFT 0x6

#define BANK_1_OC_GEAR_VBATON_UNDET_MASK 0x3
#define BANK_1_OC_GEAR_VBATON_UNDET_SHIFT 0x4

#define BANK_1_OC_GEAR_LDO_MASK 0x3
#define BANK_1_OC_GEAR_LDO_SHIFT 0x0

#define BANK_1_RG_INT_RSV_MASK 0x1F
#define BANK_1_RG_INT_RSV_SHIFT 0x3

#define BANK_1_POLARITY_BVALID_DET_MASK 0x1
#define BANK_1_POLARITY_BVALID_DET_SHIFT 0x2

#define BANK_1_POLARITY_VBATON_UNDET_MASK 0x1
#define BANK_1_POLARITY_VBATON_UNDET_SHIFT 0x1

#define BANK_1_POLARITY_MASK 0x1
#define BANK_1_POLARITY_SHIFT 0x0

#define BANK_1_VPA_OC_WND_MASK 0x3
#define BANK_1_VPA_OC_WND_SHIFT 0x6

#define BANK_1_VPA_OC_THD_MASK 0x3
#define BANK_1_VPA_OC_THD_SHIFT 0x4

#define BANK_1_VRF18_OC_WND_MASK 0x3
#define BANK_1_VRF18_OC_WND_SHIFT 0x2

#define BANK_1_VRF18_OC_THD_MASK 0x3
#define BANK_1_VRF18_OC_THD_SHIFT 0x0

#define BANK_1_FLASH_RSV0_MASK 0x7
#define BANK_1_FLASH_RSV0_SHIFT 0x5

#define BANK_1_FLASH_DIM_DUTY_MASK 0x1F
#define BANK_1_FLASH_DIM_DUTY_SHIFT 0x0

#define BANK_1_FLASH_THER_SHDN_EN_MASK 0x1
#define BANK_1_FLASH_THER_SHDN_EN_SHIFT 0x1

#define BANK_1_FLASH_EN_MASK 0x1
#define BANK_1_FLASH_EN_SHIFT 0x0

#define BANK_1_FLASH_DIM_DIV_MASK 0xFF
#define BANK_1_FLASH_DIM_DIV_SHIFT 0x0

#define BANK_1_FLASH_RSV1_MASK 0x1F
#define BANK_1_FLASH_RSV1_SHIFT 0x3

#define BANK_1_FLASH_SEL_MASK 0x7
#define BANK_1_FLASH_SEL_SHIFT 0x0

#define BANK_1_FLASH_SFSTREN_MASK 0x1
#define BANK_1_FLASH_SFSTREN_SHIFT 0x7

#define BANK_1_FLASH_SFSTR_MASK 0x3
#define BANK_1_FLASH_SFSTR_SHIFT 0x4

#define BANK_1_FLASH_MODE_MASK 0x1
#define BANK_1_FLASH_MODE_SHIFT 0x0

#define BANK_1_KPLED_RSV0_MASK 0x7
#define BANK_1_KPLED_RSV0_SHIFT 0x5

#define BANK_1_KPLED_DIM_DUTY_MASK 0x1F
#define BANK_1_KPLED_DIM_DUTY_SHIFT 0x0

#define BANK_1_KPLED_THER_SHDN_EN_MASK 0x1
#define BANK_1_KPLED_THER_SHDN_EN_SHIFT 0x1

#define BANK_1_KPLED_EN_MASK 0x1
#define BANK_1_KPLED_EN_SHIFT 0x0

#define BANK_1_KPLED_DIM_DIV_MASK 0xFF
#define BANK_1_KPLED_DIM_DIV_SHIFT 0x0

#define BANK_1_KPLED_RSV1_MASK 0x1F
#define BANK_1_KPLED_RSV1_SHIFT 0x3

#define BANK_1_KPLED_SEL_MASK 0x7
#define BANK_1_KPLED_SEL_SHIFT 0x0

#define BANK_1_KPLED_SFSTREN_MASK 0x1
#define BANK_1_KPLED_SFSTREN_SHIFT 0x7

#define BANK_1_KPLED_SFSTR_MASK 0x3
#define BANK_1_KPLED_SFSTR_SHIFT 0x4

#define BANK_1_KPLED_MODE_MASK 0x1
#define BANK_1_KPLED_MODE_SHIFT 0x0

#define BANK_1_ISINK_RSV0_MASK 0x7
#define BANK_1_ISINK_RSV0_SHIFT 0x5

#define BANK_1_ISINK_DIM0_DUTY_MASK 0xF
#define BANK_1_ISINK_DIM0_DUTY_SHIFT 0x0

#define BANK_1_ISINK_DIM0_FSEL_MASK 0x1F
#define BANK_1_ISINK_DIM0_FSEL_SHIFT 0x0

#define BANK_1_ISINK_RSV1_MASK 0x7
#define BANK_1_ISINK_RSV1_SHIFT 0x5

#define BANK_1_ISINK_DIM1_DUTY_MASK 0x1F
#define BANK_1_ISINK_DIM1_DUTY_SHIFT 0x0

#define BANK_1_ISINK_DIM1_FSEL_MASK 0x1F
#define BANK_1_ISINK_DIM1_FSEL_SHIFT 0x0

#define BANK_1_ISINK_RSV2_MASK 0x7
#define BANK_1_ISINK_RSV2_SHIFT 0x5

#define BANK_1_ISINK_DIM2_DUTY_MASK 0x1F
#define BANK_1_ISINK_DIM2_DUTY_SHIFT 0x0

#define BANK_1_ISINK_DIM2_FSEL_MASK 0x1F
#define BANK_1_ISINK_DIM2_FSEL_SHIFT 0x0

#define BANK_1_ISINK_RSV3_MASK 0x3
#define BANK_1_ISINK_RSV3_SHIFT 0x6

#define BANK_1_ISINKS_CH5_EN_MASK 0x1
#define BANK_1_ISINKS_CH5_EN_SHIFT 0x5

#define BANK_1_ISINKS_CH4_EN_MASK 0x1
#define BANK_1_ISINKS_CH4_EN_SHIFT 0x4

#define BANK_1_ISINKS_CH3_EN_MASK 0x1
#define BANK_1_ISINKS_CH3_EN_SHIFT 0x3

#define BANK_1_ISINKS_CH2_EN_MASK 0x1
#define BANK_1_ISINKS_CH2_EN_SHIFT 0x2

#define BANK_1_ISINKS_CH1_EN_MASK 0x1
#define BANK_1_ISINKS_CH1_EN_SHIFT 0x1

#define BANK_1_ISINKS_CH0_EN_MASK 0x1
#define BANK_1_ISINKS_CH0_EN_SHIFT 0x0

#define BANK_1_ISINK_RSV4_MASK 0x3
#define BANK_1_ISINK_RSV4_SHIFT 0x6

#define BANK_1_ISINKS_CH5_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH5_CABC_EN_SHIFT 0x5

#define BANK_1_ISINKS_CH4_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH4_CABC_EN_SHIFT 0x4

#define BANK_1_ISINKS_CH3_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH3_CABC_EN_SHIFT 0x3

#define BANK_1_ISINKS_CH2_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH2_CABC_EN_SHIFT 0x2

#define BANK_1_ISINKS_CH1_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH1_CABC_EN_SHIFT 0x1

#define BANK_1_ISINKS_CH0_CABC_EN_MASK 0x1
#define BANK_1_ISINKS_CH0_CABC_EN_SHIFT 0x0

#define BANK_1_ISINKS_CH0_STEP_MASK 0x7
#define BANK_1_ISINKS_CH0_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH0_MODE_MASK 0x3
#define BANK_1_ISINKS_CH0_MODE_SHIFT 0x0

#define BANK_1_ISINKS_CH1_STEP_MASK 0x7
#define BANK_1_ISINKS_CH1_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH1_MODE_MASK 0x3
#define BANK_1_ISINKS_CH1_MODE_SHIFT 0x0

#define BANK_1_ISINKS_CH2_STEP_MASK 0x7
#define BANK_1_ISINKS_CH2_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH2_MODE_MASK 0x3
#define BANK_1_ISINKS_CH2_MODE_SHIFT 0x0

#define BANK_1_ISINKS_CH3_STEP_MASK 0x7
#define BANK_1_ISINKS_CH3_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH3_MODE_MASK 0x3
#define BANK_1_ISINKS_CH3_MODE_SHIFT 0x0

#define BANK_1_ISINKS_CH4_STEP_MASK 0x7
#define BANK_1_ISINKS_CH4_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH4_MODE_MASK 0x3
#define BANK_1_ISINKS_CH4_MODE_SHIFT 0x0

#define BANK_1_ISINKS_CH5_STEP_MASK 0x7
#define BANK_1_ISINKS_CH5_STEP_SHIFT 0x4

#define BANK_1_ISINKS_CH5_MODE_MASK 0x3
#define BANK_1_ISINKS_CH5_MODE_SHIFT 0x0

#define BANK_1_IBIAS_TRIM_EN_MASK 0x1
#define BANK_1_IBIAS_TRIM_EN_SHIFT 0x6

#define BANK_1_ISINKS_VREF_CAL_MASK 0x1F
#define BANK_1_ISINKS_VREF_CAL_SHIFT 0x0

#define BANK_1_ISINK_RSV5_MASK 0xF
#define BANK_1_ISINK_RSV5_SHIFT 0x4

#define BANK_1_ISINKS_RSV_MASK 0xF
#define BANK_1_ISINKS_RSV_SHIFT 0x0

#define BANK_1_DRV_RSV0_MASK 0xFF
#define BANK_1_DRV_RSV0_SHIFT 0x0

#define BANK_1_BOOST_ISINK_HW_SEL_MASK 0x1
#define BANK_1_BOOST_ISINK_HW_SEL_SHIFT 0x7

#define BANK_1_BOOST_MODE_MASK 0x3
#define BANK_1_BOOST_MODE_SHIFT 0x4

#define BANK_1_BOOST_CABC_EN_MASK 0x1
#define BANK_1_BOOST_CABC_EN_SHIFT 0x2

#define BANK_1_BOOST_EN_MASK 0x1
#define BANK_1_BOOST_EN_SHIFT 0x0

#define BANK_1_BOOST_SR_NMOS_MASK 0x3
#define BANK_1_BOOST_SR_NMOS_SHIFT 0x6

#define BANK_1_BOOST_VRSEL_MASK 0xF
#define BANK_1_BOOST_VRSEL_SHIFT 0x0

#define BANK_1_BOOST_RC_MASK 0x3
#define BANK_1_BOOST_RC_SHIFT 0x4

#define BANK_1_BOOST_CS_MASK 0x3
#define BANK_1_BOOST_CS_SHIFT 0x2

#define BANK_1_BOOST_CC_MASK 0x3
#define BANK_1_BOOST_CC_SHIFT 0x0

#define BANK_1_BOOST_SLP_MASK 0x3
#define BANK_1_BOOST_SLP_SHIFT 0x2

#define BANK_1_BOOST_CL_MASK 0x3
#define BANK_1_BOOST_CL_SHIFT 0x0

#define BANK_1_BOOST_SS_MASK 0x7
#define BANK_1_BOOST_SS_SHIFT 0x4

#define BANK_1_BOOST_RSV_MASK 0xF
#define BANK_1_BOOST_RSV_SHIFT 0x0

#define BANK_1_SPK_THER_SHDN_L_EN_MASK 0x1
#define BANK_1_SPK_THER_SHDN_L_EN_SHIFT 0x6

#define BANK_1_SPK_TRIM_EN_L_MASK 0x1
#define BANK_1_SPK_TRIM_EN_L_SHIFT 0x4

#define BANK_1_SPKMODE_L_MASK 0x1
#define BANK_1_SPKMODE_L_SHIFT 0x2

#define BANK_1_SPK_EN_L_MASK 0x1
#define BANK_1_SPK_EN_L_SHIFT 0x0

#define BANK_1_SPK_OC_EN_L_MASK 0x1
#define BANK_1_SPK_OC_EN_L_SHIFT 0x7

#define BANK_1_SPKAB_OC_EN_L_MASK 0x1
#define BANK_1_SPKAB_OC_EN_L_SHIFT 0x6

#define BANK_1_SPK_OC_SHDN_DL_MASK 0x1
#define BANK_1_SPK_OC_SHDN_DL_SHIFT 0x4

#define BANK_1_SPK_VOL_L_MASK 0x7
#define BANK_1_SPK_VOL_L_SHIFT 0x0

#define BANK_1_SPK_RSV0_MASK 0x3F
#define BANK_1_SPK_RSV0_SHIFT 0x2

#define BANK_1_SPK_AB_OC_L_DEG_MASK 0x1
#define BANK_1_SPK_AB_OC_L_DEG_SHIFT 0x1

#define BANK_1_SPK_D_OC_L_DEG_MASK 0x1
#define BANK_1_SPK_D_OC_L_DEG_SHIFT 0x0

#define BANK_1_SPK_OFFSET_L_OV_MASK 0x1
#define BANK_1_SPK_OFFSET_L_OV_SHIFT 0x7

#define BANK_1_SPK_OFFSET_L_MODE_MASK 0x1
#define BANK_1_SPK_OFFSET_L_MODE_SHIFT 0x6

#define BANK_1_SPK_LEAD_L_SW_MASK 0x1
#define BANK_1_SPK_LEAD_L_SW_SHIFT 0x5

#define BANK_1_SPK_OFFSET_L_SW_MASK 0x1F
#define BANK_1_SPK_OFFSET_L_SW_SHIFT 0x0

#define BANK_1_SPK_TRIM_DONE_L_MASK 0x1
#define BANK_1_SPK_TRIM_DONE_L_SHIFT 0x7

#define BANK_1_SPK_LEAD_L_FLAG_MASK 0x1
#define BANK_1_SPK_LEAD_L_FLAG_SHIFT 0x6

#define BANK_1_SPK_LEAD_L_FLAG_DEG_MASK 0x1
#define BANK_1_SPK_LEAD_L_FLAG_DEG_SHIFT 0x5

#define BANK_1_SPK_OFFSET_L_MASK 0x1F
#define BANK_1_SPK_OFFSET_L_SHIFT 0x0

#define BANK_1_SPK_RSV1_MASK 0x1
#define BANK_1_SPK_RSV1_SHIFT 0x7

#define BANK_1_SPKRCV_EN_L_MASK 0x1
#define BANK_1_SPKRCV_EN_L_SHIFT 0x6

#define BANK_1_SPKAB_OBIAS_L_MASK 0x3
#define BANK_1_SPKAB_OBIAS_L_SHIFT 0x4

#define BANK_1_SPK_SLEW_L_MASK 0x3
#define BANK_1_SPK_SLEW_L_SHIFT 0x2

#define BANK_1_SPK_FORCE_EN_L_MASK 0x1
#define BANK_1_SPK_FORCE_EN_L_SHIFT 0x1

#define BANK_1_SPK_INTG_RST_L_MASK 0x1
#define BANK_1_SPK_INTG_RST_L_SHIFT 0x0

#define BANK_1_SPK_THER_SHDN_R_EN_MASK 0x1
#define BANK_1_SPK_THER_SHDN_R_EN_SHIFT 0x6

#define BANK_1_SPK_TRIM_EN_R_MASK 0x1
#define BANK_1_SPK_TRIM_EN_R_SHIFT 0x4

#define BANK_1_SPKMODE_R_MASK 0x1
#define BANK_1_SPKMODE_R_SHIFT 0x2

#define BANK_1_SPK_EN_R_MASK 0x1
#define BANK_1_SPK_EN_R_SHIFT 0x0

#define BANK_1_SPK_OC_EN_R_MASK 0x1
#define BANK_1_SPK_OC_EN_R_SHIFT 0x7

#define BANK_1_SPKAB_OC_EN_R_MASK 0x1
#define BANK_1_SPKAB_OC_EN_R_SHIFT 0x6

#define BANK_1_SPK_OC_SHDN_DR_MASK 0x1
#define BANK_1_SPK_OC_SHDN_DR_SHIFT 0x4

#define BANK_1_SPK_VOL_R_MASK 0x7
#define BANK_1_SPK_VOL_R_SHIFT 0x0

#define BANK_1_SPK_RSV2_MASK 0x3F
#define BANK_1_SPK_RSV2_SHIFT 0x2

#define BANK_1_SPK_AB_OC_R_DEG_MASK 0x1
#define BANK_1_SPK_AB_OC_R_DEG_SHIFT 0x1

#define BANK_1_SPK_D_OC_R_DEG_MASK 0x1
#define BANK_1_SPK_D_OC_R_DEG_SHIFT 0x0

#define BANK_1_SPK_OFFSET_R_OV_MASK 0x1
#define BANK_1_SPK_OFFSET_R_OV_SHIFT 0x7

#define BANK_1_SPK_OFFSET_R_MODE_MASK 0x1
#define BANK_1_SPK_OFFSET_R_MODE_SHIFT 0x6

#define BANK_1_SPK_LEAD_R_SW_MASK 0x1
#define BANK_1_SPK_LEAD_R_SW_SHIFT 0x5

#define BANK_1_SPK_OFFSET_R_SW_MASK 0x1F
#define BANK_1_SPK_OFFSET_R_SW_SHIFT 0x0

#define BANK_1_SPK_TRIM_DONE_R_MASK 0x1
#define BANK_1_SPK_TRIM_DONE_R_SHIFT 0x7

#define BANK_1_SPK_LEAD_R_FLAG_MASK 0x1
#define BANK_1_SPK_LEAD_R_FLAG_SHIFT 0x6

#define BANK_1_SPK_LEAD_R_FLAG_DEG_MASK 0x1
#define BANK_1_SPK_LEAD_R_FLAG_DEG_SHIFT 0x5

#define BANK_1_SPK_OFFSET_R_MASK 0x1F
#define BANK_1_SPK_OFFSET_R_SHIFT 0x0

#define BANK_1_SPK_RSV3_MASK 0x1
#define BANK_1_SPK_RSV3_SHIFT 0x7

#define BANK_1_SPKRCV_EN_R_MASK 0x1
#define BANK_1_SPKRCV_EN_R_SHIFT 0x6

#define BANK_1_SPKAB_OBIAS_R_MASK 0x3
#define BANK_1_SPKAB_OBIAS_R_SHIFT 0x4

#define BANK_1_SPK_SLEW_R_MASK 0x3
#define BANK_1_SPK_SLEW_R_SHIFT 0x2

#define BANK_1_SPK_FORCE_EN_R_MASK 0x1
#define BANK_1_SPK_FORCE_EN_R_SHIFT 0x1

#define BANK_1_SPK_INTG_RST_R_MASK 0x1
#define BANK_1_SPK_INTG_RST_R_SHIFT 0x0

#define BANK_1_SPK_OC_AUTOFF_MASK 0x1
#define BANK_1_SPK_OC_AUTOFF_SHIFT 0x3

#define BANK_1_SPK_OC_DGLH_MASK 0x3
#define BANK_1_SPK_OC_DGLH_SHIFT 0x1

#define BANK_1_SPK_OCTH_D_MASK 0x1
#define BANK_1_SPK_OCTH_D_SHIFT 0x0

#define BANK_1_SPK_OC_WND_MASK 0x3
#define BANK_1_SPK_OC_WND_SHIFT 0x4

#define BANK_1_SPK_OC_THD_MASK 0x3
#define BANK_1_SPK_OC_THD_SHIFT 0x0

#define BANK_1_SPK_TRIM_DIV_MASK 0x3
#define BANK_1_SPK_TRIM_DIV_SHIFT 0x4

#define BANK_1_SPK_TRIM_DEG_MASK 0x3
#define BANK_1_SPK_TRIM_DEG_SHIFT 0x0

#define BANK_1_SPKAB_OBIAS_MASK 0x3
#define BANK_1_SPKAB_OBIAS_SHIFT 0x6

#define BANK_1_SPKAB_FB_ATT_MASK 0x3
#define BANK_1_SPKAB_FB_ATT_SHIFT 0x2

#define BANK_1_SPKAB_OVDRV_MASK 0x1
#define BANK_1_SPKAB_OVDRV_SHIFT 0x0

#define BANK_1_SPK_FBRC_EN_MASK 0x1
#define BANK_1_SPK_FBRC_EN_SHIFT 0x6

#define BANK_1_SPK_IBIAS_SEL_MASK 0x3
#define BANK_1_SPK_IBIAS_SEL_SHIFT 0x4

#define BANK_1_SPK_VCM_IBSEL_MASK 0x1
#define BANK_1_SPK_VCM_IBSEL_SHIFT 0x3

#define BANK_1_SPK_VCM_SEL_MASK 0x1
#define BANK_1_SPK_VCM_SEL_SHIFT 0x2

#define BANK_1_SPK_EN_VIEW_CLK_MASK 0x1
#define BANK_1_SPK_EN_VIEW_CLK_SHIFT 0x1

#define BANK_1_SPK_EN_VIEW_VCM_MASK 0x1
#define BANK_1_SPK_EN_VIEW_VCM_SHIFT 0x0

#define BANK_1_SPK_CCODE_MASK 0xF
#define BANK_1_SPK_CCODE_SHIFT 0x4

#define BANK_1_SPK_BTL_SET_MASK 0x3
#define BANK_1_SPK_BTL_SET_SHIFT 0x0

#define BANK_1_SPK_RSV_MASK 0xF
#define BANK_1_SPK_RSV_SHIFT 0x0

#define BANK_1_SPK_TD1_MASK 0x3
#define BANK_1_SPK_TD1_SHIFT 0x4

#define BANK_1_SPK_TD2_MASK 0x3
#define BANK_1_SPK_TD2_SHIFT 0x0

#define BANK_1_SPK_DEPOP_EN_L_SW_MASK 0x1
#define BANK_1_SPK_DEPOP_EN_L_SW_SHIFT 0x7

#define BANK_1_SPK_DEPOP_EN_R_SW_MASK 0x1
#define BANK_1_SPK_DEPOP_EN_R_SW_SHIFT 0x6

#define BANK_1_SPKMODE_L_SW_MASK 0x1
#define BANK_1_SPKMODE_L_SW_SHIFT 0x5

#define BANK_1_SPKMODE_R_SW_MASK 0x1
#define BANK_1_SPKMODE_R_SW_SHIFT 0x4

#define BANK_1_SPK_RST_L_SW_MASK 0x1
#define BANK_1_SPK_RST_L_SW_SHIFT 0x3

#define BANK_1_SPK_RST_R_SW_MASK 0x1
#define BANK_1_SPK_RST_R_SW_SHIFT 0x2

#define BANK_1_SPK_EN_MODE_MASK 0x1
#define BANK_1_SPK_EN_MODE_SHIFT 0x0

#define BANK_1_SPK_TRIM_EN_L_SW_MASK 0x1
#define BANK_1_SPK_TRIM_EN_L_SW_SHIFT 0x7

#define BANK_1_SPK_TRIM_EN_R_SW_MASK 0x1
#define BANK_1_SPK_TRIM_EN_R_SW_SHIFT 0x6

#define BANK_1_SPK_OUTSTG_EN_L_SW_MASK 0x1
#define BANK_1_SPK_OUTSTG_EN_L_SW_SHIFT 0x5

#define BANK_1_SPK_OUTSTG_EN_R_SW_MASK 0x1
#define BANK_1_SPK_OUTSTG_EN_R_SW_SHIFT 0x4

#define BANK_1_SPK_EN_L_SW_MASK 0x1
#define BANK_1_SPK_EN_L_SW_SHIFT 0x3

#define BANK_1_SPK_EN_R_SW_MASK 0x1
#define BANK_1_SPK_EN_R_SW_SHIFT 0x2

#define BANK_1_SPK_VCM_FAST_SW_MASK 0x1
#define BANK_1_SPK_VCM_FAST_SW_SHIFT 0x0

#define BANK_1_SPK_TRIM_STOP_L_SW_MASK 0x1
#define BANK_1_SPK_TRIM_STOP_L_SW_SHIFT 0x1

#define BANK_1_SPK_TRIM_STOP_R_SW_MASK 0x1
#define BANK_1_SPK_TRIM_STOP_R_SW_SHIFT 0x0

#define BANK_1_RG_ANA_SW_SEL_MASK 0x1
#define BANK_1_RG_ANA_SW_SEL_SHIFT 0x0

#define BANK_1_FGPLL_PDIV1_MASK 0xF
#define BANK_1_FGPLL_PDIV1_SHIFT 0x4

#define BANK_1_FGPLL_PDIV1_EN_MASK 0x1
#define BANK_1_FGPLL_PDIV1_EN_SHIFT 0x3

#define BANK_1_FGPLL_BS_RST_MASK 0x1
#define BANK_1_FGPLL_BS_RST_SHIFT 0x1

#define BANK_1_FGPLL_EN_MASK 0x1
#define BANK_1_FGPLL_EN_SHIFT 0x0

#define BANK_1_FGPLL_DIV1_MASK 0x3F
#define BANK_1_FGPLL_DIV1_SHIFT 0x0

#define BANK_1_FGPLL_BC_MASK 0x3
#define BANK_1_FGPLL_BC_SHIFT 0x4

#define BANK_1_FGPLL_BP_MASK 0x3
#define BANK_1_FGPLL_BP_SHIFT 0x2

#define BANK_1_FGPLL_BR_MASK 0x3
#define BANK_1_FGPLL_BR_SHIFT 0x0

#define BANK_1_FGPLL_CDIV_MASK 0x7
#define BANK_1_FGPLL_CDIV_SHIFT 0x5

#define BANK_1_FGPLL_VCOBAND_MASK 0x7
#define BANK_1_FGPLL_VCOBAND_SHIFT 0x2

#define BANK_1_FGPLL_CKO_SEL_MASK 0x3
#define BANK_1_FGPLL_CKO_SEL_SHIFT 0x0

#define BANK_1_FGPLL_IBSEL_MASK 0x3
#define BANK_1_FGPLL_IBSEL_SHIFT 0x6

#define BANK_1_FGPLL_RLATCH_EN_MASK 0x1
#define BANK_1_FGPLL_RLATCH_EN_SHIFT 0x5

#define BANK_1_FGPLL_CKDRV_EN_MASK 0x1
#define BANK_1_FGPLL_CKDRV_EN_SHIFT 0x4

#define BANK_1_FGPLL_VCT_EN_MASK 0x1
#define BANK_1_FGPLL_VCT_EN_SHIFT 0x3

#define BANK_1_FGPLL_CKT_SEL_MASK 0x3
#define BANK_1_FGPLL_CKT_SEL_SHIFT 0x1

#define BANK_1_FGPLL_CKT_EN_MASK 0x1
#define BANK_1_FGPLL_CKT_EN_SHIFT 0x0

#define BANK_1_FGPLL_RSVA_MASK 0xFF
#define BANK_1_FGPLL_RSVA_SHIFT 0x0

#define BANK_1_FGPLL_RSVB_MASK 0xFF
#define BANK_1_FGPLL_RSVB_SHIFT 0x0

#define BANK_1_FG_CLKSRC_MASK 0x1
#define BANK_1_FG_CLKSRC_SHIFT 0x7

#define BANK_1_FG_AUTOCALRATE_MASK 0x7
#define BANK_1_FG_AUTOCALRATE_SHIFT 0x4

#define BANK_1_FG_CAL_MASK 0x3
#define BANK_1_FG_CAL_SHIFT 0x2

#define BANK_1_FG_VMODE_MASK 0x1
#define BANK_1_FG_VMODE_SHIFT 0x1

#define BANK_1_FG_ON_MASK 0x1
#define BANK_1_FG_ON_SHIFT 0x0

#define BANK_1_FG_SW_RSTCLR_MASK 0x1
#define BANK_1_FG_SW_RSTCLR_SHIFT 0x7

#define BANK_1_FG_CHARGE_RST_MASK 0x1
#define BANK_1_FG_CHARGE_RST_SHIFT 0x6

#define BANK_1_FG_TIME_RST_MASK 0x1
#define BANK_1_FG_TIME_RST_SHIFT 0x5

#define BANK_1_FG_OFFSET_RST_MASK 0x1
#define BANK_1_FG_OFFSET_RST_SHIFT 0x4

#define BANK_1_FG_SW_CLEAR_MASK 0x1
#define BANK_1_FG_SW_CLEAR_SHIFT 0x3

#define BANK_1_FG_LATCHDATA_ST_MASK 0x1
#define BANK_1_FG_LATCHDATA_ST_SHIFT 0x2

#define BANK_1_FG_SW_READ_PRE_MASK 0x1
#define BANK_1_FG_SW_READ_PRE_SHIFT 0x1

#define BANK_1_FG_SW_CR_MASK 0x1
#define BANK_1_FG_SW_CR_SHIFT 0x0

#define BANK_1_FG_CAR_35_32_MASK 0xF
#define BANK_1_FG_CAR_35_32_SHIFT 0x0

#define BANK_1_FG_CAR_31_24_MASK 0xFF
#define BANK_1_FG_CAR_31_24_SHIFT 0x0

#define BANK_1_FG_CAR_23_16_MASK 0xFF
#define BANK_1_FG_CAR_23_16_SHIFT 0x0

#define BANK_1_FG_CAR_15_08_MASK 0xFF
#define BANK_1_FG_CAR_15_08_SHIFT 0x0

#define BANK_1_FG_CAR_07_00_MASK 0xFF
#define BANK_1_FG_CAR_07_00_SHIFT 0x0

#define BANK_1_FG_NTER_29_24_MASK 0x3F
#define BANK_1_FG_NTER_29_24_SHIFT 0x0

#define BANK_1_FG_NTER_23_16_MASK 0xFF
#define BANK_1_FG_NTER_23_16_SHIFT 0x0

#define BANK_1_FG_NTER_15_08_MASK 0xFF
#define BANK_1_FG_NTER_15_08_SHIFT 0x0

#define BANK_1_FG_NTER_07_00_MASK 0xFF
#define BANK_1_FG_NTER_07_00_SHIFT 0x0

#define BANK_1_FG_BLTR_15_08_MASK 0xFF
#define BANK_1_FG_BLTR_15_08_SHIFT 0x0

#define BANK_1_FG_BLTR_07_00_MASK 0xFF
#define BANK_1_FG_BLTR_07_00_SHIFT 0x0

#define BANK_1_FG_BFTR_15_08_MASK 0xFF
#define BANK_1_FG_BFTR_15_08_SHIFT 0x0

#define BANK_1_FG_BFTR_07_00_MASK 0xFF
#define BANK_1_FG_BFTR_07_00_SHIFT 0x0

#define BANK_1_FG_CURRENT_OUT_15_08_MASK 0xFF
#define BANK_1_FG_CURRENT_OUT_15_08_SHIFT 0x0

#define BANK_1_FG_CURRENT_OUT_07_00_MASK 0xFF
#define BANK_1_FG_CURRENT_OUT_07_00_SHIFT 0x0

#define BANK_1_FG_ADJUST_OFFSET_VALUE_15_08_MASK 0xFF
#define BANK_1_FG_ADJUST_OFFSET_VALUE_15_08_SHIFT 0x0

#define BANK_1_FG_ADJUST_OFFSET_VALUE_07_00_MASK 0xFF
#define BANK_1_FG_ADJUST_OFFSET_VALUE_07_00_SHIFT 0x0

#define BANK_1_FG_OFFSET_15_08_MASK 0xFF
#define BANK_1_FG_OFFSET_15_08_SHIFT 0x0

#define BANK_1_FG_OFFSET_07_00_MASK 0xFF
#define BANK_1_FG_OFFSET_07_00_SHIFT 0x0

#define BANK_1_FG_RSV0_MASK 0xF
#define BANK_1_FG_RSV0_SHIFT 0x4

#define BANK_1_FG_ANALOGTEST_MASK 0xF
#define BANK_1_FG_ANALOGTEST_SHIFT 0x0

#define BANK_1_FG_SPARE_MASK 0xFF
#define BANK_1_FG_SPARE_SHIFT 0x0

#define BANK_1_FG_BLTR_BFTR_EN_MASK 0x1
#define BANK_1_FG_BLTR_BFTR_EN_SHIFT 0x7

#define BANK_1_FG_ADC_AUTORST_MASK 0x1
#define BANK_1_FG_ADC_AUTORST_SHIFT 0x6

#define BANK_1_FG_ADJ_OFFSET_EN_MASK 0x1
#define BANK_1_FG_ADJ_OFFSET_EN_SHIFT 0x4

#define BANK_1_FG_OSR_MASK 0x7
#define BANK_1_FG_OSR_SHIFT 0x0

#define BANK_1_VOL_OSR_MASK 0x7
#define BANK_1_VOL_OSR_SHIFT 0x0

#define BANK_1_FG_ADC_RSTDETECT_MASK 0x1
#define BANK_1_FG_ADC_RSTDETECT_SHIFT 0x7

#define BANK_1_FG_H_INT_STS_MASK 0x1
#define BANK_1_FG_H_INT_STS_SHIFT 0x5

#define BANK_1_FG_L_INT_STS_MASK 0x1
#define BANK_1_FG_L_INT_STS_SHIFT 0x4

#define BANK_1_VOL_FIR1BYPASS_MASK 0x1
#define BANK_1_VOL_FIR1BYPASS_SHIFT 0x2

#define BANK_1_FG_FIR2BYPASS_MASK 0x1
#define BANK_1_FG_FIR2BYPASS_SHIFT 0x1

#define BANK_1_FG_FIR1BYPASS_MASK 0x1
#define BANK_1_FG_FIR1BYPASS_SHIFT 0x0

#define BANK_1_VOL_CURRENT_OUT_15_08_MASK 0xFF
#define BANK_1_VOL_CURRENT_OUT_15_08_SHIFT 0x0

#define BANK_1_VOL_CURRENT_OUT_07_00_MASK 0xFF
#define BANK_1_VOL_CURRENT_OUT_07_00_SHIFT 0x0

#define BANK_1_FG_CIC2_15_08_MASK 0xFF
#define BANK_1_FG_CIC2_15_08_SHIFT 0x0

#define BANK_1_FG_CIC2_07_00_MASK 0xFF
#define BANK_1_FG_CIC2_07_00_SHIFT 0x0

#define BANK_1_FG_RSV1_MASK 0x7
#define BANK_1_FG_RSV1_SHIFT 0x5

#define BANK_1_FG_VMODE_SW_MASK 0x1
#define BANK_1_FG_VMODE_SW_SHIFT 0x4

#define BANK_1_FG_FGADC_EN_SW_MASK 0x1
#define BANK_1_FG_FGADC_EN_SW_SHIFT 0x3

#define BANK_1_FG_FGCAL_EN_SW_MASK 0x1
#define BANK_1_FG_FGCAL_EN_SW_SHIFT 0x2

#define BANK_1_FG_RST_SW_MASK 0x1
#define BANK_1_FG_RST_SW_SHIFT 0x1

#define BANK_1_FG_MODE_MASK 0x1
#define BANK_1_FG_MODE_SHIFT 0x0

#define BANK_1_FG_MON_MASK 0xFF
#define BANK_1_FG_MON_SHIFT 0x0

#define BANK_1_FG_RSV2_MASK 0xFF
#define BANK_1_FG_RSV2_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_7_0_MASK 0xFF
#define BANK_1_RG_OTP_PDO_7_0_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_15_8_MASK 0xFF
#define BANK_1_RG_OTP_PDO_15_8_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_23_16_MASK 0xFF
#define BANK_1_RG_OTP_PDO_23_16_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_31_24_MASK 0xFF
#define BANK_1_RG_OTP_PDO_31_24_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_39_32_MASK 0xFF
#define BANK_1_RG_OTP_PDO_39_32_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_47_40_MASK 0xFF
#define BANK_1_RG_OTP_PDO_47_40_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_55_48_MASK 0xFF
#define BANK_1_RG_OTP_PDO_55_48_SHIFT 0x0

#define BANK_1_RG_OTP_PDO_63_56_MASK 0xFF
#define BANK_1_RG_OTP_PDO_63_56_SHIFT 0x0

#define BANK_1_RG_OTP_PDIN_MASK 0xFF
#define BANK_1_RG_OTP_PDIN_SHIFT 0x0

#define BANK_1_RG_OTP_PA_MASK 0x3
#define BANK_1_RG_OTP_PA_SHIFT 0x6

#define BANK_1_RG_OTP_PTM_MASK 0x3
#define BANK_1_RG_OTP_PTM_SHIFT 0x4

#define BANK_1_RG_OTP_PWE_MASK 0x3
#define BANK_1_RG_OTP_PWE_SHIFT 0x2

#define BANK_1_RG_OTP_PPROG_MASK 0x1
#define BANK_1_RG_OTP_PPROG_SHIFT 0x1

#define BANK_1_RG_OTP_READ_MASK 0x1
#define BANK_1_RG_OTP_READ_SHIFT 0x0

#define BANK_1_RG_OTP_READ_PRD_MASK 0x3
#define BANK_1_RG_OTP_READ_PRD_SHIFT 0x6

#define BANK_1_RG_OTP_TEST_SEL_MASK 0x7
#define BANK_1_RG_OTP_TEST_SEL_SHIFT 0x5

#define BANK_1_RG_OTP_SKIP_OUT_MASK 0x1
#define BANK_1_RG_OTP_SKIP_OUT_SHIFT 0x4

#define BANK_1_RG_OTP_OUT_SEL_MASK 0x3
#define BANK_1_RG_OTP_OUT_SEL_SHIFT 0x2

#define BANK_1_RG_OTP_RSV_MASK 0x3
#define BANK_1_RG_OTP_RSV_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_7_0_MASK 0xFF
#define BANK_1_RG_OTP_VAL_7_0_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_15_8_MASK 0xFF
#define BANK_1_RG_OTP_VAL_15_8_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_23_16_MASK 0xFF
#define BANK_1_RG_OTP_VAL_23_16_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_31_24_MASK 0xFF
#define BANK_1_RG_OTP_VAL_31_24_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_39_32_MASK 0xFF
#define BANK_1_RG_OTP_VAL_39_32_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_47_40_MASK 0xFF
#define BANK_1_RG_OTP_VAL_47_40_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_55_48_MASK 0xFF
#define BANK_1_RG_OTP_VAL_55_48_SHIFT 0x0

#define BANK_1_RG_OTP_VAL_63_56_MASK 0xFF
#define BANK_1_RG_OTP_VAL_63_56_SHIFT 0x0

#define BANK_1_RG_OTP_BUSY_MASK 0x1
#define BANK_1_RG_OTP_BUSY_SHIFT 0x7

#define BANK_1_RG_OTP_VLD_MASK 0x1
#define BANK_1_RG_OTP_VLD_SHIFT 0x6

#define BANK_1_RG_OTP_READ_RDY_BYPASS_MASK 0x1
#define BANK_1_RG_OTP_READ_RDY_BYPASS_SHIFT 0x3

#define BANK_1_RG_OTP_W_LOCK_MASK 0x1
#define BANK_1_RG_OTP_W_LOCK_SHIFT 0x7

#define BANK_1_RG_OTP_W_LOCK_KEY_TOG_MASK 0x1
#define BANK_1_RG_OTP_W_LOCK_KEY_TOG_SHIFT 0x4

#define BANK_1_RG_OTP_W_LOCK_KEY_MASK 0xF
#define BANK_1_RG_OTP_W_LOCK_KEY_SHIFT 0x0

#define BANK_1_SCL_DE_MASK 0x1F
#define BANK_1_SCL_DE_SHIFT 0x0

#define BANK_1_SDIN_DE_MASK 0x1F
#define BANK_1_SDIN_DE_SHIFT 0x0

#endif // _MT6575_PMIC_UPMU_HW_H_

