/* linux/net/inet/arp.h */
#ifndef _ARP_H
#define _ARP_H

#include <linux/if_arp.h>
#include <net/neighbour.h>

#include "../../../../config/autoconf.h" //user config

#define MODEL_AND_DEVICE_NAME   "Vigor" CONFIG_MODEL

extern struct neigh_table arp_tbl;

extern void	arp_init(void);
extern int	arp_find(unsigned char *haddr, struct sk_buff *skb);
extern int	arp_ioctl(struct net *net, unsigned int cmd, void __user *arg);
extern void     arp_send(int type, int ptype, __be32 dest_ip,
			 struct net_device *dev, __be32 src_ip,
			 const unsigned char *dest_hw,
			 const unsigned char *src_hw, const unsigned char *th);
#if 1 // auto-detection
/* Function prototype for Vigor ARP packets */
extern void	vigor_arp_send(int type, int ptype, __be32 dest_ip,
	      		struct net_device *dev, __be32 src_ip,
	      		unsigned char *dest_hw, unsigned char *src_hw,
	      		unsigned char *th, unsigned char vigorop);
extern struct sk_buff * init_client_arp(int type, int ptype, __be32 dest_ip,
			   struct net_device *dev, __be32 src_ip,
			   unsigned char *dest_hw, unsigned char *src_hw,
			   unsigned char *target_hw, unsigned char vigoropcode);
extern void prepare_client_arp_packet(unsigned char *vigor_arp_hdr, char opcode, int pkt_type, unsigned short  id);
#endif
extern int	arp_bind_neighbour(struct dst_entry *dst);
extern int	arp_mc_map(__be32 addr, u8 *haddr, struct net_device *dev, int dir);
extern void	arp_ifdown(struct net_device *dev);

extern struct sk_buff *arp_create(int type, int ptype, __be32 dest_ip,
				  struct net_device *dev, __be32 src_ip,
				  const unsigned char *dest_hw,
				  const unsigned char *src_hw,
				  const unsigned char *target_hw);
extern void arp_xmit(struct sk_buff *skb);

extern const struct neigh_ops arp_broken_ops;

#endif	/* _ARP_H */
