<html>
<head>
	<title>Temperature Sensor Graph</title>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
	<meta http-equiv="Pragma" content="no-cache">
	<meta http-equiv="Expires" content="-1">
	<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
	<link rel="stylesheet" type="text/css" media="screen" href="../lib/canvaschart.css" />
	<script type="text/javascript" src="../lib/dynforms.js"></script>
	<script type="text/javascript" src="../lib/chart.js"></script>
	<script type="text/javascript" src="../lib/wz_jsgraphics.js"></script>
	<script type="text/javascript" src="../lib/jgchartpainter.js"></script>
	<script type="text/javascript" src="../lib/canvaschartpainter.js"></script>
	<script type="text/javascript" src="/lang/b28n.js"></script>
	<script type="text/javascript" src="/dtree/tool.js"></script>
	<script type="text/javascript" src="/dtree/ajax.js"></script>
	<script language="JavaScript" type="text/javascript">
	
Butterlate.setTextDomain("admin");
var f;
var bg=parent;
var aryElmt= ["iCurrentTmp", "iMaxTmp", "iMinTmp", "iAvgTmp"];
var aryLables = new Array();
var aryOrgData = new Array();
var temper_unit = 0,temper_enable = 1,cal=0.00,high_warning=0.00,low_warning=0.00;
var ymin=0,ymax=0,point=1440,interval = 11;
var aryData,aryDataShow,use_temper;
var graphicdatas,values=new Array(0);

function initLabels()
{
	aryLables = [];

	var now = new Date();
	var nowdt = now.getDate();
	var nowhh = now.getHours();
	var nowmm = now.getMinutes();
	if (parseInt(nowmm) < 10) nowmm = "0" + nowmm;
	if (parseInt(nowhh) < 10) nowhh = "0" + nowhh;
	for(i=30,j=0; i>=0; i--){
		if(i%6 == 0){
			tmp = (nowhh - j*6);
			if(tmp < 0)	tmp = tmp + 24;
			aryLables[i] = tmp + ':' + nowmm;
			j++;
		}else{
			aryLables[i] = "";
		}
	}
}
    
function showChart()
{
	var c = new Chart(document.getElementById('chart'));
	c.setDefaultType(CHART_LINE);
	c.setGridDensity(aryLables.length, interval);
	c.setVerticalRange(ymin, ymax);
	c.setHorizontalLabels( aryLables );
	c.setShowLegend(true);
	if (temper_unit == 0)
		c.add('Centigrade', '#EECC66', aryDataShow );
	else
		c.add('Fahrenheit', '#EECC66', aryDataShow );
	
	c.draw();
}

function onChgTime()
{
	bg.sltRefreshTime = getVleFromElmt(f.sltRefreshTime, 0);
	point = 60*24/bg.sltRefreshTime;

	i = 0;
	aryData = Array(0);
	while (i<aryOrgData.length) {
		aryData.push(aryOrgData[i]);
		i += parseInt(bg.sltRefreshTime);
	}
	aryDataShow = Array(0);
	for (i=0, j=0; i<point; i++) {
		if (i < (point-aryData.length))
			aryDataShow.push(ymin);
		else
			aryDataShow.push(aryData[j++]);
	}
	initLabels();
	showChart();
}
function toDecimal(x)
{
    var f = parseFloat(x);
    if (isNaN(f)) {
        return;
    }
    f = Math.round(x*100)/100;
    return f;
}
function initTranslation()
{
	var e = document.getElementById("temperTitle");
	e.innerHTML = _("parent application")+" >> "+_("temper sensor graphic");
	e = document.getElementById("tab2");
	e.innerHTML = _("temper sensor settings");
	e = document.getElementById("tab1");
	e.innerHTML = _("temper chart");
	e = document.getElementById("charttitle");
	e.innerHTML = _("temper chart");		
	e = document.getElementById("timeitval");
	e.innerHTML = _("temper time interval");
	e = document.getElementById("timeitvalunit");
	e.innerHTML = _("temer time itval unit");
	e = document.getElementById("temperrefresh");
	e.innerHTML = _("temper refresh");
	e = document.getElementById("tempercurr");
	e.innerHTML = _("temper current");
	e = document.getElementById("temperaver");
	e.innerHTML = _("temper average");
	e = document.getElementById("tempermax");
	e.innerHTML = _("temper maximum");
	e = document.getElementById("tempermin");
	e.innerHTML = _("temper minimum");
	e = document.getElementById("warning");
	e.innerHTML = _("temper sensor warning");
}
function parseContents(req)
{
	if(req.responseText == "-1"){
		graphicdatas = "";
	}else{
			graphicdatas = req.responseText;
			values=graphicdatas.split("|");
			if ( values[0]==1) {
//			values0 = "30.88,80.33;30.88,80.33;30.88,80.33;30.88,80.33";	
			var temp = values[1].split("\n");
			for (i=0,j=0; i<temp.length; i++) {
				if (temp[i] != "") {
						var val = temp[i].split(",");
						if (j == 2) {
							if (val[temper_unit] > 0)
								ymin = Math.floor((toDecimal(val[temper_unit]) + toDecimal(cal))*0.9);
							else
								ymin = Math.ceil((toDecimal(val[temper_unit]) + toDecimal(cal))*1.1);
						}
						if (j == 1) {
							if (val[temper_unit] > 0)
								ymax = Math.ceil((toDecimal(val[temper_unit]) + toDecimal(cal))*1.1);
							else
								ymax = Math.floor((toDecimal(val[temper_unit]) + toDecimal(cal))*0.9);
						}
						tmpVal = toDecimal(toDecimal(val[temper_unit]) + toDecimal(cal));
						if ( j == 0) {
							str = "";
							if (low_warning == 0 && high_warning == 0 )
								str += tmpVal;
							else if (toDecimal(low_warning) > tmpVal)
								str += "<font color=green>" +tmpVal + "</font>";
							else if (toDecimal(high_warning) < tmpVal)
								str += "<font color=red>" +tmpVal + "</font>";
							else
								str += tmpVal;
							UpdateId(aryElmt[j++], str);
						} else {
							UpdateId(aryElmt[j++], tmpVal);
						}
				}
			}
			var graphic = values[2].split("\n");
			for (i=0, j=0; i<graphic.length; i++) {
				if (graphic[i]) {
					var tmp = graphic[i].split(",");
					tmpVal = toDecimal(toDecimal(tmp[temper_unit]) + toDecimal(cal));
					aryOrgData[j++] = tmpVal;
				}
			}
		}
	}
	if (ymax != ymin  && (parseInt(ymax-ymin) < 10))
		interval = Math.floor(ymax-ymin+1);
	if ( values[0]==1) {
		showElmtById(document, "show_1");
		showElmtById(document, "show_2");
		showElmtById(document, "show_3");
		onChgTime();
	} else {
		showElmtById(document, "warning");
    }	
}
function updateLogfiledata()
{   
	var arrTemperinfo;
	f = document.frm1;
	use_temper = '<% getCfgGeneral(1, "use_temper"); %>';
	if(use_temper == '')
		use_temper = '1,0.00,0,1,0,0.00,0.00';
	if (isNaN(bg.sltRefreshTime))
		setVle2Elmt( f.sltRefreshTime, 1,  0);
	else
		setVle2Elmt( f.sltRefreshTime, bg.sltRefreshTime,  0);
	arrTemperinfo = use_temper.split(",");
	temper_unit = arrTemperinfo[2];
	temper_enable = 1;
	high_warning = arrTemperinfo[5];
	low_warning = arrTemperinfo[6];
	cal = arrTemperinfo[1];
	for (var i=0; i<4; i++) {
		showElmtByClass(document,"span","iUnit" + temper_unit + i);		
		hideElmtByClass(document,"span","iUnit" + Math.abs(1-temper_unit) + i);
	}
	initTranslation();
	loadXMLDoc("/goform/tempergraphic_dataget", parseContents);
}
function onChgAccMod(tab)
{
	if(tab == 1){
		document.location = "tempergenset.asp";
	}else if(tab == 2){
		document.location = "tempergraphic.asp";
	}
}
</script>
</head>

<body onload="updateLogfiledata()">
	<table align=center width=700 cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td id="temperTitle" class=title>Temperature Sensor Graph</td>
	</tr>
	<tr><td>
		<hr size=1>
	    <br>
		<table align=center width=100% cellspacing=0 cellpadding="2" border="0">
			<tr>
			  <td id="tab1" class="ontab" onclick="onChgAccMod(2)">Temperature Sensor Graph</td>
			  <td id="tab2" class="offtab" onclick="onChgAccMod(1)">Temperature Sensor Settings</td>
				<td width="40%" class="tabpadding">&nbsp;</td>
			</tr>
		</table><br>
		<form name="frm1">
			<table align="center" width="700" border="0" cellspacing="0" cellpadding=2 id="show_2" style="display:none">
				<tr><td id=charttitle width="50%"><b>Temperature Sensor Graph</b></td>
					<td align=right>
					<label id="timeitval">Display time interval :</label>&nbsp;<select name="sltRefreshTime" size="1" onChange=onChgTime()>
					<option value="1">1</option>
					<option value="2">2</option>
					<option value="5">5</option>
					<option value="10">10</option>
					</select>&nbsp; <label id="timeitvalunit">min(s)</label></td>
					<td align="right">|&nbsp;&nbsp;<a id=temperrefresh href="tempergraphic.asp">Refresh</a>&nbsp;&nbsp;|</td>
					</tr>
			</table>
		<table class="config" id="show_3" style="display:none">
			<tr><td>
		
			<div id="chart" class="chart" style="width: 700px; height: 300px;">
			</div>
		
			</td></tr>
		</table>
		<table width="100%" class="config1" id="show_1" style="display:none" >
				<tr><td width="25%" id="tempercurr">Current Temperature: </td>
					<td><span id="iCurrentTmp"></span><span class="iUnit00">&deg;C</span><span class="iUnit10">&deg;F</span></td>					
				</tr>
				<tr><td id="tempermax">Maximum (24 hours): </td>
					<td><span id="iMaxTmp"></span><span class="iUnit01">&deg;C</span><span class="iUnit11">&deg;F</span></td>					
				</tr>
				<tr><td id="tempermin">Minimum (24 hours): </td>
					<td><span id="iMinTmp"></span><span class="iUnit02">&deg;C</span><span class="iUnit12">&deg;F</span></td>
			    </tr>
			    <tr><td id="temperaver">Average Temperature: </td>
			    	<td><span id="iAvgTmp"></span><span class="iUnit03">&deg;C</span><span class="iUnit13">&deg;F</span></td>
			    </tr>
		 </table><br>		
	</form>
		<div id="warning" style="display:none">
		Please enable USB temperature function and insert USB temper device first.
		</div>
		</td></tr>
	</table>
					
</body>
</html>