// * -*- Mode: java; tab-width: 8; -*-
/*
 Vitesse Switch Software. 
 Copyright (c) 2002-2008 Vitesse Semiconductor Corporation "Vitesse". All Rights Reserved.
*/
// *******************************  DYNFORMS.JS  *****************************
// *
// * Author: Lars Povlsen
// *
// * --------------------------------------------------------------------------
// *
// * Description:  Client-side JavaScript functions.
// *
// * To include in HTML file use:
// *
// * <script language="javascript" type="text/javascript" src="lib/config.js"></script>
// * <script language="javascript" type="text/javascript" src="lib/dynforms.js"></script>
// *
// * --------------------------------------------------------------------------


// * --------------------------------------------------------------------------
// *  (Web) Settings access
var IP_PROTOCOL = "ip_protocol";
var IP_FMT = "IP";
var MAC_FMT = "MAC";

function settingsRefreshInterval()
{
    return 1000 * 5;
}

// * --------------------------------------------------------------------------
// *  Array generation

function genArrayInt(start, end)
{
    var a = new Array(end-start+1);
    var i;
    for(i = 0; i < a.length; i++) {
        a[i] = i + start;
    }
    return a;
}

function genArrayStr(start, end, prefix)
{
    var a = new Array(end-start+1);
    var i;
    for(i = 0; i < a.length; i++) {
        var val = String(i + start);
        a[i] = prefix ? prefix + val : val;
    }
    return a;
}

// * --------------------------------------------------------------------------
// *  Dynamic forms etc.

// Remove existing content of an element - and return it
function clearChildNodes(elem) {
    while (elem.childNodes.length > 0) {
        elem.removeChild(elem.firstChild);
    }
    return elem;
}

function addCell(tr, td, content)
{
    td.appendChild(content);    // Add content to cell
    tr.appendChild(td);         // Add cell to row
}

function CreateStyledElement(element, style, id)
{
    var elm = document.createElement(element);
    elm.id = elm.name = id;
    elm.setAttribute("class", style); // For FF
    elm.setAttribute("className", style); // For MSIE
    return elm;
}

function CreateTd(style)
{
    return CreateStyledElement("td", style);
}

function addTypedTextCell(tr, type, value, style, colspan)
{
    var cell = CreateStyledElement(type, style);
    if(colspan)
        cell.setAttribute("colSpan", colspan);
    addCell(tr, cell, document.createTextNode(value));
    return cell;
}

function addTextCellForRowspan(tr, type, value, style)
{
	var td = CreateTd(style);
	var content = document.createElement("span");
	content.innerHTML = value;
	td.appendChild(content);
	tr.appendChild(td);	
}

function addTextCell(tr, value, style, colspan)
{
    return addTypedTextCell(tr, "td", value, style, colspan);
}

function addTextHeaderCell(tr, value, style, colspan)
{
    return addTypedTextCell(tr, "th", value, style, colspan);
}

function addLabelTextCell(tr, value, style, id)
{
    var td = CreateTd(style);
    var label = document.createElement("label");
    label.setAttribute("for", id);
    addCell(td, label, document.createTextNode(value));
    tr.appendChild(td);
    return td;
}

function addCheckBoxCell(tr, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement("input");
    field.type = "checkbox";
    field.id = field.name = name;
    addCell(tr, td, field);
    if(value) {
        field.setAttribute("checked", true); // FF
        field.setAttribute("defaultChecked", true); // MSIE+W3C
    }
    return field;
}

function addSelectCell(tr, oT, oV, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addSelectCellCol(tr, oT, oV, value, style, name, colspan)
{
    var td = CreateTd(style);
    td.colSpan = colspan;
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addSelectCellHide(tr, oT, oV, value, style, name)
{
    var td = CreateTd(style);
    td.setAttribute('style', 'display:none');
    td.style.display ="none";
    var field = document.createElement('select');
    field.id = field.name = name;
    var x;
    for (x=0; x < oT.length; x++) {
        var optionItem = document.createElement('option');
        optionItem.value = oV[x];
        if(value == optionItem.value) {
            optionItem.setAttribute("selected", true);
            optionItem.setAttribute("defaultSelected", true);
        }
        optionItem.appendChild(document.createTextNode(oT[x]));
        field.appendChild(optionItem);
    }
    addCell(tr, td, field);
    return field;
}

function addInputCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    addCell(tr, td, field);
    return field;
}

function addInputAreaCell(tr, value, style, name, col_size, row_size)
{
    var td = CreateTd(style);
    var field = document.createElement('textarea');
    field.id = field.name = name;
    field.setAttribute("rows", row_size);
    field.setAttribute("cols", col_size);
    field.value = value;
    field.defaultValue = value;
    addCell(tr, td, field);
    return field;
}

function addHiddenInputCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    field.type = 'hidden';
    addCell(tr, td, field);
    return field;
}

function addPasswordCell(tr, value, style, name, size)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.type = 'password';
    field.id = field.name = name;
    field.setAttribute("size", size);
    field.setAttribute("value", value);
    field.setAttribute("defaultValue", value);
    addCell(tr, td, field);
    return field;
}

function addImageCell(tr, style, src, text)
{
    var td = CreateTd(style);
    var field = document.createElement('img');
    field.src = src;
    field.border = 0;
    field.title = field.alt = text;
    addCell(tr, td, field);
    return field;
}

function addRadioCell(tr, value, style, name, id)
{
    var td = CreateTd(style);
//    var field=document.createElement(document.all?'<input name="'+name+'">':'input');
    var field=document.createElement('input');//for IE9 compatibility issue
 
    field.id = id;
    field.name = name;
    field.type = "radio";
    field.setAttribute("value",id);
    addCell(tr, td, field);
    if (value) {
        field.setAttribute("checked", "checked");
        field.setAttribute("defaultChecked", "checked"); // MSIE+W3C
    }    
    return field;
}

function addLink(tr, style, url, text, target)
{
    // default vlaue
    var  target = (target == null) ? "" : target;


    var td = CreateStyledElement("td", style);
    var link = document.createElement("a");
    link.href = url;
    link.target = target;
    link.appendChild(document.createTextNode(text)); // Add Text
    td.appendChild(link);       // Add link to cell
    tr.appendChild(td);         // Add cell to row
}

function addHiddenParam(form, name, value)
{
    var field = document.createElement('input');
    field.type = 'hidden';
    field.id = field.name = name;
    field.value = value;
    form.appendChild(field);         // Add cell to row
    return field;
}

function addButtonCell(tr, value, style, name)
{
    var td = CreateTd(style);
    var field = document.createElement('input');
    field.id = field.name = name;
    field.type = "button";
    field.value = value;
    addCell(tr, td, field);
    return field;
}

/* URL argument extraction */


function getParamFromURL(url, name)
{
    var arg_ix = url.indexOf('?');
    if (arg_ix != -1) { 
        var args = url.substring(arg_ix+1, document.URL.length);
        var tups = args.split('&');
        var i;
        for(i = 0; i < tups.length; i++) {
            var tup = tups[i].split('=');
            if(tup.length == 2)
                if(tup[0] == name)
                    return  tup[1];
        }
    }
}

/* Update functions - previously in ajax.js */

function a2s(aText, val)
{
    if(aText[val]){
        return aText[val];
    }
    return "undefined (" + String(val) + ")";
}

function UpdateId(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.innerHTML = val;
    }
    return elm;
}

function UpdateIdValue(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.value = val;
        elm.defaultValue = val;
    }
    return elm;
}

function UpdateIdChecked(id, val)
{
    var elm = document.getElementById(id);
    if(elm) {
        elm.checked = val;
        if(val) {
            elm.setAttribute("checked", "checked");
            elm.setAttribute("defaultChecked", "checked"); // MSIE+W3C
        }
    }
    return elm;
}

function UpdateIdSelect(id, oT, oV, value)
{
    var elm = document.getElementById(id);
    if(elm) {
        clearChildNodes(elm);
        for (var x=0; x < oT.length; x++) {
            var optionItem = document.createElement('option');
            optionItem.value = oV[x];
            if(value == optionItem.value) {
                optionItem.setAttribute("selected", true);
                optionItem.setAttribute("defaultSelected", true);
            }
            optionItem.appendChild(document.createTextNode(oT[x]));
            elm.appendChild(optionItem);
        }
    }
    return elm;
}

function UpdateIdSetSelect(id, value)
{
    var elm = document.getElementById(id);
    if(elm && elm.options) {
        for (var i = 0; i < elm.options.length; i++) {
            var opt = elm.options[i];
            var sel = (opt.value == value);
            opt.selected = sel;
            opt.defaultSelected = sel;
            if (sel)
                elm.selectedIndex = i;
        }
    }
    return elm;
}

function UpdateIdGroupedSelect(id, oG, oE, sep, value)
{
    var elm = document.getElementById(id);
    if(elm) {
        clearChildNodes(elm);
        for (var g = 0; g < oG.length; g++) {
            var groupItem = document.createElement('optgroup');
            groupItem.setAttribute("label", oG[g]);
            for (var x = 0; x < oE[g].length; x++) {
                var optionItem = document.createElement('option');
                var tuple = oE[g][x].split(sep);
                optionItem.value = tuple[0];
                if(value == optionItem.value) {
                    optionItem.setAttribute("selected", true);
                    optionItem.setAttribute("defaultSelected", true);
                }
                optionItem.appendChild(document.createTextNode(tuple[1]));
                groupItem.appendChild(optionItem);
            }
            elm.appendChild(groupItem);
        }
    }
    return elm;
}

function searchArgs(search)
{
    var tups = search.substring(1).split('&');
    var args = new Array();
    for(var i = 0; i < tups.length; i++) {
        var tup = tups[i].split('=');
        if(tup.length == 2)
            args[tup[0]] = tup[1];
        else
            args[tup[0]] = 1;
    }
    return args;
}

function SetVisible(name, visible)
{
    var elm = document.getElementById(name);
    if(visible)
        elm.style.display = '';
    else
        elm.style.display = 'none';
}

function SetDisable(name, disable)
{
    var elm = document.getElementById(name);
    if(disable)
        elm.disabled = false;
    else
        elm.disabled = true;
}

function poag2portid(port)
{
    var portid = port.match(/^\d+$/) ? configPortName(port, 0) : port;
    return portid;
}

function isEqualLan( _ip1, _mask1, _ip2 )
{
	var ip1 = _ip1;
	var mask1 = _mask1;
	var ip2 = _ip2;
	var uiIp1 = inet_addr( ip1 );
	var uiMsk1 = inet_addr( mask1 );
	var uiIp2 = inet_addr( ip2 );
	if( ((Math.floor(uiIp1/0x10000) & Math.floor(uiMsk1/0x10000)) == (Math.floor(uiIp2/0x10000) & Math.floor(uiMsk1/0x10000))) &&
		((Math.floor(uiIp1%0x10000) & Math.floor(uiMsk1%0x10000)) == (Math.floor(uiIp2%0x10000) & Math.floor(uiMsk1%0x10000))) )
		return true;
	else
		return false;
}

function inet_addr( _strIp )
{
	var strIp = _strIp;
	var aryIp = strIp.split(".");
	if( aryIp.length != 4 || aryIp[3] == "" ) {
		return false;
	} else {
		for( var i=0, uiIp=0; i<4; i++) {
			if( !(aryIp[i] <= 255 && aryIp[i] >= 0) ) {
				return false;
			}
			uiIp += aryIp[i]*raisePower(256, 3-i);
		}
	}
	return uiIp;
}

function printLogo (d, bar, barStr, root) 
{
	var str = "";
	str += '<tr><td class=title>';
	switch(bar){
		case 1:
			str += TR('WAN >> ')+barStr;
			break;
		case 2:
			str += TR('LAN >> ')+barStr;
			break;
        case 3:
			str += TR('NAT >> ')+barStr;
			break;
        case 4:
			str += TR('Firewall >> ')+barStr;
			break;
        case 5:
			str += TR('Applications >> ')+barStr;
			break;
		case 6:
			str += TR('VoIP >> ')+barStr;
			break;
		case 7:
			str += TR('ISDN >> ')+barStr;
			break;
		case 8:
			str += TR('Wireless LAN >> ')+barStr;
			break;
		case 9:
			str += TR('System Maintenance >> ')+barStr;
			break;
		case 10:
			str += TR('Diagnostics >> ')+barStr;
			break;
		case 11:
			str += TR('VPN and Remote Access >> ')+barStr;
			break;
		case 12:
			str += TR('Anti-Intrusion >> ')+barStr;
			break;
		case 13:
			str += TR('Anti-Virus >> ')+barStr;
			break;
		case 14:
			str += TR('VLAN >> ')+barStr;
			break;
		case 15:
			str += TR('Certificate Management >> ')+barStr;
			break;
		case 16:
			str += TR('Objects Setting >> ')+barStr;
			break;
        case 17:
                str += TR('Web Access Control >> ')+barStr;
                break;
        case 18:
                str += TR('Bandwidth Management >> ')+barStr;
                break;
        case 19:
                str += TR('Wireless LAN >> ')+barStr;
                break;
        case 20:
                str += TR('USB Application >> ')+barStr;
                break;
        case 21:
                str += TR('IPv6 >> ')+barStr;
                break;              
        case 22:
                str += TR('SSL VPN >> ')+barStr;
                break;
         case 23:
                str += TR('CSM >> ')+barStr;
                break;              
        case 24:
                str += TR('User >> ')+barStr;
                break;                           
		case 0:
		    str +=barStr;
			break;
			
	}
	str += '</td></tr>';
 	d.writeln(str);       
}

function TR(str){return str;}
function raisePower( _x, _y )
{
	var x = _x;
	var y = _y;
	return Math.pow( x, y )
}

function adjHex(_elmt, _vle)
{
	var elmt = _elmt;
	var vle = _vle;
	if (elmt != null && elmt.value != null) {
		if (!isNaN( parseInt(elmt.value, 16))) {
			if ((elmt.value.indexOf( "0" ) == 0 && elmt.value.length == 2 &&
				parseInt(elmt.value, 16) > 0 ) || elmt.value == "00" ) {
				elmt.value = "0"+parseInt(elmt.value, 16).toString(16).toUpperCase();
			} else {
				elmt.value = parseInt(elmt.value, 16).toString(16).toUpperCase();
			}
			if ((vle != 1) && (elmt.value.length == 2)) {
				elmt.form[getIdxOfForm( elmt )+1].focus();
				elmt.form[getIdxOfForm( elmt )+1].select();
			}
		} else {
			elmt.value = "";
		}
	}
}

function getIdxOfForm( _elmt )
{
	var elmt = _elmt;
	if ( elmt.type )
	{
		for ( var i=0; i<elmt.form.length; i++ )
		{
			if(elmt.name!="" && elmt.form[i].name!=""){
				if( elmt.name == elmt.form[i].name) return i;
			}else{
				if( elmt == elmt.form[i]) return i;
			}
		}
	}
	return false;
}

function cpntCtrl( _ctrl, _frm, _fstElmt, _cnt)
{
	var ctrl = _ctrl, frm = _frm, fstElmt = _fstElmt, cnt = _cnt;
	var check;
	var tt = getIdxOfForm(fstElmt);

	/* if ctrl lose right of control */
	//if ( ctrl.disabled == true ) {
	//	return;
	//}

	if ( ctrl == true ||  ctrl == false ) {
		check = ctrl;
		for ( var i = tt; i < cnt + tt; i++ ) {
			frm[i].disabled = !check;
		}
		return;
	}

	switch ( ctrl.type ) {
		case "radio":
		case "checkbox":
			check = ctrl.checked;
			for ( var i = tt; i < cnt + tt; i++ ) {
				frm[i].disabled = !check;
			}
			break;
	} // switch
}

function getIdxbyName(_form, _name )
{
	if (!_name || _name == "") return false;
	for (var i=0; i<_form.length; i++) {
		if (_form[i].name != "" && _form[i].name == _name) return i;
	}
	return false;
}

function getVleFromElmt( _elmt, _fmt )
{
	// for IE 4 that we have to do it
	var elmt = _elmt;
	var fmt = _fmt;
	var idx = getIdxOfForm( elmt );
	switch( elmt.type )
	{
		case "button":
			break;
		case "checkbox":
			if ( elmt.checked == true )
				return "1";
			else
				return "0";
			break;
		case "radio":
			for ( var i=0; i<elmt.form.length; i++ )
				if ( elmt.name == elmt.form[i].name && (true == elmt.form[i].checked ) )
					return elmt.form[i].value;
			break;
		case "submit":
			break;
		case "text":
		case "hidden":
			if ( fmt == IP_FMT ){
				if ( mixIp( elmt ) != false ) return mixIp( elmt );
				else return "";
			}
			else if ( fmt == MAC_FMT ){
				if ( mixMac( elmt ) != false ) return mixMac( elmt );
				else return "";
			}
			else
				return elmt.value;
			break;
		case "password":
			return elmt.value;
			break;
		case "select-one":
			for ( var i=0; i<elmt.options.length; i++ )
				if ( elmt.options[i].selected == true )
				{
					//alert( "getVleFromElmt() => i:"+i+" value:"+elmt.options[i].value );
					return elmt.options[i].value;
				}
			//alert( "getVleFromElmt() => select-one error" );
			break;
		//case "hidden":
			//break;
	}
}

function mixIp( _elmt )
{
	var elmt = _elmt;
	var idx = getIdxOfForm( elmt );
	var strIp = "";
	strIp = elmt.form[idx+0].value + "." + elmt.form[idx+1].value + "." + elmt.form[idx+2].value + "." + elmt.form[idx+3].value;
	//alert ( "mixIp() => strIP:"+strIp );
	if ( isStrIp( strIp ) )
		return strIp;
	else if ( "..." == strIp )
	{
		strIp = "";
		return strIp;
	}
	else
		return false;
}

function isStrIp( _strIp )
{
	var strIp = _strIp;
	strIp += "";
	var aryIp = strIp.split(".");
	if( aryIp.length != 4 ) return false;
	else {
		for( var i=0, u32Ip=0; i<4; i++ )
		{
			if( !(aryIp[i] <= 255 && aryIp[i] >= 0) ) return false;
			u32Ip += parseInt(aryIp[i])*raisePower(256, 3-i);
		}
	}
	//alert( "isStrIp() => u32Ip:"+u32Ip );
	//if ( u32Ip > 0 && u32Ip < 0xffffffff )
	if ( u32Ip > 0 && u32Ip <= 0xffffffff ) return true;  //shirley,20050804,Mantis 2283
	else return false;
}

function mixMac(elmt)
{
	var strMac="";
	var i, j, idx;
	idx = getIdxOfForm( elmt );
	for (i=0; i<6; i++) {
		j = idx + i;
		if (elmt.form[j].value.length == 1) {
			elmt.form[j].value = "0"+elmt.form[j].value;
		}
		if(i < 5)strMac += elmt.form[j].value + "-";
		else strMac += elmt.form[j].value;
	}
	if(strMac == "-----"){
		alert(TR("Mac Address cannot be empty!"));
		return false;
	}
	else if(strMac == "00-00-00-00-00-00"){
		alert(TR("Mac Address cannot be \"00:00:00:00:00:00\"."));
		return false;
	}
	return strMac;
}

function setVle2Elmt( _elmt, _vle, _fmt )
{
	// for IE 4 that we have to do it
	var elmt = _elmt;
	var vle = _vle;
	var fmt = _fmt;
	switch( elmt.type )
	{
		case "button":
			break;
		case "checkbox":
			if ( vle > 0 || true == vle || "true" == vle || "1" == vle || "on" == vle )
				elmt.checked = true;
			else
				elmt.checked = false;
			break;
		case "radio": // Feb 20 2001, Tony
			for ( var i=0; i<elmt.form.length; i++ )
				if ( elmt.name == elmt.form[i].name && ( vle == elmt.form[i].value ) )
					elmt.form[i].checked = true;
			break;
		case "submit":
			break;
		case "text":
		case "hidden":
			if ( fmt == IP_FMT )
				spareIp( elmt, vle );
			else
				elmt.value = vle;
			break;
		case "password":
			elmt.value = vle;
			break;
		case "select-one":
			if ( fmt == IP_PROTOCOL )
			{
				if ( vle == IPPROTO_TCP )
					vle = "TCP";
				else if ( vle == IPPROTO_UDP )
					vle = "UDP";
				else if ( vle == IPPROTO_TCP_UDP )
					vle = "TCP_UDP";
				else
					vle = "";
			}
			//alert(elmt.options.length);
			/*
			if (elmt.options.length == 1 && elmt.options[0].text != "NTP (RFC-1305)")
			{
			//elmt.options[0] = new Option(vle, vle);
			elmt.options[0].text = elmt.options[0].value = vle;
			//alert(elmt.selectedIndex+"::"+elmt.options.length);
			elmt.selectedIndex = 0;
			return;
			}
			*/
			for ( var i=0; i<elmt.options.length; i++ )
			{
				if ( elmt.options[i].value == vle )
				{
					elmt.selectedIndex = i;
					elmt.options[i].selected = true;  //shirley,20050701,for mnatdmz.htm and inetdual.sht
					return;
				}
			}
			//elmt.selectedIndex  = vle;
			elmt.selectedIndex  = 0;
			break;
		case "textarea":
			elmt.value=vle;
			break;
		//case "hidden":
			//break;
	}
	return;
}

function getElmtById(doc, idVal)
{
	if(doc.getElementById != null) {
		return doc.getElementById(idVal);
	}
	if(doc.all != null) {
		return doc.all[idVal];
	}
	alert("getElmtById has problem!");
	return null;
}

function showElmtByClass(_doc, _tag, _el)
{
	var doc = _doc;
	var tag = _tag;
	var el = _el;
	if (doc.getElementsByTagName) {
		var nodes = doc.getElementsByTagName(tag);
		var max = nodes.length;
		for (var i = 0; i < max; i++) {
			var node = nodes.item(i);
			if (node.className == el) { node.style.display = ""; }
		}
	}
}

function hideElmtByClass(_doc, _tag, _el)
{
	var doc = _doc;
	var tag = _tag;
	var el = _el;
	if (doc.getElementsByTagName) {
		var nodes = doc.getElementsByTagName(tag);
		var max = nodes.length;
		for (var i = 0; i < max; i++) {
			var node = nodes.item(i);
			if (node.className == el) { node.style.display = "none"; }
		}
	}
}

function showElmtById(_doc, _el)
{
	var doc = _doc;
	var el = _el;
	getElmtById(doc, el).style.display = "";
}

function hideElmtById(_doc, _el)
{
	var doc = _doc;
	var el = _el;
	getElmtById(doc, el).style.display = "none"; 
}

function dataDec2Bin( dec )  //Convert Dec to Bin
{
    var str = dec;
    bin = parseInt(str).toString(2);
    t = "";
    for( j=0; j<8; j++ ){
        if( j>=bin.length )t = t+"0";
    }
    bin = t+bin;
    return bin;
}

function dataBin2Dec( bin )  //Convert Bin to Dec
{
    var str = bin;
    var dec = 0;
    for(i=str.length-1,j=0; i>=0; i--,j++){
        t1 = str.charAt(i);
        if( t1!="0" && t1!="1" ){
            return -1;
        }
        t2 = Math.pow(2, j);
        t3 = parseInt(t1) * parseInt(t2);
        dec = parseInt(dec) + parseInt(t3);
    }
    return dec;
}

function strFormat(str, len)
{
	str = str.toString();
	var l = checkLength(str);
	for(var i=l; i<len; i++){
		str += "\u00a0";
	}
	return str;
}

function checkLength(strTemp)
{
	var i,sum;
	sum=0;
	for(i=0;i<strTemp.length;i++)
	{
		if ((strTemp.charCodeAt(i)>=0) && (strTemp.charCodeAt(i)<=255))
			sum=sum+1;
		else
			sum=sum+2;
	}
	return sum;
}

function ShellSort(_arr, _key, _type)
{
	//var st = new Date();
	var arr = _arr;
	var key = _key;
	var tp = _type;
	var increment = arr.length;
	do {
		increment = (increment/3|0) + 1;
		arr = ShellPass(arr, increment, key, tp);
	}
	while (increment > 1)
	//status = (new Date() - st) + ' ms';
	//alert("status="+status);
	return arr;
}

function ShellPass(_arr, _d, _key, _type)
{
	var arr = _arr;
	var d = _d;
	var key = _key;
	var tp = _type;
	var iTmp1, iTmp2, aryTemp, j;
	if(!tp){
	    for(var i=d; i<arr.length; i++) {
		    iTmp1 = strParser(arr[i][key]);
		    iTmp2 = strParser(arr[i-d][key]);
		    if(iTmp1 < iTmp2) {
			    aryTemp = arr[i];
			    j = i-d;
			    do {
				    arr[j+d] = arr[j];
				    j = j-d;
			    }
			    while (j>-1 && strParser(aryTemp[key]) < strParser(arr[j][key]));
			    arr[j+d] = aryTemp;
		    }//endif
	    }
	}else{
		for(var i=d; i<arr.length; i++) {
			iTmp1 = strParser(arr[i][key]);
			iTmp2 = strParser(arr[i-d][key]);
			if(iTmp1 > iTmp2) {
				aryTemp = arr[i];
				j = i-d;
				do {
					arr[j+d] = arr[j];
					j = j-d;
				}
				while (j>-1 && strParser(aryTemp[key]) > strParser(arr[j][key]));
				arr[j+d] = aryTemp;
			}//endif
		}
	}
	return arr;
}

function strParser(_str)
{
	var str = _str;
	str = str.replace(/\s{1,}/g, "");
	str = str.replace(/\(/g, "");
	str = str.replace(/\/\d+\)/g, "");
	str = str.replace(/\/\d+/g, "");
    str = str.replace(/>/g, "");
    str = str.replace(/_[-\w]+/g, "");
	if(isStrIp(str)){
		str = inet_addr(str);
	}else if(!isNaN(parseInt(str))){
		str = parseInt(str);
	}else if(str == "---"){
		str = -1;
	}else{
		str = -2;
	}
	return str;
}

function isIPv6(str)  
{  
	if (str != "") {
		if (str.search(":") == -1) {
			return false;
		} else {
		    return str.match(/:/g).length<=7  
		    &&/::/.test(str)  
		    ?/^([\da-f]{1,4}(:|::)){1,6}[\da-f]{1,4}$/i.test(str)  
		    :/^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(str); 
		}
	} else {
		return true;
	} 
}  

function isEqualIPv6Lan( _ip1, _mask1, _ip2 )
{
	if (getSplitNum(_ip1,_mask1) == getSplitNum(_ip2,_mask1))
		return true;
	else 
		return false;
} 

function getSplitNum(ipv6, len)
{
	var aryip = Array(0);
	var tmp = ipv6.split("::");
		
	if (tmp.length == 1) {
		var tmp1 = ipv6.split(":");
		for (var i=0; i<tmp1.length; i++) {
			aryip.push(tmp1[i]);
		}
	} else {
		var tmp1 = tmp[0].split(":");
		var tmp2 = tmp[1].split(":");
		for (var i=0; i<8; i++) {
			if (i < tmp1.length) aryip.push(tmp1[i]);
			else if (i  < (8-tmp2.length)) aryip.push("0");
			else aryip.push(tmp2[i-(8-tmp2.length)]);			
		}
	}
	for (var i=0; i< aryip.length; i++)
		aryip[i] = parseInt("0x"+aryip[i]).toString(2);

	var str = "";	
	for (var i=0; i< aryip.length; i++) {
		var prefix = "";
		for (var j=0;j<(16-aryip[i].length);j++)
			prefix += "0";
		str += prefix + aryip[i];
	}
//	alert(str.substr(0,len));
	return str.substr(0,len);
}

function addCheckBoxCellCol(tr, value, style, name, colspan)
{
    var td = CreateTd(style);
    td.colSpan = colspan;
    var field = document.createElement("input");
    field.type = "checkbox";
    field.id = field.name = name;
    addCell(tr, td, field);
    if(value) {
        field.setAttribute("checked", true); // FF
        field.setAttribute("defaultChecked", true); // MSIE+W3C
    }
    return field;
}

function HttpCheck(__string) {
	var urlStyle1 = /^http:\/\/[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	var urlStyle2 = /^Http:\/\/[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	var urlStyle3 = /^[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	
	if (!urlStyle1.test(__string) && !urlStyle2.test(__string) && !urlStyle3.test(__string)){
		return false;
	}
	return true;
}

function HttpsCheck(__string) {
	var urlStyle1 = /^https:\/\/[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	var urlStyle2 = /^Https:\/\/[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	var urlStyle3 = /^[A-Za-z0-9\-]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/;
	
	if (!urlStyle1.test(__string) && !urlStyle2.test(__string) && !urlStyle3.test(__string)){
		return false;
	}
	return true;
}

function isStrNum(str) {
   var b,c,d;	
   var strByte = str;
   strByte += "";
   if( strByte.length == 0){
   	return false;
   }
   for( b = 0; b <  strByte.length ; b++){
     c = parseInt( strByte.charAt(b),10 );
     if( isNaN(c) ){
    	return false;
     }
   }
   d = parseInt( strByte ,10 );
   if ( isNaN(d) ){
    	return false;
   } 
   return true;
}

function reduseSpace ( strIP ) {
    var ss = strIP.replace(/ /,'');
    var exp1 = ss.search(/ /);
    while ( exp1 > 0 ) {
         ss = ss.replace(/ /,'');
         exp1 = ss.search(/ /);
    }
    return ss;
}

function reduseZero ( _strIP ) 
{
    var strIp = _strIP;
    strIp += "";
    var aryIp = strIp.split(".");
    if( aryIp.length != 4 ) {
        return "";
    }
    for ( var i=0; i<4 ; i++ ) {
       if ( aryIp[i].length > 3 )
           return "";
       if ( aryIp[i].length ==1 )
          continue;
       if ( aryIp[i].length == 2) {
           if ( ( aryIp[i].charAt(0) == 0 ) && ( aryIp[i].charAt(1) <= 9 && aryIp[i].charAt(1) >= 0 )   ) {
               aryIp[i] = aryIp[i].substr(1);              /* alert('1-0'); */
           }
       } else {
           if ( ( aryIp[i].charAt(0) == 0 ) && ( aryIp[i].charAt(1) == 0 )   ) {
               aryIp[i] = aryIp[i].substr(2);               /* alert('2-0'); */
           } else if ( ( aryIp[i].charAt(0) == 0 )  ) {
               aryIp[i] = aryIp[i].substr(1);               /* alert('1-0'); */
           }
       }
    }
    strIp = aryIp.join(".");
    return strIp;
}
