#!/bin/sh
# Copyright (C) 2014 DrayTek
. /sbin/config.sh
#DEBUG=echo

if [ "$CONFIG_MODEL" != "AP910C" ]; then
	return
fi

ath_RadioOff=`nvram_get 2860 RadioOff_3572`
ath_RadioOff="${ath_RadioOff:-0}"
	
wifi_wmm() {
	#WmmCapable_3572=0;0;0;0
	#APSDCapable_3572=0
	#APAifsn_3572=8;3;1;1
	#APCwmin_3572=4;4;3;2
	#APCwmax_3572=6;10;4;3
	#APTxop_3572=0;0;94;47
	#APACM_3572=0;0;0;0
	#AckPolicy_3572=0;0;0;0
	#BSSAifsn_3572=7;3;2;2
	#BSSCwmin_3572=4;4;3;2
	#BSSCwmax_3572=10;10;4;3
	#BSSTxop_3572=0;0;94;47
	#BSSACM_3572=0;0;0;0
	local ath_idx
	local idx
	
	if [ "$ath_RadioOff" == "1" ]; then 
		return
	fi

	ath_BssidNum=`nvram_get 2860 BssidNum_3572`
	ath_BssidNum="${ath_BssidNum:-1}"
	####################################### WMM parameters
	for ath_idx in 0 1 2 3; do
		[ "$ath_idx" -ge "$ath_BssidNum" ] && continue;
		idx=`expr $ath_idx + 1`	
		
		ath_wmmcap=`nvram_get 2860 WmmCapable_3572 | cut -d ';' -f$idx`
		ath_wmmcap="${ath_wmmcap:-0}"
		$DEBUG iwpriv ath$ath_idx wmm $ath_wmmcap
		ath_APSD=`nvram_get 2860 APSDCapable_3572`
		ath_APSD="${ath_APSD:-1}"
		$DEBUG iwpriv ath$ath_idx uapsd $ath_APSD
		
		if [ "$ath_wmmcap" == "1" ]; then
			for ac in 0 1 2 3; do 
				# 0  AC_BE  Best Effort 
				# 1  AC_BK  Background 
				# 2  AC_VI  Video 
				# 3  AC_VO  Voice 
				wmmidx=`expr $ac + 1`	
				wmmval=`nvram_get 2860 APAifsn_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx aifs $ac 0 ${wmmval:-0}	# 0: ap mode
				wmmval=`nvram_get 2860 BSSAifsn_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx aifs $ac 1 ${wmmval:-0}		# 1: sta mode
				
				wmmval=`nvram_get 2860 APCwmin_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx cwmin $ac 0 ${wmmval:-0}	# ap mode
				wmmval=`nvram_get 2860 BSSCwmin_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx cwmin $ac 1 ${wmmval:-0}		# sta mode
				
				wmmval=`nvram_get 2860 APCwmax_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx cwmax $ac 0 ${wmmval:-0}	# ap mode
				wmmval=`nvram_get 2860 BSSCwmax_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx cwmax $ac 1 ${wmmval:-0}		# sta mode

				wmmval=`nvram_get 2860 APTxop_3572 | cut -d ';' -f$wmmidx`
				wmmval=`expr $wmmval \* 32`		# *32 for txoplimit
				$DEBUG iwpriv ath$ath_idx txoplimit $ac 0 ${wmmval:-0}	# ap mode
				wmmval=`nvram_get 2860 BSSTxop_3572 | cut -d ';' -f$wmmidx`
				wmmval=`expr $wmmval \* 32`
				$DEBUG iwpriv ath$ath_idx txoplimit $ac 1 ${wmmval:-0}		# sta mode

				#wmmval=`nvram_get 2860 APACM_3572 | cut -d ';' -f$wmmidx`
				#$DEBUG iwpriv ath$ath_idx acm $ac 0 ${wmmval:-0}	# ap mode....ACM bit applies to BSS case only 
				wmmval=`nvram_get 2860 BSSACM_3572 | cut -d ';' -f$wmmidx`
				$DEBUG iwpriv ath$ath_idx acm $ac 1 ${wmmval:-0}		# sta mode

				wmmval=`nvram_get 2860 AckPolicy_3572 | cut -d ';' -f$wmmidx`
				if [ "$wmmval" == "1" ]; then
					$DEBUG iwpriv ath$ath_idx noackpolicy $ac 0 0	# ap mode
				else
					$DEBUG iwpriv ath$ath_idx noackpolicy $ac 0 1	# ap mode
				fi
			done
		fi
	done
}


wifi_acl() {
	local ath_idx
	
	if [ "$ath_RadioOff" == "1" ]; then 
		return
	fi	
	
	ath_BssidNum=`nvram_get 2860 BssidNum_3572`
	ath_BssidNum="${ath_BssidNum:-1}"
	for ath_idx in 0 1 2 3; do
		[ "$ath_idx" -ge "$ath_BssidNum" ] && continue;
		######################################### MAC access control 
		# AccessPolicy0_3572 0:disable 1:Active MAC 2:Block MAC
		# AccessControlList1_3572=22:22:22:22:22:22;32:22:22:22:22:22
		ath_ACL=`nvram_get 2860 AccessPolicy"$ath_idx"_3572`
		ath_ACL="${ath_ACL:-0}"
		$DEBUG iwpriv ath$ath_idx maccmd $ath_ACL
		$DEBUG iwpriv ath$ath_idx maccmd 3	#flush mac
		ath_ACList=`nvram_get 2860 AccessControlList"$ath_idx"_3572`
		ath_ACList=`echo $ath_ACList | sed -e 's/;/ /g'`
		for mac in $ath_ACList; do
			/bin/hostapd_cli -i ath$ath_idx deauthenticate $mac	# deauthenticate the mac
			$DEBUG iwpriv ath$ath_idx addmac $mac
		done
	done
}
		

wifi_updown() {

	# for atheros AR9882
	MOD=`lsmod | grep -q ^umac && echo 1 || echo 0`
	if [ "$1" == "boot" -o "$MOD" == "0" ]; then
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/adf/adf.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/asf/asf.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/os/linux/ath_hal/ath_hal.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/lmac/ratectrl/ath_rate_atheros.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/lmac/dfs/ath_dfs.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/lmac/ath_dev/ath_dev.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/umac/umac.ko
		insmod /lib/modules/2.6.36/kernel/drivers/net/wireless/atheros11ac/drivers/wlan_modules/lmac/ath_pktlog/ath_pktlog.ko
	fi

	killall hostapd

	#$DEBUG iwpriv ath0 dbgLVL 0xFFFFFFFF

	if [ "$ath_RadioOff" == "0" ]; then
		ifconfig wifi0 up
	else
		ifconfig wifi0 down
	fi

	ath_country=`nvram_get 2860 CountryCode_3572`
	ath_country=US ###################################################################### test
	ath_country="${ath_country:-US}"
	ath_channel=`nvram_get 2860 Channel_3572`
	ath_channel="${ath_channel:-0}"
	$DEBUG iwpriv wifi0 setCountry $ath_country

	ath_BssidNum=`nvram_get 2860 BssidNum_3572`
	ath_BssidNum="${ath_BssidNum:-1}"

	# multi SSID 1~4: 
	for i in 0 1 2 3; do
		ifconfig ath$i down 2>/dev/null
		/bin/wlanconfig ath$i destroy
		[ "$ath_RadioOff" == "1" -o "$i" -ge "$ath_BssidNum" ] && continue;
		
		idx=`expr $i + 1`	
		echo "Config SSID$idx:" > /dev/console
		hostapd_conf="/tmp/hostapd$idx.conf"
		rm -f $hostapd_conf 2>/dev/null
		/bin/wlanconfig ath$i create wlandev wifi0 wlanmode ap
		ifconfig ath$i up
		ath_ssid=`nvram_get 2860 SSID"$idx"_3572`
		ath_ssid=${ath_ssid:-DrayTek"$idx"-11AC}
		
		iwconfig ath$i essid $ath_ssid mode master freq 0
		
		ath_hide=`nvram_get 2860 HideSSID_3572 | cut -d ';' -f$idx`
		ath_hide="${ath_hide:-0}"
		$DEBUG iwpriv ath$i hide_ssid $ath_hide
		
		ath_mode=`nvram_get 2860 WirelessMode_3572`
		ath_mode="${ath_mode:-8}"
		ath_htbw=`nvram_get 2860 HT_BW_3572`	# 0:20; 1:20/40; 2:20/40/80
		ath_htbw="${ath_htbw:-0}"
		
		ath_bridge=`nvram_get 2860 APBridge"$idx"_3572`	# isolate member
		$DEBUG iwpriv ath$i ap_bridge ${ath_bridge:-1}
			
		case "$ath_mode" in
				2)	# 11a
					$DEBUG iwpriv ath$i mode 11A
					$DEBUG iwpriv ath$i puren 0
				;;
				8|11)	# 11a/n or 11n
					if [ "$ath_htbw" == "0" ]; then # 20 MHz
						$DEBUG iwpriv ath$i mode 11NAHT20
					else	# 20/40 MHz
						case "$ath_channel" in
						36|44|52|60|100|108|116|124|132|149|157)
							$DEBUG iwpriv ath$i mode 11NAHT40PLUS
						;;
						40|48|56|64|104|112|120|128|136|153|161)
							$DEBUG iwpriv ath$i mode 11NAHT40MINUS
						;;
						0|*)
							$DEBUG iwpriv ath$i mode 11NAHT40
						;;
						esac
					fi
					if [ "$ath_mode" == "11" ]; then # 11n only
						$DEBUG iwpriv ath$i puren 1
					else
						$DEBUG iwpriv ath$i puren 0
					fi
				;;
				18|*)	# 11a/n/ac
					if [ "$ath_htbw" == "0" ]; then # 20 MHz
						$DEBUG iwpriv ath$i mode 11ACVHT20
					elif [ "$ath_htbw" == "1" ]; then	# 20/40 MHz
						case "$ath_channel" in
						36|44|52|60|100|108|116|124|132)
							$DEBUG iwpriv ath$i mode 11ACVHT40PLUS
						;;
						40|48|56|64|104|112|120|128|136)
							$DEBUG iwpriv ath$i mode 11ACVHT40MINUS
						;;
						0|*)
							$DEBUG iwpriv ath$i mode 11ACVHT40
						;;
						esac
					else	# 20/40/80
						$DEBUG iwpriv ath$i mode 11ACVHT80
					fi
					$DEBUG iwpriv ath$i puren 0
				;;
		esac
		

	echo "
interface=ath$i
bridge=br0
#driver=atheros
ssid=$ath_ssid
logger_syslog=-1
logger_syslog_level=4
logger_stdout=-1
logger_stdout_level=4
# dump_file=/tmp/hostapd.dump 
# ctrl_interface=/var/run/hostapd2
# ctrl_interface_group=0
# hw_mode=a
# channel=36
# ieee80211d=1
# country_code=TW
# ieee80211n=1
# ht_capab=[HT40+]
# ieee80211h=1
# ieee80211ac=1
# vht_oper_chwidth=1
# vht_oper_centr_freq_seg0_idx=42
" > $hostapd_conf	
		
		############################## set security
		ath_Auth=`nvram_get 2860 AuthMode_3572 | cut -d ';' -f$idx`	# 
		ath_Auth="${ath_Auth:-OPEN}"
		case "$ath_Auth" in
			OPEN)
				ath_WPA=0
			;;
			WPAPSK)
				echo "wpa=1" >> $hostapd_conf
				echo "wpa_key_mgmt=WPA-PSK" >> $hostapd_conf
			;;
			WPA2PSK)
				echo "wpa=2" >> $hostapd_conf
				echo "wpa_key_mgmt=WPA-PSK" >> $hostapd_conf
			;;
			WPAPSKWPA2PSK)
				echo "wpa=3" >> $hostapd_conf
				echo "wpa_key_mgmt=WPA-PSK" >> $hostapd_conf
			;;
			WEPAUTO)
				echo "auth_algs=3" >> $hostapd_conf
			;;
			WPA)
				echo "wpa=1" >> $hostapd_conf	
			;;		
			WPA2)
				echo "wpa=2" >> $hostapd_conf
				
				ath_roam=`nvram_get 2860 WirelessRoaming5G_en`
				ath_roam="${ath_roam:-0}"
				#if [ "$ath_roam" == "1" ]; then	#  for roaming menu?
					ath_PreAuth=`nvram_get 2860 PreAuth_3572 | cut -d ';' -f$idx`
					echo "rsn_preauth=${ath_PreAuth:-1}" >> $hostapd_conf
					
					ath_PMKcache=`nvram_get 2860 PMKCachePeriod_3572 | cut -d ';' -f$idx`
					echo "r0_key_lifetime=${ath_PMKcache:-10}" >> $hostapd_conf
				#fi
			;;
			WPA1WPA2)
				echo "wpa=3" >> $hostapd_conf			
			;;		
		esac

		################# for WPA 802.1x 
		case "$ath_Auth" in
			WPA|WPA2|WPA1WPA2)
				echo "wpa_key_mgmt=WPA-EAP" >> $hostapd_conf	
				echo "ieee8021x=1" >> $hostapd_conf
				echo "own_ip_addr=`nvram_get 2860 lan_ipaddr`" >> $hostapd_conf
				echo "radius_acct_interim_interval=600" >> $hostapd_conf
				
				ath_RAsrv=`nvram_get 2860 RADIUS_Server_3572 | cut -d ';' -f$idx`
				echo "auth_server_addr=$ath_RAsrv" >> $hostapd_conf		# RADIUS_Server_3572=0;0;3.3.3.3;127.0.0.1
				ath_RAport=`nvram_get 2860 RADIUS_Port_3572 | cut -d ';' -f$idx`
				echo "auth_server_port=$ath_RAport" >> $hostapd_conf				# RADIUS_Port_3572
				ath_RAKey=`nvram_get 2860 RADIUS_Key"$idx"_3572`
				echo "auth_server_shared_secret=$ath_RAKey" >> $hostapd_conf			# RADIUS_Key3_3572
				echo "### auth_server_session_timeout=3600" >> $hostapd_conf			
				#auth_server_addr=6.6.6.6
				#auth_server_port=1812
				#auth_server_shared_secret=rrrr
				#auth_server_session_timeout=3600
				#acct_server_addr=6.6.6.6
				#acct_server_port=1813
				#acct_server_shared_secret=rrrr					
			;;
		esac
		
		################### for Encrypt
		ath_Enc=`nvram_get 2860 EncrypType_3572 | cut -d ';' -f$idx`	# 
		ath_Enc="${ath_Enc:-NONE}"
		case "$ath_Auth" in
			OPEN)
				case "$ath_Enc" in
					WEP)	# for WEP 802.1x
						echo "wep_key_len_broadcast=13" >> $hostapd_conf
						echo "wep_key_len_unicast=13" >> $hostapd_conf
						
						echo "ieee8021x=1" >> $hostapd_conf
						echo "own_ip_addr=`nvram_get 2860 lan_ipaddr`" >> $hostapd_conf
						echo "radius_acct_interim_interval=600" >> $hostapd_conf
						
						ath_RAsrv=`nvram_get 2860 RADIUS_Server_3572 | cut -d ';' -f$idx`
						echo "auth_server_addr=$ath_RAsrv" >> $hostapd_conf		# RADIUS_Server_3572=0;0;3.3.3.3;127.0.0.1
						ath_RAport=`nvram_get 2860 RADIUS_Port_3572 | cut -d ';' -f$idx`
						echo "auth_server_port=$ath_RAport" >> $hostapd_conf				# RADIUS_Port_3572
						ath_RAKey=`nvram_get 2860 RADIUS_Key"$idx"_3572`
						echo "auth_server_shared_secret=$ath_RAKey" >> $hostapd_conf			# RADIUS_Key3_3572
						echo "#### auth_server_session_timeout=3600" >> $hostapd_conf								
					;;
					NONE) # no security
						echo "auth_algs=1" >> $hostapd_conf
					;;
				esac
			;;
			WPAPSK|WPA2PSK|WPAPSKWPA2PSK|WPA|WPA2|WPA1WPA2)

				ath_Key=`nvram_get 2860 WPAPSK"$idx"_3572`	# 
				ath_Key="${ath_Key:-FIX_ME_NOKEY????}"	

				case "$ath_Enc" in
					TKIP|tkip)
						echo "wpa_pairwise=TKIP" >> $hostapd_conf
					;;
					AES|aes)
						echo "wpa_pairwise=CCMP" >> $hostapd_conf
					;;
					TKIPAES|tkipaes|*)
						echo "wpa_pairwise=TKIP CCMP" >> $hostapd_conf
					;;
				esac
				if [ "$ath_Auth" = "WPAPSK" -o "$ath_Auth" = "WPA2PSK" -o "$ath_Auth" = "WPAPSKWPA2PSK" ]; then 
					echo "wpa_passphrase=$ath_Key" >> $hostapd_conf	
				fi
				
				ath_RekeyInt=`nvram_get 2860 RekeyInterval_3572 | cut -d ';' -f$idx`
				echo "wpa_group_rekey=${ath_RekeyInt:-600}" >> $hostapd_conf
							
			;;
			WEPAUTO) # WEP
				ath_Key1Typ=`nvram_get 2860 Key1Type_3572 | cut -d ';' -f$idx`	# 0: HEX; 1:ASCII
				ath_Key1=`nvram_get 2860 Key1Str"$idx"_3572`
				if [ "$ath_Key1Typ" == "1" ]; then 
					echo "${ath_Key1:+wep_key0=\"$ath_Key1\"}" >> $hostapd_conf	
				else
					echo "${ath_Key1:+wep_key0=$ath_Key1}" >> $hostapd_conf	
				fi
				
				ath_Key2Typ=`nvram_get 2860 Key2Type_3572 | cut -d ';' -f$idx`	# 
				ath_Key2=`nvram_get 2860 Key2Str"$idx"_3572`
				if [ "$ath_Key2Typ" == "1" ]; then 
					echo "${ath_Key2:+wep_key1=\"$ath_Key2\"}" >> $hostapd_conf	
				else
					echo "${ath_Key2:+wep_key1=$ath_Key2}" >> $hostapd_conf	
				fi			
				
				ath_Key3Typ=`nvram_get 2860 Key3Type_3572 | cut -d ';' -f$idx`	# 
				ath_Key3=`nvram_get 2860 Key3Str"$idx"_3572`
				if [ "$ath_Key3Typ" == "1" ]; then 
					echo "${ath_Key3:+wep_key2=\"$ath_Key3\"}" >> $hostapd_conf	
				else
					echo "${ath_Key3:+wep_key2=$ath_Key3}" >> $hostapd_conf	
				fi
				
				ath_Key4Typ=`nvram_get 2860 Key4Type_3572 | cut -d ';' -f$idx`	# 
				ath_Key4=`nvram_get 2860 Key4Str"$idx"_3572`
				if [ "$ath_Key4Typ" == "1" ]; then 
					echo "${ath_Key4:+wep_key3=\"$ath_Key4\"}" >> $hostapd_conf	
				else
					echo "${ath_Key4:+wep_key3=$ath_Key4}" >> $hostapd_conf	
				fi
				
				ath_defKey=`nvram_get 2860 DefaultKeyID_3572 | cut -d ';' -f$idx`	# 1 based
				ath_defKey="${ath_defKey:-2}"
				ath_defKey=`expr $ath_defKey - 1`	# change to 0 base
				echo "wep_default_key=$ath_defKey" >> $hostapd_conf	
			;;
		esac
		
		
		if [ "$ath_Auth" = "WPAPSK" -o "$ath_Auth" = "WPA2PSK" -o "$ath_Auth" = "WPAPSKWPA2PSK" ]; then 
			echo "ctrl_interface=/var/run/hostapd" >> $hostapd_conf	 # for hostapd_cli
			################ for WPS ###################
			ath_WPS=`nvram_get 2860 WscModeOption_3572`
			ath_WPS="${ath_WPS:-1}"
			if [ "$idx" == "1" -a "$ath_WPS" != "0" ]; then	# WPS only for ath0
				echo "# for WPS #
eap_server=1
wps_state=2	# 2 = WPS enabled, configured
ap_setup_locked=0
wps_pin_requests=/var/run/hostapd.pin-req
device_name=Generic Wireless Gigabit AP
manufacturer=DrayTek
model_name=AP910C
model_number=Generic Wireless Gigabit AP
serial_number=000000000
device_type=6-0050F204-1
os_version=01020300
#uuid=12345678-9abc-def0-1234-56789abcdef0
#ap_pin=88767918
config_methods=label display push_button keypad physical_push_button virtual_push_button
hw_mode=a
upnp_iface=br0
friendly_name=Wireless Gigabit AP
manufacturer_url=http://www.draytek.com/
model_description=Wireless Gigabit AP
model_url=http://www.draytek.com/
upc=123456789012
pbc_in_m1=1" >> $hostapd_conf
			fi
			# trigger WPS
			# hostapd_cli -i ath0 wps_pbc
			# hostapd_cli -i ath0 wps_pin any 73538417
		fi	# end of WPS
		
		brctl addif br0 ath$i
		iwconfig ath$i freq $ath_channel
		/bin/hostapd -B /tmp/hostapd$idx.conf
	done 
	
	if [ "$ath_RadioOff" == "0" ]; then
		wifi_acl	# set mac ACL
		wifi_wmm	# config wmm after hostapd
	fi
}


case "$1" in
	reload) wifi_updown "reload";;
	acl) wifi_acl;;
	wmm) wifi_wmm;;
	*) wifi_updown "boot";;
esac
