#!/bin/sh

wanmode=`nvram_get 2860 wanConnectionMode`

ApCliSetWAN()
{
    wan_if="apcli0"

    if [ "$wanmode" = "STATIC" ]; then
	  echo "config-apcli.sh set STATIC"
	  ip=`nvram_get 2860 wan_ipaddr`
	  nm=`nvram_get 2860 wan_netmask`
	  gw=`nvram_get 2860 wan_gateway`
	  ifconfig $wan_if $ip netmask $nm
	  route del default
	  if [ "$gw" != "" ]; then
	    route add default gw $gw
	  fi
	  killall udhcpc.sh
	  udhcpc.sh $wanmode &
	else
	  echo "config-apcli.sh set DHCP"
	  killall -q udhcpc_apcli
	  host=`nvram_get 2860 HostName`
	  if [ "$host" == "" ]; then
	    host="AP900"
	  fi
      
      wan_ip=`ifconfig $wan_if | grep "inet addr" | sed 's/.*inet addr:\(.*\)  Bcast.*/\1/'`
      [ "$wan_ip" ] && OPT_r="-r $wan_ip"
	  udhcpc_apcli -i $wan_if $OPT_r -s /sbin/udhcpc.sh -H $host -p /var/run/udhcpc_apcli.pid &
	fi
}

ApCliSetWAN_5G()
{
    wan_if_5g="apclii0"

    if [ "$wanmode_5g" = "STATIC" ]; then
	  echo "config-apcli.sh set 5G STATIC"
	  ip=`nvram_get 2860 wan_ipaddr_5g`
	  nm=`nvram_get 2860 wan_netmask_5g`
	  gw=`nvram_get 2860 wan_gateway_5g`
	  ifconfig $wan_if_5g $ip netmask $nm
	  route del default
	  if [ "$gw" != "" ]; then
	    route add default gw $gw
	  fi
	  killall udhcpc.sh
	  udhcpc.sh $wanmode &
	else
	  echo "config-apcli.sh set 5G DHCP"
	  killall -q udhcpc_apcli
	  host=`nvram_get 2860 HostName`
	  if [ "$host" == "" ]; then
	    host="AP900"
	  fi
	  udhcpc_apcli -i $wan_if_5g -s /sbin/udhcpc.sh -H $host -p /var/run/udhcpc_apcli.pid &
	fi
}

if [ "$1" == "SetApCliWAN" ]; then
	ApCliSetWAN
	exit
fi

if [ "$1" == "SetApCliWAN_5G" ]; then
	ApCliSetWAN_5G
	exit
fi
